/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.UserInfoService;
import com.tydic.fsc.settle.bo.FscPageReqBo;
import com.tydic.fsc.settle.busi.api.BusiQueryBillApplyInfoXbjService;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryBillApplyInfoDetailXbjRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryBillApplyInfoXbjReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryBillApplyInfoXbjRspBO;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.SaleInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.po.SaleInvoiceInfo;
import com.tydic.fsc.settle.dao.vo.BillApplyInfoVO;
import com.tydic.fsc.settle.dao.vo.SaleInvoiceInfoVO;
import com.tydic.fsc.settle.enums.BillStatus;
import com.tydic.fsc.settle.enums.InquiryPayFeeType;
import com.tydic.fsc.settle.enums.InvoiceClasses;
import com.tydic.fsc.settle.enums.InvoiceType;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.YesNo;
import com.tydic.fsc.settle.utils.FileUtils;
import com.tydic.fsc.settle.utils.FscStringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiQueryBillApplyInfoXbjServiceImpl
implements BusiQueryBillApplyInfoXbjService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQueryBillApplyInfoXbjServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private UserInfoService userInfoService;

    public BusiQueryBillApplyInfoXbjRspBO query(BusiQueryBillApplyInfoXbjReqBO reqBO) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u670d\u52a1(\u8be2\u6bd4\u4ef7)(\u4e13\u4e1a\u516c\u53f8\u548c\u4f9b\u5e94\u5546\u5171\u7528)\u5165\u53c2\uff1a" + reqBO);
        }
        BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)billApplyInfoVO);
        billApplyInfoVO.setSource(OrderSource.CONSULT_PRICE.getCode());
        if (reqBO.getSupId() != null && reqBO.getSupId() > 0L) {
            billApplyInfoVO.setSupplierNo(reqBO.getSupId());
        } else {
            billApplyInfoVO.setOperUnitNo(reqBO.getCompanyId());
        }
        if (billApplyInfoVO.getApplyDateEnd() != null) {
            try {
                String applyDateEndString = new SimpleDateFormat("yyyy-MM-dd").format(billApplyInfoVO.getApplyDateEnd()) + " 23:59:59";
                billApplyInfoVO.setApplyDateEnd(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(applyDateEndString));
            }
            catch (ParseException e) {
                throw new BusinessException("1002", "\u683c\u5f0f\u5316\u65e5\u671f\u51fa\u9519");
            }
        }
        billApplyInfoVO.setReturnBillNoIsNull("1");
        String orderBy = FscStringUtils.obtainOrderBy((FscPageReqBo)reqBO, "d_bill_apply_info", "t.APPLY_DATE DESC");
        billApplyInfoVO.setOrderBy(orderBy);
        if (null != reqBO.getInquiryPayFeeType()) {
            billApplyInfoVO.setPayFeeType(reqBO.getInquiryPayFeeType());
        } else {
            ArrayList<String> payFeeTypeList = new ArrayList<String>();
            payFeeTypeList.add(InquiryPayFeeType.TRADE_SERVICE_FEE.getCode());
            payFeeTypeList.add(InquiryPayFeeType.PURCH_SERVICE_FEE.getCode());
            billApplyInfoVO.setPayFeeTypeList(payFeeTypeList);
        }
        Set billStatusSet = reqBO.getBillStatusSet();
        if (!CollectionUtils.isEmpty((Collection)billStatusSet)) {
            if (billStatusSet.contains(BillStatus.SEND_BILL.getCode())) {
                billStatusSet.add(BillStatus.INVOICE_INVALID.getCode());
                billStatusSet.add(BillStatus.INVOICE_RETURN_PART.getCode());
                billStatusSet.add(BillStatus.INVOICE_RETURN.getCode());
            }
            billApplyInfoVO.setBillStatusSet(billStatusSet);
        }
        if (null != reqBO.getUserNameLike() && StringUtils.hasText((String)reqBO.getUserNameLike())) {
            List<Long> userIdList = this.userInfoService.queryUserIdListByUserNameLike(reqBO.getUserNameLike());
            if (userIdList.isEmpty()) {
                userIdList.add(-1L);
            }
            billApplyInfoVO.setUserIdList(userIdList);
        }
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<BillApplyInfo> billApplyInfoList = this.billApplyInfoMapper.getListPage(billApplyInfoVO, (Page<Map<String, Object>>)page);
        ArrayList<BusiQueryBillApplyInfoDetailXbjRspBO> rows = new ArrayList<BusiQueryBillApplyInfoDetailXbjRspBO>();
        for (BillApplyInfo billApplyInfo : billApplyInfoList) {
            BusiQueryBillApplyInfoDetailXbjRspBO row = new BusiQueryBillApplyInfoDetailXbjRspBO();
            BeanUtils.copyProperties((Object)billApplyInfo, (Object)row);
            row.setBillStatusDescr(this.enumsService.getDescr(BillStatus.getInstance(billApplyInfo.getBillStatus())));
            row.setInvoiceClassesDescr(this.enumsService.getDescr(InvoiceClasses.getInstance(billApplyInfo.getInvoiceClasses())));
            row.setInvoiceTypeDescr(this.enumsService.getDescr(InvoiceType.getInstance(Integer.valueOf(billApplyInfo.getInvoiceType()))));
            SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
            saleInvoiceInfoVO.setApplyNo(billApplyInfo.getApplyNo());
            List<SaleInvoiceInfo> saleInvoiceInfoList = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
            if (!CollectionUtils.isEmpty(saleInvoiceInfoList)) {
                row.setInvoiceUrl(FileUtils.obtainOSSUrl(saleInvoiceInfoList.get(0).getElectronicInvoiceName()));
                row.setElectronicInvoiceName(saleInvoiceInfoList.get(0).getElectronicInvoiceName());
            }
            if (StringUtils.hasText((String)row.getBillNo()) && !"0".equals(row.getBillNo())) {
                row.setYesNoDescr(this.enumsService.getDescr(YesNo.getInstance(YesNo.YES.getCode())));
            } else {
                row.setYesNoDescr(this.enumsService.getDescr(YesNo.getInstance(YesNo.NO.getCode())));
            }
            row.setPushPeopleName(this.userInfoService.queryUserNameByUserId(billApplyInfo.getPushPeopleId()));
            row.setUserName(this.userInfoService.queryUserNameByUserId(billApplyInfo.getUserId()));
            rows.add(row);
        }
        BusiQueryBillApplyInfoXbjRspBO rspBO = new BusiQueryBillApplyInfoXbjRspBO();
        rspBO.setRows(rows);
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(page.getPageNo());
        return rspBO;
    }
}

