/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.bo.FscPageRspBo;
import com.tydic.fsc.settle.busi.api.BusiQueryOutInvoiceService;
import com.tydic.fsc.settle.busi.api.bo.OutInvoiceInfoRepBO;
import com.tydic.fsc.settle.busi.api.bo.OutInvoiceInfoRspBO;
import com.tydic.fsc.settle.busi.impl.QueryEntryInfoServiceImpl;
import com.tydic.fsc.settle.dao.OutstockTotalMapper;
import com.tydic.fsc.settle.dao.SaleInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.po.OutInvoicePO;
import com.tydic.fsc.settle.dao.po.OutstockTotal;
import com.tydic.fsc.settle.enums.InvoiceType;
import com.tydic.fsc.settle.utils.AmountUtils;
import com.tydic.fsc.settle.utils.AntiSqlInjectionManage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiQueryOutInvoiceServiceImpl
implements BusiQueryOutInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(QueryEntryInfoServiceImpl.class);
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OutstockTotalMapper outstockTotalMapper;

    public List<OutInvoiceInfoRspBO> queryOutInvoice(String totalNo) {
        ArrayList<OutInvoiceInfoRspBO> outInvoiceInfoRspBO = new ArrayList<OutInvoiceInfoRspBO>();
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5165\u5e93\u5355\u53d1\u7968\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a" + totalNo);
        }
        if (totalNo == null) {
            throw new BusinessException("1002", "\u6c47\u603b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OutstockTotal outstockTotal = this.outstockTotalMapper.selectByPrimaryKey(totalNo);
        if (null == outstockTotal) {
            throw new BusinessException("RSP_CODE_DATA_NULL", "\u6839\u636e\u51fa\u5e93\u6c47\u603b\u5355\u53f7\uff1a" + totalNo + "\u627e\u4e0d\u5230\u51fa\u5e93\u6c47\u603b\u5355");
        }
        List<OutInvoicePO> outInvoicePO = this.saleInvoiceInfoMapper.selectByTotalNo(totalNo);
        if (null == outInvoicePO || outInvoicePO.isEmpty()) {
            return outInvoiceInfoRspBO;
        }
        for (OutInvoicePO outInvoicePOs : outInvoicePO) {
            OutInvoiceInfoRspBO outInvoiceInfoRspBOs = new OutInvoiceInfoRspBO();
            outInvoicePOs.setSupplierName(this.organizationInfoService.querySupplierName(outInvoicePOs.getSupplierNo()));
            outInvoicePOs.setInvoiceTypeName(this.enumsService.getDescr(InvoiceType.getInstance(outInvoicePOs.getInvoiceType())));
            BeanUtils.copyProperties((Object)outInvoicePOs, (Object)outInvoiceInfoRspBOs);
            if (outInvoiceInfoRspBOs.getTaxRate() != null && !outInvoiceInfoRspBOs.getTaxRate().equals("")) {
                outInvoiceInfoRspBOs.setTaxRate(outInvoiceInfoRspBOs.getTaxRate() + '%');
            }
            outInvoiceInfoRspBOs.setNotTaxAmtStr(AmountUtils.format(outInvoicePOs.getNotTaxAmt()));
            outInvoiceInfoRspBOs.setTaxAmtStr(AmountUtils.format(outInvoicePOs.getTaxAmt()));
            outInvoiceInfoRspBOs.setTotalNo(totalNo);
            outInvoiceInfoRspBOs.setOrgId(outstockTotal.getOrgId());
            outInvoiceInfoRspBO.add(outInvoiceInfoRspBOs);
        }
        logger.info("\u6210\u529f\u67e5\u8be2\u51fa\u6c47\u603b\u5355\u53f7\u5bf9\u5e94\u7684\u53d1\u7968");
        return outInvoiceInfoRspBO;
    }

    public FscPageRspBo<OutInvoiceInfoRspBO> queryPageOutInvoice(OutInvoiceInfoRepBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5165\u5e93\u5355\u53d1\u7968\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a" + reqBO.getApplyNo() + reqBO.getTotalNo());
        }
        if (reqBO.getTotalNo() == null || !StringUtils.hasText((String)reqBO.getTotalNo())) {
            throw new BusinessException("1002", "\u6c47\u603b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String orderBy = null;
        if (!StringUtils.isEmpty((Object)reqBO.getSortName()) && !StringUtils.isEmpty((Object)reqBO.getSortOrder())) {
            if (AntiSqlInjectionManage.sqlValidate(reqBO.getSortName()) || AntiSqlInjectionManage.sqlValidate(reqBO.getSortOrder())) {
                logger.error("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                throw new BusinessException("1002", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
            }
            orderBy = reqBO.getSortName() + " " + reqBO.getSortOrder();
        }
        if (!StringUtils.hasText(orderBy)) {
            orderBy = " t2.APPLY_NO asc,t2.INVOICE_NO asc";
        }
        ArrayList<OutInvoiceInfoRspBO> outInvoiceInfoRspBO = new ArrayList<OutInvoiceInfoRspBO>();
        FscPageRspBo rspPageBO = new FscPageRspBo();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<OutInvoicePO> outInvoicePO = null;
        if (reqBO.getApplyNo() == null || !StringUtils.hasText((String)reqBO.getApplyNo())) {
            try {
                outInvoicePO = this.saleInvoiceInfoMapper.selectListByTotalNo(reqBO.getTotalNo(), (Page<Map<String, Object>>)page, orderBy);
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u5165\u5e93\u5355\u53d1\u7968\u5931\u8d25\uff0c\u6c47\u603b\u7f16\u53f7\u4e3a\uff1a" + reqBO.getTotalNo(), (Throwable)e);
                throw new BusinessException("1002", "\u67e5\u8be2\u5165\u5e93\u5355\u53d1\u7968\u5931\u8d25");
            }
            if (null == outInvoicePO || outInvoicePO.isEmpty()) {
                logger.error("\u627e\u4e0d\u5230\u6c47\u603b\u5355\u53f7\u5bf9\u5e94\u7684\u53d1\u7968\u8bb0\u5f55\uff0c\u6c47\u603b\u5355\u53f7\u4e3a\uff1a" + reqBO.getTotalNo());
                return rspPageBO;
            }
            for (OutInvoicePO outInvoicePOs : outInvoicePO) {
                OutInvoiceInfoRspBO outInvoiceInfoRspBOs = new OutInvoiceInfoRspBO();
                outInvoicePOs.setSupplierName(this.organizationInfoService.querySupplierName(outInvoicePOs.getSupplierNo()));
                outInvoicePOs.setInvoiceTypeName(this.enumsService.getDescr(InvoiceType.getInstance(outInvoicePOs.getInvoiceType())));
                BeanUtils.copyProperties((Object)outInvoicePOs, (Object)outInvoiceInfoRspBOs);
                outInvoiceInfoRspBO.add(outInvoiceInfoRspBOs);
            }
            rspPageBO.setRows(outInvoiceInfoRspBO);
            rspPageBO.setRecordsTotal(page.getTotalCount());
            rspPageBO.setTotal(page.getTotalPages());
            rspPageBO.setPageNo(page.getPageNo());
            logger.info("\u6210\u529f\u67e5\u8be2\u51fa\u6c47\u603b\u5355\u53f7\u5bf9\u5e94\u7684\u53d1\u7968");
            return rspPageBO;
        }
        try {
            outInvoicePO = this.saleInvoiceInfoMapper.getListByApplyNo(reqBO.getApplyNo(), (Page<Map<String, Object>>)page, orderBy);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5165\u5e93\u5355\u53d1\u7968\u5931\u8d25\uff0c\u53d1\u7968\u901a\u77e5\u5355\u7f16\u53f7\u4e3a\uff1a" + reqBO.getApplyNo(), (Throwable)e);
            throw new BusinessException("1002", "\u67e5\u8be2\u5165\u5e93\u5355\u53d1\u7968\u5931\u8d25");
        }
        if (null == outInvoicePO || outInvoicePO.isEmpty()) {
            logger.error("\u627e\u4e0d\u5230\u53d1\u7968\u901a\u77e5\u5355\u5bf9\u5e94\u7684\u53d1\u7968\u8bb0\u5f55\uff0c\u53d1\u7968\u901a\u77e5\u5355\u4e3a\uff1a" + reqBO.getApplyNo());
            return rspPageBO;
        }
        for (OutInvoicePO outInvoicePOs : outInvoicePO) {
            OutInvoiceInfoRspBO outInvoiceInfoRspBOs = new OutInvoiceInfoRspBO();
            outInvoicePOs.setSupplierName(this.organizationInfoService.querySupplierName(outInvoicePOs.getSupplierNo()));
            outInvoicePOs.setInvoiceTypeName(this.enumsService.getDescr(InvoiceType.getInstance(outInvoicePOs.getInvoiceType())));
            BeanUtils.copyProperties((Object)outInvoicePOs, (Object)outInvoiceInfoRspBOs);
            outInvoiceInfoRspBO.add(outInvoiceInfoRspBOs);
        }
        rspPageBO.setRows(outInvoiceInfoRspBO);
        rspPageBO.setRecordsTotal(page.getTotalCount());
        rspPageBO.setTotal(page.getTotalPages());
        rspPageBO.setPageNo(page.getPageNo());
        logger.info("\u6210\u529f\u67e5\u8be2\u51fa\u6c47\u603b\u5355\u53f7\u5bf9\u5e94\u7684\u53d1\u7968");
        return rspPageBO;
    }
}

