/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.busi.api.BusiQueryOutstockDetailService;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryOutstockDetaiReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryOutstockDetaiRspBO;
import com.tydic.fsc.settle.busi.api.vo.OutstockDetailVO;
import com.tydic.fsc.settle.dao.OutstockDetailMapper;
import com.tydic.fsc.settle.dao.OutstockInfoMapper;
import com.tydic.fsc.settle.dao.po.OutstockDetail;
import com.tydic.fsc.settle.dao.po.OutstockInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiQueryOutstockDetailServiceImpl
implements BusiQueryOutstockDetailService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQueryOutstockDetailServiceImpl.class);
    @Autowired
    private OutstockDetailMapper outstockDetailMapper;
    @Autowired
    private OutstockInfoMapper outstockInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;

    public BusiQueryOutstockDetaiRspBO<OutstockDetailVO> queryOutstockDetail(BusiQueryOutstockDetaiReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u51fa\u5e93\u5355\u8be6\u60c5\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (null == reqBO.getOutstockNo() || !StringUtils.hasText((String)reqBO.getOutstockNo())) {
            throw new BusinessException("1002", "\u51fa\u5e93\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiQueryOutstockDetaiRspBO rspPageBO = new BusiQueryOutstockDetaiRspBO();
        String orderBy = "t.SEQ ASC";
        OutstockInfo outstackInfo = null;
        try {
            outstackInfo = this.outstockInfoMapper.selectByPrimaryKey(reqBO.getOutstockNo());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u51fa\u5e93\u5355\u53f7\u4e3a" + reqBO.getOutstockNo() + "\u8bb0\u5f55\u5931\u8d25");
            throw new BusinessException("1002", "\u67e5\u8be2\u51fa\u5e93\u5355\u53f7\u4e3a" + reqBO.getOutstockNo() + "\u8bb0\u5f55\u5931\u8d25");
        }
        BeanUtils.copyProperties((Object)outstackInfo, (Object)rspPageBO);
        String purchaseName = this.organizationInfoService.queryOrgName(outstackInfo.getPurchaseNo());
        rspPageBO.setPurchaseName(purchaseName);
        OutstockDetail outstockDetail = new OutstockDetail();
        outstockDetail.setOutstockNo(reqBO.getOutstockNo());
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<OutstockDetail> outstackDetailList = null;
        try {
            outstackDetailList = this.outstockDetailMapper.getListPage(outstockDetail, (Page<Map<String, Object>>)page, orderBy);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u5e93\u51fa\u5e93\u5355\u53f7\u5bf9\u5e94\u7684\u51fa\u5e93\u8be6\u60c5\u8bb0\u5f55\u5931\u8d25\uff0c\u51fa\u5e93\u5355\u53f7\u4e3a\uff1a" + reqBO.getOutstockNo(), (Throwable)e);
            throw new BusinessException("1002", "\u67e5\u8be2\u6570\u636e\u5e93\u51fa\u5e93\u5355\u53f7\u5bf9\u5e94\u7684\u51fa\u5e93\u8be6\u60c5\u8bb0\u5f55\u5931\u8d25");
        }
        if (outstackDetailList == null || outstackDetailList.isEmpty()) {
            return rspPageBO;
        }
        ArrayList<OutstockDetailVO> outstockDetailVOList = new ArrayList<OutstockDetailVO>();
        for (OutstockDetail returnOutstock : outstackDetailList) {
            OutstockDetailVO outstackDetailVO = new OutstockDetailVO();
            BeanUtils.copyProperties((Object)returnOutstock, (Object)outstackDetailVO);
            outstockDetailVOList.add(outstackDetailVO);
        }
        rspPageBO.setRows(outstockDetailVOList);
        rspPageBO.setRecordsTotal(page.getTotalCount());
        rspPageBO.setTotal(page.getTotalPages());
        rspPageBO.setPageNo(page.getPageNo());
        return rspPageBO;
    }
}

