/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.bo.FscPageReqBo;
import com.tydic.fsc.settle.busi.api.BusiQueryOutstockInfoService;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryOutstockInfoReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryOutstockInfoRspBO;
import com.tydic.fsc.settle.busi.api.bo.SaleOrderDetailInfoRspBO;
import com.tydic.fsc.settle.busi.api.vo.OutstockInfoVO;
import com.tydic.fsc.settle.dao.OutstockDetailMapper;
import com.tydic.fsc.settle.dao.OutstockInfoMapper;
import com.tydic.fsc.settle.dao.SaleOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.OutstockInfo;
import com.tydic.fsc.settle.dao.po.SaleOrderInfo;
import com.tydic.fsc.settle.dao.vo.QueryOutstockInfoVO;
import com.tydic.fsc.settle.dao.vo.SaleOrderInfoVO;
import com.tydic.fsc.settle.enums.BaseEnums;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.OutstockInfoStatus;
import com.tydic.fsc.settle.utils.FscStringUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiQueryOutstockInfoServiceImpl
implements BusiQueryOutstockInfoService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQueryOutstockInfoServiceImpl.class);
    @Autowired
    private OutstockInfoMapper outstockInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OutstockDetailMapper outstockDetailMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;

    public BusiQueryOutstockInfoRspBO<OutstockInfoVO> queryOutstockInfo(BusiQueryOutstockInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u51fa\u5e93\u5355\u67e5\u8be2\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (!StringUtils.hasText((String)reqBO.getSource())) {
            throw new BusinessException("1002", "\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String defaultOrderBy = "t.OUTSTOCK_NO DESC";
        String tableName = "d_outstock_info";
        String orderBy = FscStringUtils.obtainOrderBy((FscPageReqBo)reqBO, tableName, defaultOrderBy);
        BusiQueryOutstockInfoRspBO rspPageBO = new BusiQueryOutstockInfoRspBO();
        QueryOutstockInfoVO queryOutstockInfoVO = new QueryOutstockInfoVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)queryOutstockInfoVO);
        queryOutstockInfoVO.setCompanyOrg(reqBO.getCompanyId());
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<OutstockInfo> returnOutstockList = this.outstockInfoMapper.getListPage(queryOutstockInfoVO, (Page<Map<String, Object>>)page, orderBy);
        ArrayList<OutstockInfoVO> outstockVOList = new ArrayList<OutstockInfoVO>();
        for (OutstockInfo outstockInfoPO : returnOutstockList) {
            List<Long> inspectionIds;
            OutstockInfoVO outstockInfoVO = new OutstockInfoVO();
            BeanUtils.copyProperties((Object)outstockInfoPO, (Object)outstockInfoVO);
            String purchaseName = this.organizationInfoService.queryOrgName(outstockInfoPO.getPurchaseNo());
            outstockInfoVO.setPurchaseName(purchaseName);
            String statusDesc = this.enumsService.getDescr(OutstockInfoStatus.getInstance(outstockInfoPO.getStatus()));
            outstockInfoVO.setStatusDesc(statusDesc);
            String sourceDescr = this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)outstockInfoPO.getSource()));
            outstockInfoVO.setSourceDescr(sourceDescr);
            outstockInfoVO.setBranchCompanyName(this.organizationInfoService.queryOrgName(outstockInfoPO.getBranchCompany()));
            LinkedList<SaleOrderDetailInfoRspBO> saleOrderDetailList = new LinkedList<SaleOrderDetailInfoRspBO>();
            if (!("0".equals(this.enumsService.queryShowOrderCodeSwitch()) && OrderSource.ELECTRIC_MARKET.getCode().equals(outstockInfoPO.getSource()) || CollectionUtils.isEmpty(inspectionIds = this.outstockDetailMapper.selectInspectionIdList(outstockInfoPO.getOutstockNo())))) {
                SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
                saleOrderInfoVO.setInspectionIdList(inspectionIds);
                List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getList(saleOrderInfoVO);
                for (SaleOrderInfo orderInfo : saleOrderInfoList) {
                    SaleOrderDetailInfoRspBO detailRspBO = new SaleOrderDetailInfoRspBO();
                    detailRspBO.setInspectionId(orderInfo.getInspectionId());
                    detailRspBO.setSaleOrderCode(orderInfo.getSaleOrderCode());
                    detailRspBO.setSaleOrderName(orderInfo.getSaleOrderName());
                    saleOrderDetailList.add(detailRspBO);
                }
            }
            outstockInfoVO.setSaleOrderDetailList(saleOrderDetailList);
            outstockInfoVO.setPurchaseProjectName(this.organizationInfoService.queryProjectName(outstockInfoPO.getPurchaseProjectId()).getAccountName());
            outstockVOList.add(outstockInfoVO);
        }
        rspPageBO.setRows(outstockVOList);
        rspPageBO.setRecordsTotal(page.getTotalCount());
        rspPageBO.setTotal(page.getTotalPages());
        rspPageBO.setPageNo(page.getPageNo());
        return rspPageBO;
    }
}

