/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.busi.api.BusiQuerySaleOrderInfoByItemsService;
import com.tydic.fsc.settle.busi.api.bo.BusiQuerySaleOrderInfoByItemsReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQuerySaleOrderInfoByItemsRspBO;
import com.tydic.fsc.settle.busi.api.vo.SaleItemInfoExt;
import com.tydic.fsc.settle.dao.SaleItemInfoMapper;
import com.tydic.fsc.settle.dao.vo.SaleItemInfoVO;
import com.tydic.fsc.settle.enums.OrderStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiQuerySaleOrderInfoByItemsServiceImpl
implements BusiQuerySaleOrderInfoByItemsService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQuerySaleOrderInfoByItemsServiceImpl.class);
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private EnumsService enumsService;

    public BusiQuerySaleOrderInfoByItemsRspBO querySaleOrderInfoByItemsList(BusiQuerySaleOrderInfoByItemsReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u7533\u8bf7\u5f00\u7968\u62c6\u5206\u5546\u54c1\u660e\u7ec6\u5165\u53c2reqBO:" + reqBO);
        }
        if (reqBO == null) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List inspectionIds = reqBO.getInspectionIds();
        if (CollectionUtils.isEmpty((Collection)inspectionIds)) {
            throw new BusinessException("1001", "\u8bf7\u9009\u62e9\u9a8c\u6536\u5355\u4e0d\u4e3a\u7a7a\u7684\u8ba2\u5355\u6570\u636e");
        }
        SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
        saleItemInfoVO.setSkuName(reqBO.getSkuName());
        saleItemInfoVO.setTaxRate(reqBO.getTaxRate());
        saleItemInfoVO.setSaleOrderCode(reqBO.getSaleOrderCode());
        saleItemInfoVO.setApplyAmountMin(reqBO.getApplyAmountMin());
        saleItemInfoVO.setApplyAmountMax(reqBO.getApplyAmountMax());
        saleItemInfoVO.setOrderDateBegin(reqBO.getOrderDateBegin());
        saleItemInfoVO.setOrderDateEnd(reqBO.getOrderDateEnd());
        saleItemInfoVO.setItemStatus(OrderStatus.NO_APPLY.getCode());
        saleItemInfoVO.setInspectionIdList(inspectionIds);
        saleItemInfoVO.setOrderAmtMin(reqBO.getOrderAmtMin());
        saleItemInfoVO.setOrderAmtMax(reqBO.getOrderAmtMax());
        saleItemInfoVO.setOrderBy(" o.ORDER_ID, o.INSPECTION_ID DESC");
        ArrayList<SaleItemInfoExt> rows = new ArrayList<SaleItemInfoExt>();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<SaleItemInfoVO> dataList = this.saleItemInfoMapper.querySaleJoinOrderItemsPage(saleItemInfoVO, (Page<Map<String, Object>>)page);
        for (SaleItemInfoVO saleVO : dataList) {
            SaleItemInfoExt saleExtBO = new SaleItemInfoExt();
            BeanUtils.copyProperties((Object)saleVO, (Object)saleExtBO);
            saleExtBO.setItemStatusDescr(this.enumsService.getDescr(OrderStatus.getInstance(saleVO.getItemStatus())));
            rows.add(saleExtBO);
        }
        BusiQuerySaleOrderInfoByItemsRspBO rspPageBO = new BusiQuerySaleOrderInfoByItemsRspBO();
        rspPageBO.setRows(rows);
        rspPageBO.setRecordsTotal(page.getTotalCount());
        rspPageBO.setTotal(page.getTotalPages());
        rspPageBO.setPageNo(page.getPageNo());
        return rspPageBO;
    }
}

