/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.DictionaryAtomService;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.bo.DictionaryAtomReqBo;
import com.tydic.fsc.settle.atom.bo.DictionaryAtomRspBo;
import com.tydic.fsc.settle.busi.api.BusiQuerySaleOrderInfoService;
import com.tydic.fsc.settle.busi.api.bo.BusiQuerySaleOrderInfoItemRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQuerySaleOrderInfoOrderRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQuerySaleOrderInfoReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQuerySaleOrderInfoRspBO;
import com.tydic.fsc.settle.dao.SaleItemInfoMapper;
import com.tydic.fsc.settle.dao.SaleOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.SaleItemInfo;
import com.tydic.fsc.settle.dao.po.SaleOrderInfo;
import com.tydic.fsc.settle.dao.vo.SaleItemInfoVO;
import com.tydic.fsc.settle.dao.vo.SaleOrderInfoVO;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.OrderStatus;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiQuerySaleOrderInfoServiceImpl
implements BusiQuerySaleOrderInfoService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQuerySaleOrderInfoServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private DictionaryAtomService dictionaryAtomService;
    private static final Logger LOGGER = LoggerFactory.getLogger(BusiQuerySaleOrderInfoServiceImpl.class);

    public BusiQuerySaleOrderInfoRspBO query(BusiQuerySaleOrderInfoReqBO reqBO) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u670d\u52a1(\u7535\u5b50\u8d85\u5e02)(\u4e13\u4e1a\u516c\u53f8\u548c\u91c7\u8d2d\u5355\u4f4d\u5171\u7528)\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getIsOperUnit())) {
            throw new BusinessException("1001", "\u662f\u5426\u4e13\u4e1a\u516c\u53f8\u7528\u6237\u3010isOperUnit\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("0".equals(reqBO.getIsOperUnit()) && null == reqBO.getPurchaseProjectId()) {
            throw new BusinessException("1001", "\u91c7\u8d2d\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String saleOrderCode = reqBO.getSaleOrderCode();
        ArrayList<String> saleOrderCodeList = new ArrayList<String>();
        if (StringUtils.hasText((String)saleOrderCode)) {
            try {
                for (String element : saleOrderCode.split(",")) {
                    saleOrderCodeList.add(element);
                }
            }
            catch (Exception e) {
                throw new BusinessException("1001", "\u8ba2\u5355\u7f16\u53f7\u3010orderId\u3011\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
        }
        SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)saleOrderInfoVO);
        if ("1".equals(reqBO.getIsOperUnit())) {
            saleOrderInfoVO.setOperUnitNo(reqBO.getCompanyId());
        }
        saleOrderInfoVO.setSource(OrderSource.ELECTRIC_MARKET.getCode());
        saleOrderInfoVO.setOrderStatus(OrderStatus.NO_APPLY.getCode());
        if (saleOrderInfoVO.getOrderDateEnd() != null) {
            try {
                String orderDateEndString = new SimpleDateFormat("yyyy-MM-dd").format(saleOrderInfoVO.getOrderDateEnd()) + " 23:59:59";
                saleOrderInfoVO.setOrderDateEnd(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(orderDateEndString));
            }
            catch (ParseException e) {
                throw new BusinessException("1002", "\u683c\u5f0f\u5316\u65e5\u671f\u51fa\u9519");
            }
        }
        if (!saleOrderCodeList.isEmpty()) {
            saleOrderInfoVO.setSaleOrderCodeList(saleOrderCodeList);
        }
        saleOrderInfoVO.setOrderBy("t.ORDER_ID DESC,t.INSPECTION_ID DESC");
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getListPageJoin(saleOrderInfoVO, (Page<Map<String, Object>>)page);
        ArrayList<BusiQuerySaleOrderInfoOrderRspBO> orderList = new ArrayList<BusiQuerySaleOrderInfoOrderRspBO>();
        for (SaleOrderInfo saleOrderInfo : saleOrderInfoList) {
            SaleItemInfoVO vo = new SaleItemInfoVO();
            vo.setInspectionId(saleOrderInfo.getInspectionId());
            List<SaleItemInfo> saleItemInfoList = this.saleItemInfoMapper.getList(vo);
            ArrayList<BusiQuerySaleOrderInfoItemRspBO> itemList = new ArrayList<BusiQuerySaleOrderInfoItemRspBO>();
            for (SaleItemInfo saleItemInfo : saleItemInfoList) {
                BusiQuerySaleOrderInfoItemRspBO item = new BusiQuerySaleOrderInfoItemRspBO();
                BeanUtils.copyProperties((Object)saleItemInfo, (Object)item);
                item.setSeq(String.valueOf(saleItemInfo.getSeq()));
                item.setItemNo(String.valueOf(saleItemInfo.getItemNo()));
                try {
                    DictionaryAtomReqBo dictionaryAtomReqBo = new DictionaryAtomReqBo();
                    dictionaryAtomReqBo.setpCode("D_SALE_ORDER_INFO_ORDER_STATUS");
                    DictionaryAtomRspBo dicRspBO = this.dictionaryAtomService.qryDic(dictionaryAtomReqBo);
                    if (dicRspBO != null) {
                        Map<String, String> map = dicRspBO.getData();
                        item.setItemStatusDescr(map.get(saleItemInfo.getItemStatus()));
                    }
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                    throw new BusinessException("8888", "\u5931\u8d25");
                }
                itemList.add(item);
            }
            BusiQuerySaleOrderInfoOrderRspBO order = new BusiQuerySaleOrderInfoOrderRspBO();
            BeanUtils.copyProperties((Object)saleOrderInfo, (Object)order);
            order.setOrderId(String.valueOf(saleOrderInfo.getOrderId()));
            order.setInspectionId(String.valueOf(saleOrderInfo.getInspectionId()));
            try {
                DictionaryAtomReqBo dictionaryAtomReqBo = new DictionaryAtomReqBo();
                dictionaryAtomReqBo.setpCode("D_SALE_ORDER_INFO_ORDER_STATUS");
                DictionaryAtomRspBo dicRspBO = this.dictionaryAtomService.qryDic(dictionaryAtomReqBo);
                if (dicRspBO != null) {
                    Map<String, String> map = dicRspBO.getData();
                    order.setOrderStatusDescr(map.get(saleOrderInfo.getOrderStatus()));
                }
                dictionaryAtomReqBo = new DictionaryAtomReqBo();
                dictionaryAtomReqBo.setpCode("ORDER_SOURCE");
                DictionaryAtomRspBo dicRspBO1 = this.dictionaryAtomService.qryDic(dictionaryAtomReqBo);
                if (dicRspBO1 != null) {
                    Map<String, String> map = dicRspBO1.getData();
                    order.setSourceDescr(map.get(saleOrderInfo.getSource()));
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new BusinessException("8888", "\u5931\u8d25");
            }
            order.setItemInfos(itemList);
            order.setPurchaseProjectName(this.organizationInfoService.queryProjectName(saleOrderInfo.getPurchaseProjectId()).getAccountName());
            orderList.add(order);
        }
        BusiQuerySaleOrderInfoRspBO rspBO = new BusiQuerySaleOrderInfoRspBO();
        rspBO.setRows(orderList);
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(page.getPageNo());
        return rspBO;
    }
}

