/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.WorkFlowFinishEvent;
import com.tydic.fsc.settle.busi.api.FscWfEndDealSynchFinanceBusiService;
import com.tydic.fsc.settle.busi.api.bo.FscWfEndDealSynchFinanceBusiReqBO;
import com.tydic.fsc.settle.busi.api.bo.FscWfEndDealSynchFinanceBusiRspBO;
import com.tydic.fsc.settle.busi.api.bo.WorkFlowDataInfoBO;
import com.tydic.fsc.settle.dao.WorkFlowDataMapper;
import com.tydic.fsc.settle.dao.po.WorkFlowDataInfo;
import com.tydic.fsc.settle.dao.vo.WFEventResult;
import com.tydic.fsc.settle.enums.FinancialStatus;
import com.tydic.fsc.settle.enums.WFBillType;
import com.tydic.fsc.settle.utils.SpringApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.StringUtils;

@Service(value="fscWfEndDealSynchFinanceBusiService")
public class FscWfEndDealSynchFinanceBusiServiceImpl
implements FscWfEndDealSynchFinanceBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscWfEndDealSynchFinanceBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private WorkFlowDataMapper workFlowDataMapper;

    @Autowired
    private FscWfEndDealSynchFinanceBusiServiceImpl(WorkFlowDataMapper workFlowDataMapper) {
        this.workFlowDataMapper = workFlowDataMapper;
    }

    public FscWfEndDealSynchFinanceBusiRspBO dealWfEndWithoutSynchFinance(FscWfEndDealSynchFinanceBusiReqBO reqBO) {
        FscWfEndDealSynchFinanceBusiRspBO rspBO = new FscWfEndDealSynchFinanceBusiRspBO();
        String validateArgStr = this.validateArg(reqBO);
        if (StringUtils.hasText((String)validateArgStr)) {
            rspBO.setRespCode("7777");
            rspBO.setRespDesc(validateArgStr);
            return rspBO;
        }
        WorkFlowDataInfoBO wfDataInfoBO = reqBO.getWorkFlowDataInfo();
        WorkFlowDataInfo wfDataInfo = new WorkFlowDataInfo();
        BeanUtils.copyProperties((Object)wfDataInfoBO, (Object)wfDataInfo);
        String service = wfDataInfo.getFinishEvtService();
        WorkFlowFinishEvent event = (WorkFlowFinishEvent)SpringApplicationContext.getBean(service);
        if (null == event) {
            rspBO.setRespCode("7777");
            rspBO.setRespDesc("\u672a\u83b7\u53d6\u5230\u6d41\u7a0b\u4fe1\u606f\u4e2d\u7684\u5ba1\u6279\u7ed3\u675f\u5904\u7406\u7c7b");
            return rspBO;
        }
        try {
            boolean result;
            WFEventResult eventResult = event.process(wfDataInfo, wfDataInfo.getBillType(), wfDataInfo.getBillNo());
            boolean bl = result = eventResult != null && ("0000".equals(eventResult.getRespCode()) || eventResult.isSuccess());
            if (result) {
                this.updateWorkdataRecord(wfDataInfo, null, true, eventResult);
            } else {
                this.updateWorkdataRecord(wfDataInfo, null, false, eventResult);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5ba1\u6279\u6d41\u7a0b\u7ed3\u675f\u5904\u7406\u670d\u52a1\u5931\u8d25\uff0cprocInstId=[" + wfDataInfo.getProcInstId() + "]", (Throwable)e);
            this.updateWorkdataRecord(wfDataInfo, e, false, null);
            throw new BusinessException("6004", "\u5ba1\u6279\u6d41\u7a0b\u7ed3\u675f\u5904\u7406\u670d\u52a1\u5931\u8d25\uff0cprocInstId=[" + wfDataInfo.getProcInstId() + "]", (Throwable)e);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5ba1\u6279\u6d41\u7a0b\u7ed3\u675f\u5904\u7406\u670d\u52a1\u6210\u529f");
        return rspBO;
    }

    private void updateWorkdataRecord(WorkFlowDataInfo wfDataInfo, Exception exception, boolean result, WFEventResult eventResult) {
        WorkFlowDataInfo workFlowData = new WorkFlowDataInfo();
        workFlowData.setProcInstId(wfDataInfo.getProcInstId());
        if (exception != null) {
            if (wfDataInfo.getBillType().equals(WFBillType.HANDMADE_COLLECTION.getCode())) {
                workFlowData.setFinancialStatus(FinancialStatus.FAIL.getCode());
            } else {
                workFlowData.setFinancialStatus(FinancialStatus.SEND_FAIL.getCode());
                if (WFBillType.OUTBOUND_COLLECTION.getCode().equals(wfDataInfo.getBillType()) && null != eventResult && StringUtils.hasText((String)eventResult.getFinancialStatus())) {
                    workFlowData.setFinancialStatus(eventResult.getFinancialStatus());
                }
            }
            workFlowData.setResultdesc("\u5931\u8d25\uff1a" + exception.getMessage());
            if (StringUtils.hasText((String)workFlowData.getResultdesc()) && workFlowData.getResultdesc().length() > 500) {
                workFlowData.setResultdesc(workFlowData.getResultdesc().substring(0, 500));
            }
        } else if (!result) {
            if (wfDataInfo.getBillType().equals(WFBillType.HANDMADE_COLLECTION.getCode())) {
                workFlowData.setFinancialStatus(FinancialStatus.FAIL.getCode());
            } else {
                workFlowData.setFinancialStatus(FinancialStatus.SEND_FAIL.getCode());
                if (WFBillType.OUTBOUND_COLLECTION.getCode().equals(wfDataInfo.getBillType()) && null != eventResult && StringUtils.hasText((String)eventResult.getFinancialStatus())) {
                    workFlowData.setFinancialStatus(eventResult.getFinancialStatus());
                }
            }
            if (null == eventResult) {
                workFlowData.setResultdesc("\u5931\u8d25");
            } else {
                workFlowData.setRefNo(eventResult.getSsn());
                workFlowData.setResultdesc("\u5931\u8d25\uff1a" + eventResult.getRespDesc());
                if (StringUtils.hasText((String)workFlowData.getResultdesc()) && workFlowData.getResultdesc().length() > 500) {
                    workFlowData.setResultdesc(workFlowData.getResultdesc().substring(0, 500));
                }
            }
        } else {
            workFlowData.setFinancialStatus(FinancialStatus.SUCCESS.getCode());
            workFlowData.setResultdesc("\u6210\u529f");
        }
        DataSourceTransactionManager transactionManager = SpringApplicationContext.getTransactionManager();
        DefaultTransactionDefinition transDefinition = new DefaultTransactionDefinition();
        transDefinition.setPropagationBehavior(3);
        TransactionStatus transactionStatus = transactionManager.getTransaction((TransactionDefinition)transDefinition);
        try {
            this.workFlowDataMapper.updateByPrimaryKeySelective(workFlowData);
            transactionManager.commit(transactionStatus);
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0workdata\u8868\u4e1a\u52a1\u72b6\u6001\u5931\u8d25\uff0c\u6d41\u7a0b\u5b9e\u4f8bID:" + wfDataInfo.getProcInstId(), (Throwable)e);
            transactionManager.rollback(transactionStatus);
        }
    }

    private String validateArg(FscWfEndDealSynchFinanceBusiReqBO reqBO) {
        if (null == reqBO) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBO.getWorkFlowDataInfo()) {
            return "\u6d41\u7a0b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

