/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.PayUpdatePaymentStatusService;
import com.tydic.fsc.settle.busi.api.bo.PayQryPaymentStatusReqBO;
import com.tydic.fsc.settle.dao.InquiryPayOrderMapper;
import com.tydic.fsc.settle.dao.po.InquiryPayOrder;
import com.tydic.fsc.settle.dao.po.InquiryPayOrderExt;
import com.tydic.fsc.settle.enums.InquiryPaymentStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PayUpdatePaymentStatusServiceImpl
implements PayUpdatePaymentStatusService {
    private static final Logger logger = LoggerFactory.getLogger(PayUpdatePaymentStatusServiceImpl.class);
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;

    public FscBaseRspBo updatePaymentStatus(PayQryPaymentStatusReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u4f5c\u5e9f\u7533\u8bf7\u64cd\u4f5c\u66f4\u65b0\u6210\u4ea4\u670d\u52a1\u8d39\u4ed8\u6b3e\u72b6\u6001\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        String respCode = null;
        String respDesc = null;
        if (null == reqBO.getPayOrderNo()) {
            logger.error("\u7f34\u8d39\u5355\u53f7[payOrderNo]\u4e3a\u7a7a");
            throw new BusinessException("1001", "\u7f34\u8d39\u5355\u53f7[payOrderNo]\u4e3a\u7a7a");
        }
        if (null == reqBO.getIdentifyNum()) {
            logger.error("\u5165\u53c2[identifyNum]\u4e3a\u7a7a");
            throw new BusinessException("1001", "\u5165\u53c2[identifyNum]\u4e3a\u7a7a");
        }
        InquiryPayOrderExt payOrderInfoExt = new InquiryPayOrderExt();
        payOrderInfoExt.setPayOrderNo(reqBO.getPayOrderNo());
        InquiryPayOrder inquiryPayOrder = this.inquiryPayOrderMapper.selectByPrimaryKey(payOrderInfoExt);
        if (null == inquiryPayOrder) {
            logger.error("\u672a\u627e\u5230\u7f34\u8d39\u5355\u53f7\u4e3a" + reqBO.getPayOrderNo() + "\u7684\u6570\u636e");
            throw new BusinessException("1001", "\u672a\u627e\u5230\u7f34\u8d39\u5355\u53f7\u4e3a" + reqBO.getPayOrderNo() + "\u7684\u6570\u636e");
        }
        if ("00".equals(reqBO.getIdentifyNum()) && !InquiryPaymentStatus.NO_PAYMENT.getCode().equals(inquiryPayOrder.getPaymentStatus())) {
            respCode = "6006";
            respDesc = "\u7f34\u8d39\u5355:" + reqBO.getPayOrderNo() + "\u975e\u672a\u7f34\u8d39\u72b6\u6001\uff0c\u4e0d\u80fd\u53d1\u8d77\u4f5c\u5e9f\u7533\u8bf7\uff01";
            logger.error("\u7f34\u8d39\u5355:" + reqBO.getPayOrderNo() + "\u975e\u672a\u7f34\u8d39\u72b6\u6001\uff0c\u4e0d\u80fd\u53d1\u8d77\u4f5c\u5e9f\u7533\u8bf7\uff01");
        }
        if ("01".equals(reqBO.getIdentifyNum())) {
            if (!InquiryPaymentStatus.NO_PAYMENT.getCode().equals(inquiryPayOrder.getPaymentStatus())) {
                respCode = "6006";
                respDesc = "\u7f34\u8d39\u5355:" + reqBO.getPayOrderNo() + "\u975e\u672a\u7f34\u8d39\u72b6\u6001\uff0c\u4e0d\u80fd\u53d1\u8d77\u4f5c\u5e9f\u7533\u8bf7\uff01";
                logger.error("\u7f34\u8d39\u5355:" + reqBO.getPayOrderNo() + "\u975e\u672a\u7f34\u8d39\u72b6\u6001\uff0c\u4e0d\u80fd\u53d1\u8d77\u4f5c\u5e9f\u7533\u8bf7\uff01");
            } else {
                payOrderInfoExt.setPaymentStatus(InquiryPaymentStatus.ALREADY_FREEZE.getCode());
                try {
                    this.inquiryPayOrderMapper.updateState(payOrderInfoExt);
                }
                catch (Exception e) {
                    respCode = "6003";
                    respDesc = "\u66f4\u65b0\u7f34\u8d39\u5355" + reqBO.getPayOrderNo() + "\u6570\u636e\u5931\u8d25!";
                    logger.error("\u66f4\u65b0\u7f34\u8d39\u5355" + reqBO.getPayOrderNo() + "\u6570\u636e\u5931\u8d25!");
                }
            }
        }
        if ("02".equals(reqBO.getIdentifyNum())) {
            if (!InquiryPaymentStatus.ALREADY_FREEZE.getCode().equals(inquiryPayOrder.getPaymentStatus())) {
                respCode = "6007";
                respDesc = "\u7f34\u8d39\u5355:" + reqBO.getPayOrderNo() + "\u975e\u5df2\u51bb\u7ed3\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u9a73\u56de\u64cd\u4f5c\uff01";
                logger.error("\u7f34\u8d39\u5355:" + reqBO.getPayOrderNo() + "\u975e\u5df2\u51bb\u7ed3\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u9a73\u56de\u64cd\u4f5c\uff01");
            } else {
                payOrderInfoExt.setPaymentStatus(InquiryPaymentStatus.NO_PAYMENT.getCode());
                try {
                    this.inquiryPayOrderMapper.updateState(payOrderInfoExt);
                }
                catch (Exception e) {
                    respCode = "6003";
                    respDesc = "\u66f4\u65b0\u7f34\u8d39\u5355" + reqBO.getPayOrderNo() + "\u6570\u636e\u5931\u8d25!";
                    logger.error("\u66f4\u65b0\u7f34\u8d39\u5355" + reqBO.getPayOrderNo() + "\u6570\u636e\u5931\u8d25!");
                }
            }
        }
        if ("03".equals(reqBO.getIdentifyNum())) {
            if (!InquiryPaymentStatus.ALREADY_FREEZE.getCode().equals(inquiryPayOrder.getPaymentStatus())) {
                respCode = "6007";
                respDesc = "\u7f34\u8d39\u5355:" + reqBO.getPayOrderNo() + "\u975e\u5df2\u51bb\u7ed3\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u5ba1\u6279\u901a\u8fc7\u64cd\u4f5c\uff01";
                logger.error("\u7f34\u8d39\u5355:" + reqBO.getPayOrderNo() + "\u975e\u5df2\u51bb\u7ed3\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u5ba1\u6279\u901a\u8fc7\u64cd\u4f5c\uff01");
            } else {
                payOrderInfoExt.setPaymentStatus(InquiryPaymentStatus.TERMINATED.getCode());
                try {
                    this.inquiryPayOrderMapper.updateState(payOrderInfoExt);
                }
                catch (Exception e) {
                    respCode = "6003";
                    respDesc = "\u66f4\u65b0\u7f34\u8d39\u5355" + reqBO.getPayOrderNo() + "\u6570\u636e\u5931\u8d25!";
                    logger.error("\u66f4\u65b0\u7f34\u8d39\u5355" + reqBO.getPayOrderNo() + "\u6570\u636e\u5931\u8d25!");
                }
            }
        }
        FscBaseRspBo rspBO = new FscBaseRspBo();
        if (StringUtils.hasText((String)respCode)) {
            rspBO.setRespCode(respCode);
            rspBO.setRespDesc(respDesc);
        }
        return rspBO;
    }
}

