/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.SaleInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.SaleInvoiceMailInfoMapper;
import com.tydic.fsc.settle.dao.po.SaleInvoiceInfo;
import com.tydic.fsc.settle.dao.po.SaleInvoiceMailInfo;
import com.tydic.fsc.settle.enums.InvoiceMailSentStatus;
import com.tydic.fsc.settle.utils.BeanFactory;
import com.tydic.fsc.supplier.BusiJdExpressService;
import com.tydic.fsc.supplier.bo.JdexpressTokenVO;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class PlatfUseFeeMailForInvoiceServiceThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(PlatfUseFeeMailForInvoiceServiceThread.class);
    private JdexpressTokenVO jdToken;
    private String senderName;
    private String senderAddr;
    private String senderPhone;
    private Integer mailNum;
    private BigDecimal totalAmt;
    private List<String> invoiceNoList;
    SaleInvoiceMailInfoMapper saleInvoiceMailInfoMapper = (SaleInvoiceMailInfoMapper)BeanFactory.getBean("saleInvoiceMailInfoMapper");
    BillApplyInfoMapper billApplyInfoMapper = (BillApplyInfoMapper)BeanFactory.getBean("billApplyInfoMapper");
    BusiJdExpressService busiJdExpressService = (BusiJdExpressService)BeanFactory.getBean("busiJdExpressService");
    SaleInvoiceInfoMapper saleInvoiceInfoMapper = (SaleInvoiceInfoMapper)BeanFactory.getBean("saleInvoiceInfoMapper");

    @Override
    public void run() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage());
        }
        for (String invoiceNo : this.invoiceNoList) {
            String mailTicketNo = this.saleInvoiceInfoMapper.selectMailTicketNoByPrimaryKey(invoiceNo);
            SaleInvoiceMailInfo saleInvoiceMailInfo = this.saleInvoiceMailInfoMapper.selectByPrimaryKey(mailTicketNo);
            String jdRangeCheckResult = this.busiJdExpressService.rangeCheck(invoiceNo, saleInvoiceMailInfo.getAddress(), this.jdToken);
            String resultCode = jdRangeCheckResult.split("-")[0];
            String resultMsg = jdRangeCheckResult.split("-")[1];
            logger.debug("\u53d1\u7968\u53f7\u7801" + invoiceNo + "\u5bf9\u5e94\u7684\u5730\u5740:" + saleInvoiceMailInfo.getAddress() + ",\u4eac\u914d\u9a8c\u8bc1\u7ed3\u679c\u4e3a:" + resultCode + ",\u539f\u56e0:" + resultMsg);
            SaleInvoiceMailInfo record = new SaleInvoiceMailInfo();
            record.setMailTicketNo(mailTicketNo);
            record.setJdAssignStatus(resultCode);
            record.setFailReason(resultMsg);
            this.saleInvoiceMailInfoMapper.updateByPrimaryKeySelective(record);
            SaleInvoiceInfo saleInvoiceInfo = this.saleInvoiceInfoMapper.selectByPrimaryKey(invoiceNo);
            this.mailNum = 1;
            this.totalAmt = saleInvoiceInfo.getAmt();
            try {
                this.busiJdExpressService.sendBill(mailTicketNo, mailTicketNo, this.senderName, this.senderAddr, this.senderPhone, saleInvoiceMailInfo.getReceiver(), saleInvoiceMailInfo.getAddress(), saleInvoiceMailInfo.getTel(), "\u53d1\u7968" + this.mailNum + "\u5f20\uff0c\u5408\u8ba1\u91d1\u989d" + this.totalAmt + "\u5143", this.jdToken);
            }
            catch (Exception e) {
                logger.error("\u53d1\u8d77\u90ae\u5bc4\u53d1\u7968\u670d\u52a1-\u8c03\u7528\u4eac\u4e1c\u90ae\u5bc4\u63a5\u53e3\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
                SaleInvoiceMailInfo recordMailInfo = new SaleInvoiceMailInfo();
                recordMailInfo.setMailTicketNo(mailTicketNo);
                recordMailInfo.setMailStatus(InvoiceMailSentStatus.SENT_FAIL.getCode());
                String failReason = e.getMessage();
                if (StringUtils.hasText((String)failReason) && failReason.length() > 300) {
                    failReason = failReason.substring(0, 300);
                }
                recordMailInfo.setFailReason(failReason);
                this.saleInvoiceMailInfoMapper.updateByMailTicketNo(recordMailInfo);
                continue;
            }
            SaleInvoiceMailInfo recordSuccess = new SaleInvoiceMailInfo();
            recordSuccess.setMailTicketNo(mailTicketNo);
            recordSuccess.setMailStatus(InvoiceMailSentStatus.SENT_SUCCESS.getCode());
            recordSuccess.setFailReason("\u6210\u529f");
            this.saleInvoiceMailInfoMapper.updateByMailTicketNo(recordSuccess);
        }
    }

    public JdexpressTokenVO getJdToken() {
        return this.jdToken;
    }

    public void setJdToken(JdexpressTokenVO jdToken) {
        this.jdToken = jdToken;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public void setSenderName(String senderName) {
        this.senderName = senderName;
    }

    public String getSenderAddr() {
        return this.senderAddr;
    }

    public void setSenderAddr(String senderAddr) {
        this.senderAddr = senderAddr;
    }

    public String getSenderPhone() {
        return this.senderPhone;
    }

    public void setSenderPhone(String senderPhone) {
        this.senderPhone = senderPhone;
    }

    public Integer getMailNum() {
        return this.mailNum;
    }

    public void setMailNum(Integer mailNum) {
        this.mailNum = mailNum;
    }

    public BigDecimal getTotalAmt() {
        return this.totalAmt;
    }

    public void setTotalAmt(BigDecimal totalAmt) {
        this.totalAmt = totalAmt;
    }

    public List<String> getInvoiceNoList() {
        return this.invoiceNoList;
    }

    public void setInvoiceNoList(List<String> invoiceNoList) {
        this.invoiceNoList = invoiceNoList;
    }
}

