/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.jd.open.api.sdk.domain.etms.TraceQueryJsf.TraceDTO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.JdExpressTokenService;
import com.tydic.fsc.settle.bo.FscPageReqBo;
import com.tydic.fsc.settle.busi.api.QueryBillApplyForMailService;
import com.tydic.fsc.settle.busi.api.bo.QueryBillApplyForMailReqBO;
import com.tydic.fsc.settle.busi.api.bo.QueryBillApplyForMailRspBO;
import com.tydic.fsc.settle.busi.api.bo.QueryExpressTraceDetailRspBO;
import com.tydic.fsc.settle.busi.api.bo.QueryExpressTraceReqBO;
import com.tydic.fsc.settle.busi.api.bo.QueryExpressTraceRspBO;
import com.tydic.fsc.settle.busi.api.vo.BusiApplyMailVO;
import com.tydic.fsc.settle.busi.api.vo.InvoiceForMailVO;
import com.tydic.fsc.settle.busi.api.vo.PurchaseNoListVO;
import com.tydic.fsc.settle.dao.SaleInvoiceMailInfoMapper;
import com.tydic.fsc.settle.dao.po.JdexpressToken;
import com.tydic.fsc.settle.dao.po.SaleInvoiceMailInfo;
import com.tydic.fsc.settle.enums.InvoiceMailSentStatus;
import com.tydic.fsc.settle.enums.InvoiceMailSentStatusCustom;
import com.tydic.fsc.settle.enums.InvoiceType;
import com.tydic.fsc.settle.enums.JDAssignStatus;
import com.tydic.fsc.settle.utils.BeanUtils;
import com.tydic.fsc.settle.utils.FscStringUtils;
import com.tydic.fsc.supplier.BusiJdExpressService;
import com.tydic.fsc.supplier.bo.JdexpressTokenVO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class QueryBillApplyForMailServiceImpl
implements QueryBillApplyForMailService {
    private static final Logger logger = LoggerFactory.getLogger(QueryBillApplyForMailServiceImpl.class);
    @Autowired
    private SaleInvoiceMailInfoMapper saleInvoiceMailInfoMapper;
    @Autowired
    private BusiJdExpressService busiJdExpressService;
    @Autowired
    private JdExpressTokenService jdExpressTokenService;
    @Autowired
    private EnumsService enumsService;

    public QueryBillApplyForMailRspBO queryInvoiceForMail(QueryBillApplyForMailReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5f85\u90ae\u5bc4\u53d1\u7968\u5217\u8868\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO.getCompanyId() == null) {
            throw new BusinessException("1001", "\u516c\u53f8ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryBillApplyForMailRspBO rspPageBO = new QueryBillApplyForMailRspBO();
        String orderBy = FscStringUtils.obtainOrderBy((FscPageReqBo)reqBO, "d_bill_apply_info c", null);
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        reqBO.setInvoceNameLike(reqBO.getInvoceName());
        reqBO.setInvoceName(null);
        List<PurchaseNoListVO> purchaseNoListVOs = this.saleInvoiceMailInfoMapper.queryToMailListPage(reqBO, (Page<Map<String, Object>>)page, orderBy);
        reqBO.setInvoceNameLike(null);
        reqBO.setInvoceName(null);
        reqBO.setNameLike(null);
        reqBO.setName(null);
        ArrayList<BusiApplyMailVO> keyFields = new ArrayList<BusiApplyMailVO>();
        reqBO.setKeyFields(keyFields);
        for (PurchaseNoListVO purchaseNoListVO : purchaseNoListVOs) {
            BusiApplyMailVO keyField = new BusiApplyMailVO();
            keyFields.add(keyField);
            keyField.setInvoceName(purchaseNoListVO.getInvoceName());
            keyField.setName(purchaseNoListVO.getName());
        }
        orderBy = " a.INVOICE_NO asc";
        List<InvoiceForMailVO> invoiceForMailVOs = this.saleInvoiceMailInfoMapper.queryToMailInvoice(reqBO, orderBy);
        for (PurchaseNoListVO purchaseNoListVO : purchaseNoListVOs) {
            ArrayList<InvoiceForMailVO> invoices = new ArrayList<InvoiceForMailVO>();
            Iterator<InvoiceForMailVO> iterator = invoiceForMailVOs.iterator();
            while (iterator.hasNext()) {
                InvoiceForMailVO invoice = iterator.next();
                if (!purchaseNoListVO.getInvoceName().equals(invoice.getInvoceName()) || !purchaseNoListVO.getName().equals(invoice.getName())) continue;
                invoices.add(invoice);
                iterator.remove();
            }
            if (!invoices.isEmpty()) {
                InvoiceForMailVO firstInvoice = (InvoiceForMailVO)invoices.get(0);
                purchaseNoListVO.setMobile(firstInvoice.getMobile());
                try {
                    purchaseNoListVO.setInvoiceTypeDescr(this.enumsService.getDescr(InvoiceType.getInstance(Integer.valueOf(firstInvoice.getInvoiceType()))));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                purchaseNoListVO.setDetailAddress(QueryBillApplyForMailServiceImpl.getDetailAddress(firstInvoice));
            }
            purchaseNoListVO.setCount(Integer.valueOf(invoices.size()));
            purchaseNoListVO.setInvoiceForMailList(invoices);
        }
        rspPageBO.setRows(purchaseNoListVOs);
        rspPageBO.setRecordsTotal(page.getTotalCount());
        rspPageBO.setTotal(page.getTotalPages());
        rspPageBO.setPageNo(page.getPageNo());
        return rspPageBO;
    }

    public QueryBillApplyForMailRspBO queryInvoiceSent(QueryBillApplyForMailReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5df2\u90ae\u5bc4\u53d1\u7968\u5217\u8868\u670d\u52a1 \u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO.getCompanyId() == null) {
            throw new BusinessException("1001", "\u516c\u53f8ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryBillApplyForMailRspBO rspPageBO = new QueryBillApplyForMailRspBO();
        String orderBy = StringUtils.hasText((String)reqBO.getOrderBy()) ? reqBO.getOrderBy() : " b.MAIL_TICKET_NO asc";
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        reqBO.setInvoceNameLike(reqBO.getInvoceName());
        reqBO.setInvoceName(null);
        List<SaleInvoiceMailInfo> mails = this.saleInvoiceMailInfoMapper.queryMailedListPage(reqBO, InvoiceMailSentStatusCustom.DONE.getCode(), (Page<Map<String, Object>>)page, orderBy);
        QueryBillApplyForMailReqBO reqBO2 = new QueryBillApplyForMailReqBO();
        reqBO2.setOrderBy(" a.MAIL_TICKET_NO asc,a.ORDER_ID asc");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<PurchaseNoListVO> purchaseNoListVOs = new ArrayList<PurchaseNoListVO>();
        for (SaleInvoiceMailInfo mail : mails) {
            PurchaseNoListVO vo = new PurchaseNoListVO();
            org.springframework.beans.BeanUtils.copyProperties((Object)mail, (Object)vo);
            purchaseNoListVOs.add(vo);
            reqBO2.setExpressNo(mail.getMailTicketNo());
            List<InvoiceForMailVO> invoiceForMailVOs = this.saleInvoiceMailInfoMapper.getHasMailInvoiceList(reqBO2);
            for (InvoiceForMailVO invoiceForMailVO : invoiceForMailVOs) {
                try {
                    invoiceForMailVO.setInvoiceDateString(dateFormat.format(invoiceForMailVO.getInvoiceDate()));
                }
                catch (Exception exception) {}
            }
            vo.setName(vo.getReceiver());
            vo.setMobile(vo.getTel());
            vo.setDetailAddress(vo.getAddress());
            vo.setJdAssignStatusDescr(this.enumsService.getDescr(JDAssignStatus.getInstance(vo.getJdAssignStatus())));
            vo.setMailStatusDescr(this.enumsService.getDescr(InvoiceMailSentStatus.getInstance(vo.getMailStatus())));
            try {
                vo.setInvoiceTypeDescr(this.enumsService.getDescr(InvoiceType.getInstance(Integer.valueOf(mail.getInvoiceType()))));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                vo.setCreateDateString(dateFormat.format(vo.getCreateDate()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            vo.setCount(Integer.valueOf(invoiceForMailVOs.size()));
            vo.setInvoiceForMailList(invoiceForMailVOs);
        }
        rspPageBO.setRows(purchaseNoListVOs);
        rspPageBO.setRecordsTotal(page.getTotalCount());
        rspPageBO.setTotal(page.getTotalPages());
        rspPageBO.setPageNo(page.getPageNo());
        return rspPageBO;
    }

    public QueryExpressTraceRspBO queryExpressTrace(QueryExpressTraceReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u7269\u6d41\u4fe1\u606f\u670d\u52a1 \u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO.getCompanyId() == null) {
            throw new BusinessException("1001", "\u67e5\u8be2\u90ae\u5bc4\u8be6\u60c5-\u4e13\u4e1a\u516c\u53f8[companyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getExpressNo() == null) {
            throw new BusinessException("1001", "\u67e5\u8be2\u90ae\u5bc4\u8be6\u60c5-\u5feb\u9012\u5355\u53f7[expressNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JdexpressToken token = this.jdExpressTokenService.getToken(reqBO.getCompanyId());
        JdexpressTokenVO tokenVO = new JdexpressTokenVO();
        org.springframework.beans.BeanUtils.copyProperties((Object)token, (Object)tokenVO);
        List traceDTOList = this.busiJdExpressService.receiveTrace(reqBO.getExpressNo(), tokenVO);
        QueryExpressTraceRspBO rspBO = new QueryExpressTraceRspBO();
        ArrayList<QueryExpressTraceDetailRspBO> rows = new ArrayList<QueryExpressTraceDetailRspBO>();
        if (traceDTOList != null) {
            for (TraceDTO traceDTO : traceDTOList) {
                QueryExpressTraceDetailRspBO row = new QueryExpressTraceDetailRspBO();
                org.springframework.beans.BeanUtils.copyProperties((Object)traceDTO, (Object)row);
                rows.add(row);
            }
        }
        Collections.reverse(rows);
        rspBO.setRows(rows);
        List<SaleInvoiceMailInfo> listForRecieverInfo = this.saleInvoiceMailInfoMapper.selectByExpressNo(reqBO.getExpressNo());
        if (!CollectionUtils.isEmpty(listForRecieverInfo)) {
            SaleInvoiceMailInfo firstRecieverInfo = listForRecieverInfo.get(0);
            BeanUtils.null2DefaultValue(firstRecieverInfo);
            rspBO.setRecieverName(firstRecieverInfo.getReceiver());
            rspBO.setRecieverTel(firstRecieverInfo.getTel());
            rspBO.setRecieverAddr(firstRecieverInfo.getAddress());
        }
        return rspBO;
    }

    public static String getDetailAddress(InvoiceForMailVO invoiceForMailVO) {
        String detailAddress = "";
        if (null != invoiceForMailVO) {
            if (StringUtils.hasText((String)invoiceForMailVO.getAddress())) {
                detailAddress = invoiceForMailVO.getAddress();
            } else {
                String province = FscStringUtils.valueOf(invoiceForMailVO.getProvince());
                String city = FscStringUtils.valueOf(invoiceForMailVO.getCity());
                String county = FscStringUtils.valueOf(invoiceForMailVO.getCounty());
                String town = FscStringUtils.valueOf(invoiceForMailVO.getTown());
                String addrDesc = FscStringUtils.valueOf(invoiceForMailVO.getAddrDesc());
                detailAddress = FscStringUtils.simplifyAddrdesc(province, city, county, town, addrDesc);
            }
        }
        return detailAddress;
    }
}

