/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.busi.api.QueryhandmadeCollectionByIdService;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryDetailListRecAmtConfirmRspBO;
import com.tydic.fsc.settle.busi.api.bo.QueryhandmadeCollectionByIdReqBO;
import com.tydic.fsc.settle.busi.api.bo.QueryhandmadeCollectionByIdRspBO;
import com.tydic.fsc.settle.dao.AdvanceReceiveMapper;
import com.tydic.fsc.settle.dao.po.AdvanceReceive;
import com.tydic.fsc.settle.dao.vo.AdvanceReceiveVO;
import com.tydic.fsc.settle.enums.AdvanceReceiveStatus;
import com.tydic.fsc.settle.enums.BaseEnums;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.ReceiveType;
import com.tydic.fsc.settle.utils.FileUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryhandmadeCollectionByIdServiceImpl
implements QueryhandmadeCollectionByIdService {
    private static final Logger logger = LoggerFactory.getLogger(QueryhandmadeCollectionByIdServiceImpl.class);
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private AdvanceReceiveMapper advanceReceiveMapper;

    public QueryhandmadeCollectionByIdRspBO select(QueryhandmadeCollectionByIdReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u624b\u5de5\u6536\u6b3e\u5355\u8be6\u60c5\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSeq() == null) {
            throw new BusinessException("1001", "\u5355\u636e\u7f16\u53f7[seq]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryhandmadeCollectionByIdRspBO rspBO = new QueryhandmadeCollectionByIdRspBO();
        ArrayList<BusiQueryDetailListRecAmtConfirmRspBO> rspBOList = new ArrayList<BusiQueryDetailListRecAmtConfirmRspBO>();
        AdvanceReceiveVO advanceReceiveVO = new AdvanceReceiveVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)advanceReceiveVO);
        List<AdvanceReceive> selectByCondition = this.advanceReceiveMapper.selectByCondition(advanceReceiveVO);
        if (selectByCondition == null || selectByCondition.size() == 0) {
            rspBO.setRows(rspBOList);
            return rspBO;
        }
        for (AdvanceReceive advanceReceive : selectByCondition) {
            BusiQueryDetailListRecAmtConfirmRspBO detail = new BusiQueryDetailListRecAmtConfirmRspBO();
            BeanUtils.copyProperties((Object)advanceReceive, (Object)detail);
            detail.setPayOrgName(this.organizationInfoService.obtainOrgNameByAdvanceReceive(advanceReceive));
            detail.setRecTypeDescr(this.enumsService.getDescr(ReceiveType.getInstance(advanceReceive.getRecType())));
            detail.setStatusDescr(AdvanceReceiveStatus.getInstance(advanceReceive.getStatus()).getCodeDescr());
            detail.setSourceName(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)advanceReceive.getSource())));
            detail.setReceiptUrl(FileUtils.obtainOSSUrl(detail.getReceipt()));
            rspBOList.add(detail);
        }
        rspBO.setRows(rspBOList);
        return rspBO;
    }
}

