/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.busi.api.ReconcilitionBatchAddService;
import com.tydic.fsc.settle.busi.api.bo.ReconcilitionBatchAddReqBO;
import com.tydic.fsc.settle.busi.api.bo.ReconcilitionBatchAddRspBO;
import com.tydic.fsc.settle.busi.api.bo.ReconcilitionDetailImportRedisAddItemReqBO;
import com.tydic.fsc.settle.dao.ReconcilitionHisTempMapper;
import com.tydic.fsc.settle.dao.po.ReconcilitionListTempPo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReconcilitionBatchAddServiceImpl
implements ReconcilitionBatchAddService {
    private static final Logger logger = LoggerFactory.getLogger(ReconcilitionBatchAddServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private ReconcilitionHisTempMapper reconcilitionHisTempMapper;

    public ReconcilitionBatchAddRspBO addReconcilitionBatch(ReconcilitionBatchAddReqBO reqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5bf9\u8d26-\u6279\u91cf\u65b0\u589e\u670d\u52a1\uff1a" + reqBO);
        }
        if (null == reqBO) {
            throw new BusinessException("1001", " \u5bf9\u8d26-\u6279\u91cf\u65b0\u589e\u670d\u52a1,\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getReconcilitionDetailImportRedisAddItemReqBOs()) {
            throw new BusinessException("1001", "\u65b0\u589e\u5bf9\u8d26\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ReconcilitionBatchAddRspBO rspBO = new ReconcilitionBatchAddRspBO();
        try {
            List reconcilitionDetailImportRedisAddItemReqBOs = reqBO.getReconcilitionDetailImportRedisAddItemReqBOs();
            ArrayList<ReconcilitionListTempPo> list = new ArrayList<ReconcilitionListTempPo>();
            Integer versionNo = this.reconcilitionHisTempMapper.selectVersion();
            if (versionNo == null) {
                versionNo = 0;
            }
            this.assemblePurchaseData(list, reconcilitionDetailImportRedisAddItemReqBOs, versionNo);
            for (ReconcilitionListTempPo ReconcilitionListTempPo2 : list) {
                this.reconcilitionHisTempMapper.insertSelective(ReconcilitionListTempPo2);
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6279\u91cf\u63d2\u5165\u6210\u529f");
            rspBO.setVersionNo(((ReconcilitionListTempPo)list.get(0)).getVersionNo());
        }
        catch (Exception e) {
            logger.error("\u5bf9\u8d26-\u6279\u91cf\u65b0\u589e\u670d\u52a1", (Throwable)e);
            throw new BusinessException("1002", "\u5bf9\u8d26-\u6279\u91cf\u65b0\u589e\u670d\u52a1\u5931\u8d25");
        }
        return rspBO;
    }

    private void assemblePurchaseData(List<ReconcilitionListTempPo> list, List<ReconcilitionDetailImportRedisAddItemReqBO> reconcilitionDetailImportRedisAddItemReqBOs, Integer versionNo) {
        try {
            for (ReconcilitionDetailImportRedisAddItemReqBO ReconcilitionDetailImportRedisAddItemReqBO2 : reconcilitionDetailImportRedisAddItemReqBOs) {
                Integer versionNum = versionNo + 1;
                ReconcilitionListTempPo reconcilitionListTempPo = new ReconcilitionListTempPo();
                BeanUtils.copyProperties((Object)ReconcilitionDetailImportRedisAddItemReqBO2, (Object)reconcilitionListTempPo);
                reconcilitionListTempPo.setVersionNo(versionNum);
                if (null != ReconcilitionDetailImportRedisAddItemReqBO2.getOutAmt()) {
                    reconcilitionListTempPo.setOutAmt(ReconcilitionDetailImportRedisAddItemReqBO2.getOutAmt());
                }
                list.add(reconcilitionListTempPo);
            }
        }
        catch (Exception e) {
            logger.error("\u5bf9\u8d26-\u6279\u91cf\u65b0\u589e\u670d\u52a1\u5c01\u88c5\u53c2\u6570\u9519\u8bef", (Throwable)e);
        }
    }
}

