/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.DictionaryAtomService;
import com.tydic.fsc.settle.atom.bo.DictionaryAtomReqBo;
import com.tydic.fsc.settle.atom.bo.DictionaryAtomRspBo;
import com.tydic.fsc.settle.busi.api.ReconcilitionHisItemService;
import com.tydic.fsc.settle.busi.api.bo.ReconcilitionHisListRepBO;
import com.tydic.fsc.settle.busi.api.bo.ReconcilitionHisListRspBO;
import com.tydic.fsc.settle.busi.api.vo.ReconcilitionHisListVO;
import com.tydic.fsc.settle.dao.ReconcilitionHisMapper;
import com.tydic.fsc.settle.dao.ReconcilitionHisTempMapper;
import com.tydic.fsc.settle.dao.po.ReconcilitionHis;
import com.tydic.fsc.settle.dao.po.ReconcilitionHisTemp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ReconcilitionHisItemServiceImpl
implements ReconcilitionHisItemService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReconcilitionHisItemServiceImpl.class);
    private static final String IS_TEMP_YES = "1";
    private static final String IS_TEMP_NO = "0";
    private DictionaryAtomService dicDictionaryService;
    private ReconcilitionHisTempMapper reconcilitionHisTempMapper;
    private ReconcilitionHisMapper reconcilitionHisMapper;

    @Autowired
    private ReconcilitionHisItemServiceImpl(DictionaryAtomService dicDictionaryService, ReconcilitionHisTempMapper reconcilitionHisTempMapper, ReconcilitionHisMapper reconcilitionHisMapper) {
        this.dicDictionaryService = dicDictionaryService;
        this.reconcilitionHisTempMapper = reconcilitionHisTempMapper;
        this.reconcilitionHisMapper = reconcilitionHisMapper;
    }

    public ReconcilitionHisListRspBO queryReconcilitionHisList(ReconcilitionHisListRepBO reqBO) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u67e5\u8be2\u7ed3\u7b97\u5bf9\u8d26\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a\u7248\u672c\u53f7\uff1a" + reqBO.getVersionNo() + "\u662f\u5426\u4e34\u65f6\u8868\uff1a" + reqBO.getIsTempTable());
        }
        ReconcilitionHisListRspBO rspBO = new ReconcilitionHisListRspBO();
        if (!StringUtils.hasText((String)reqBO.getVersionNo())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        if (!StringUtils.hasText((String)reqBO.getIsTempTable())) {
            throw new BusinessException("1002", "\u662f\u5426\u4e34\u65f6\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (IS_TEMP_YES.equals(reqBO.getIsTempTable())) {
            List<ReconcilitionHisTemp> reconcilitionHisTemp;
            try {
                reconcilitionHisTemp = this.reconcilitionHisTempMapper.selectByVersionNo(Integer.valueOf(reqBO.getVersionNo()));
            }
            catch (Exception e) {
                LOGGER.error("\u67e5\u8be2\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
                throw new BusinessException("1002", "\u67e5\u8be2\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25");
            }
            if (CollectionUtils.isEmpty(reconcilitionHisTemp)) {
                LOGGER.error("\u627e\u4e0d\u5230\u7248\u672c\u53f7\u5bf9\u5e94\u7684\u7ed3\u7b97\u5bf9\u8d26\u8bb0\u5f55\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo());
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5931\u8d25");
                return rspBO;
            }
            ArrayList<ReconcilitionHisListVO> reconcilitionHisListVOList = new ArrayList<ReconcilitionHisListVO>();
            for (ReconcilitionHisTemp reconcilitionHisTemps : reconcilitionHisTemp) {
                ReconcilitionHisListVO reconcilitionHisListVO = new ReconcilitionHisListVO();
                BeanUtils.copyProperties((Object)reconcilitionHisTemps, (Object)reconcilitionHisListVO);
                reconcilitionHisListVOList.add(reconcilitionHisListVO);
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRows(reconcilitionHisListVOList);
            return rspBO;
        }
        if (IS_TEMP_NO.equals(reqBO.getIsTempTable())) {
            List<ReconcilitionHis> reconcilitionHis;
            try {
                reconcilitionHis = this.reconcilitionHisMapper.selectByVersionNo(Integer.valueOf(reqBO.getVersionNo()));
            }
            catch (Exception e) {
                LOGGER.error("\u67e5\u8be2\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
                throw new BusinessException("1002", "\u67e5\u8be2\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25");
            }
            if (CollectionUtils.isEmpty(reconcilitionHis)) {
                LOGGER.error("\u627e\u4e0d\u5230\u7248\u672c\u53f7\u5bf9\u5e94\u7684\u7ed3\u7b97\u5bf9\u8d26\u8bb0\u5f55\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo());
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5931\u8d25");
                return rspBO;
            }
            ArrayList<ReconcilitionHisListVO> reconcilitionHisListVOList = new ArrayList<ReconcilitionHisListVO>();
            for (ReconcilitionHis reconcilitionHiss : reconcilitionHis) {
                ReconcilitionHisListVO reconcilitionHisListVO = new ReconcilitionHisListVO();
                BeanUtils.copyProperties((Object)reconcilitionHiss, (Object)reconcilitionHisListVO);
                reconcilitionHisListVO.setReconciliationStatusName(this.getReconcilStatusMap().get(reconcilitionHiss.getReconciliationStatus() + ""));
                if (null != reconcilitionHiss.getOrderId()) {
                    reconcilitionHisListVO.setOrderId(reconcilitionHiss.getOrderId().toString());
                } else {
                    reconcilitionHisListVO.setOrderId("");
                }
                reconcilitionHisListVOList.add(reconcilitionHisListVO);
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRows(reconcilitionHisListVOList);
            return rspBO;
        }
        LOGGER.error("\u662f\u5426\u4e34\u65f6\u8868\u4e3a\u7a7a\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo());
        rspBO.setRespCode("8888");
        rspBO.setRespDesc("\u5931\u8d25");
        rspBO.setRows(new ArrayList());
        return rspBO;
    }

    private Map<String, String> getReconcilStatusMap() {
        Map<String, String> map = new HashMap<String, String>(2);
        DictionaryAtomReqBo dictionaryAtomReqBo = new DictionaryAtomReqBo();
        dictionaryAtomReqBo.setpCode("RECONCIL_STATUS");
        DictionaryAtomRspBo dictionaryAtomRspBo = this.dicDictionaryService.qryDic(dictionaryAtomReqBo);
        if (null != dictionaryAtomRspBo) {
            map = dictionaryAtomRspBo.getData();
        }
        return map;
    }
}

