/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.comb.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.busi.api.FscWfFinishTaskBusiService;
import com.tydic.fsc.settle.busi.api.bo.FscWfFinishTaskBusiReqBO;
import com.tydic.fsc.settle.busi.api.bo.FscWfFinishTaskBusiRspBO;
import com.tydic.fsc.settle.comb.api.FscWfEndWithoutSynchFinanceCombService;
import com.tydic.fsc.settle.comb.api.FscWfFinishTaskBatchCombService;
import com.tydic.fsc.settle.comb.api.bo.FscWfEndWithoutSynchFinanceCombReqBO;
import com.tydic.fsc.settle.comb.api.bo.FscWfFinishTaskBatchCombReqBO;
import com.tydic.fsc.settle.comb.api.bo.FscWfFinishTaskBatchCombRspBO;
import com.tydic.fsc.settle.dao.WorkFlowDataMapper;
import com.tydic.fsc.settle.dao.po.WorkFlowDataInfo;
import com.tydic.fsc.settle.enums.WFStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="fscWfFinishTaskBatchCombService")
public class FscWfFinishTaskBatchCombServiceImpl
implements FscWfFinishTaskBatchCombService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscWfFinishTaskBatchCombServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private WorkFlowDataMapper workFlowDataMapper;
    private FscWfFinishTaskBusiService fscWfFinishTaskBusiService;
    private FscWfEndWithoutSynchFinanceCombService fscWfEndWithoutSynchFinanceCombService;

    @Autowired
    private FscWfFinishTaskBatchCombServiceImpl(WorkFlowDataMapper workFlowDataMapper, FscWfFinishTaskBusiService fscWfFinishTaskBusiService, FscWfEndWithoutSynchFinanceCombService fscWfEndWithoutSynchFinanceCombService) {
        this.workFlowDataMapper = workFlowDataMapper;
        this.fscWfFinishTaskBusiService = fscWfFinishTaskBusiService;
        this.fscWfEndWithoutSynchFinanceCombService = fscWfEndWithoutSynchFinanceCombService;
    }

    public FscWfFinishTaskBatchCombRspBO dealFinishTaskBatch(FscWfFinishTaskBatchCombReqBO reqBO) {
        FscWfFinishTaskBatchCombRspBO rspBO = new FscWfFinishTaskBatchCombRspBO();
        String validateArgStr = this.validateArg(reqBO);
        if (StringUtils.hasText((String)validateArgStr)) {
            rspBO.setRespCode("7777");
            rspBO.setRespDesc(validateArgStr);
            return rspBO;
        }
        this.checkTypeAndStatus(reqBO.getProcInstIdList());
        int faultCount = 0;
        for (String procInstId : reqBO.getProcInstIdList()) {
            boolean apprResult = this.dealObjectAudit(procInstId, reqBO);
            if (!apprResult) continue;
            ++faultCount;
        }
        int total = reqBO.getProcInstIdList().size();
        int successCount = total - faultCount;
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5ba1\u6279\u5904\u7406\u5b8c\u6210\uff0c\u603b\u8ba1\u63d0\u4ea4" + total + "\u6761\uff0c\u5176\u4e2d\u5904\u7406\u6210\u529f" + successCount + "\u6761\uff0c\u5931\u8d25" + faultCount + "\u6761\uff0c\u5931\u8d25\u7684\u5ba1\u6279\u5355\u636e\u8bf7\u5c1d\u8bd5\u91cd\u65b0\u63d0\u4ea4");
        return rspBO;
    }

    private boolean dealObjectAudit(String procInstId, FscWfFinishTaskBatchCombReqBO reqBO) {
        FscWfFinishTaskBusiReqBO wfFinishTaskBusiReqBO = new FscWfFinishTaskBusiReqBO();
        wfFinishTaskBusiReqBO.setProcInstId(procInstId);
        wfFinishTaskBusiReqBO.setComment(reqBO.getComment());
        wfFinishTaskBusiReqBO.setSeqFlowId(reqBO.getSeqFlowId());
        wfFinishTaskBusiReqBO.setUserId(reqBO.getUserId());
        FscWfFinishTaskBusiRspBO wfFinishTaskBusiRspBO = this.fscWfFinishTaskBusiService.dealFinishTask(wfFinishTaskBusiReqBO);
        if (!"0000".equals(wfFinishTaskBusiRspBO.getRespCode()) || null == wfFinishTaskBusiRspBO.getWfFinish()) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u5ba1\u6279\u63d0\u4ea4\u5904\u7406\u670d\u52a1\u5931\u8d25\uff0cprocInstId=[" + procInstId + "]" + wfFinishTaskBusiRspBO.getRespDesc());
            }
            return true;
        }
        if (null != wfFinishTaskBusiRspBO.getWfFinish() && wfFinishTaskBusiRspBO.getWfFinish().booleanValue()) {
            FscWfEndWithoutSynchFinanceCombReqBO wfEndWithoutSynchFinanceCombReqBO = new FscWfEndWithoutSynchFinanceCombReqBO();
            wfEndWithoutSynchFinanceCombReqBO.setProcInstId(procInstId);
            this.fscWfEndWithoutSynchFinanceCombService.dealWfEndWithoutSynchFinance(wfEndWithoutSynchFinanceCombReqBO);
        }
        return false;
    }

    private void checkTypeAndStatus(List<String> procInstIdList) {
        ArrayList<String> statusList = new ArrayList<String>();
        ArrayList<String> billTypeList = new ArrayList<String>();
        List<WorkFlowDataInfo> workFlowDataList = this.workFlowDataMapper.selectByProcInstId(procInstIdList);
        if (!CollectionUtils.isEmpty(workFlowDataList)) {
            for (WorkFlowDataInfo workFlowDataInfo : workFlowDataList) {
                statusList.add(workFlowDataInfo.getStatus());
                billTypeList.add(workFlowDataInfo.getBillType());
            }
        }
        if (CollectionUtils.isEmpty(billTypeList)) {
            throw new BusinessException("6003", "\u672a\u67e5\u8be2\u5230\u5355\u636e\u7c7b\u578b");
        }
        String billTypeOne = (String)billTypeList.get(0);
        for (String billType : billTypeList) {
            if (billTypeOne.equals(billType)) continue;
            throw new BusinessException("6003", "\u5fc5\u987b\u4e3a\u540c\u4e00\u7c7b\u578b\u7684\u5355\u636e\u624d\u53ef\u8fdb\u884c\u6279\u91cf\u5ba1\u6279\u5904\u7406");
        }
        if (CollectionUtils.isEmpty(statusList)) {
            throw new BusinessException("6003", "\u672a\u67e5\u8be2\u5230\u5ba1\u6279\u72b6\u6001");
        }
        for (String string : statusList) {
            if (WFStatus.IN_THE_AUDIT.getCode().equals(string)) continue;
            throw new BusinessException("6003", "\u5ba1\u6279\u72b6\u6001\u5fc5\u987b\u90fd\u4e3a\u5ba1\u6279\u4e2d");
        }
    }

    private String validateArg(FscWfFinishTaskBatchCombReqBO reqBO) {
        if (null == reqBO) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBO.getSeqFlowId())) {
            return "\u5ba1\u6279\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getProcInstIdList())) {
            return "\u6d41\u7a0b\u5b9e\u4f8bID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

