/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.comb.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.comb.api.FscWfEndWithSynchFinanceCombService;
import com.tydic.fsc.settle.comb.api.FscWfReissueFinanceCombService;
import com.tydic.fsc.settle.comb.api.bo.FscWfEndWithSynchFinanceCombReqBO;
import com.tydic.fsc.settle.comb.api.bo.FscWfEndWithSynchFinanceCombRspBO;
import com.tydic.fsc.settle.comb.api.bo.FscWfReissueFinanceCombReqBO;
import com.tydic.fsc.settle.comb.api.bo.FscWfReissueFinanceCombRspBO;
import com.tydic.fsc.settle.dao.WorkFlowDataMapper;
import com.tydic.fsc.settle.dao.po.WorkFlowDataInfo;
import com.tydic.fsc.settle.enums.FinancialStatus;
import com.tydic.fsc.settle.enums.WFStatus;
import com.tydic.fsc.settle.utils.SpringApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.StringUtils;

@Service(value="fscWfReissueFinanceCombService")
public class FscWfReissueFinanceCombServiceImpl
implements FscWfReissueFinanceCombService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscWfReissueFinanceCombServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private WorkFlowDataMapper workFlowDataMapper;
    private FscWfEndWithSynchFinanceCombService fscWfEndWithSynchFinanceCombService;

    @Autowired
    private FscWfReissueFinanceCombServiceImpl(WorkFlowDataMapper workFlowDataMapper, FscWfEndWithSynchFinanceCombService fscWfEndWithSynchFinanceCombService) {
        this.workFlowDataMapper = workFlowDataMapper;
        this.fscWfEndWithSynchFinanceCombService = fscWfEndWithSynchFinanceCombService;
    }

    public FscWfReissueFinanceCombRspBO dealReissueFinance(FscWfReissueFinanceCombReqBO reqBO) {
        FscWfReissueFinanceCombRspBO rspBO = new FscWfReissueFinanceCombRspBO();
        String validateArgStr = this.validateArg(reqBO);
        if (StringUtils.hasText((String)validateArgStr)) {
            rspBO.setRespCode("7777");
            rspBO.setRespDesc(validateArgStr);
            return rspBO;
        }
        WorkFlowDataInfo workFlowDataInfo = new WorkFlowDataInfo();
        workFlowDataInfo.setProcInstId(reqBO.getProcInstId());
        WorkFlowDataInfo wf = this.workFlowDataMapper.getModelBy(workFlowDataInfo);
        if (wf == null) {
            LOGGER.error("\u672a\u627e\u5230procInstId=[" + reqBO.getProcInstId() + "]\u7684\u6d41\u7a0b\u4fe1\u606f");
            throw new BusinessException("7001", "\u672a\u627e\u5230procInstId=[" + reqBO.getProcInstId() + "]\u7684\u6d41\u7a0b\u4fe1\u606f");
        }
        if (FinancialStatus.SEND_SUCCESS.getCode().equals(wf.getFinancialStatus())) {
            throw new BusinessException("7001", "\u5df2\u53d1\u9001\u8d22\u52a1\u7684\u5355\u636e\u4e0d\u80fd\u91cd\u590d\u53d1\u9001");
        }
        if (!WFStatus.APPROVAL_COMPLETE.getCode().equals(wf.getStatus())) {
            throw new BusinessException("7001", "\u5ba1\u6279\u72b6\u6001\u6709\u8bef,\u4e0d\u4e3a\u5ba1\u6279\u5b8c\u6210\u72b6\u6001");
        }
        this.updateWorkdataRecord(reqBO.getProcInstId());
        FscWfEndWithSynchFinanceCombReqBO wfEndWithSynchFinanceCombReqBO = new FscWfEndWithSynchFinanceCombReqBO();
        wfEndWithSynchFinanceCombReqBO.setProcInstId(reqBO.getProcInstId());
        FscWfEndWithSynchFinanceCombRspBO wfEndWithSynchFinanceCombRspBO = this.fscWfEndWithSynchFinanceCombService.dealWfEndWithSynchFinance(wfEndWithSynchFinanceCombReqBO);
        if (!"0000".equals(wfEndWithSynchFinanceCombRspBO.getRespCode()) && IS_DEBUG_ENABLED) {
            LOGGER.debug("\u53d1\u9001\u8d22\u52a1\u5931\u8d25" + wfEndWithSynchFinanceCombRspBO.getRespDesc());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc(wfEndWithSynchFinanceCombRspBO.getRespDesc());
        return rspBO;
    }

    private void updateWorkdataRecord(String procInstId) {
        WorkFlowDataInfo workFlowDataInfo = new WorkFlowDataInfo();
        workFlowDataInfo.setProcInstId(procInstId);
        workFlowDataInfo.setTryCount(3);
        DataSourceTransactionManager transactionManager = SpringApplicationContext.getTransactionManager();
        DefaultTransactionDefinition transDefinition = new DefaultTransactionDefinition();
        transDefinition.setPropagationBehavior(3);
        TransactionStatus transactionStatus = transactionManager.getTransaction((TransactionDefinition)transDefinition);
        try {
            this.workFlowDataMapper.updateByPrimaryKeySelective(workFlowDataInfo);
            transactionManager.commit(transactionStatus);
        }
        catch (Exception e) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u66f4\u65b0workdata\u8868\u5c1d\u8bd5\u6b21\u6570\u5931\u8d25\uff0c\u6d41\u7a0b\u5b9e\u4f8bID:" + procInstId, (Throwable)e);
            }
            transactionManager.rollback(transactionStatus);
        }
    }

    private String validateArg(FscWfReissueFinanceCombReqBO reqBO) {
        if (null == reqBO) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBO.getProcInstId()) {
            return "\u6d41\u7a0b\u5b9e\u4f8bID\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

