/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.ohaotian.plugin.db.OrderSequence;
import com.ohaotian.plugin.db.impl.OrderSequenceImpl;
import com.ohaotian.plugin.loader.PropertiesFileLoader;
import com.tydic.fsc.settle.config.FscProperties;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FscSequenceConfig {
    @Autowired
    private FscProperties fscProperties;
    @Autowired
    @Qualifier(value="orderDataSource")
    private DruidDataSource dataSource;
    @Autowired
    @Qualifier(value="propertiesFileLoader")
    private PropertiesFileLoader propertiesFileLoader;

    @Bean(value={"propertyConfigurer"})
    public Properties propertyConfigurer() {
        return this.propertiesFileLoader.getProperties();
    }

    @Bean
    public OrderSequence generalSequence() {
        return new OrderSequenceImpl(this.fscProperties.getGeneralSequenceName(), this.dataSource);
    }

    @Bean
    public OrderSequence biTxnSeq() {
        return new OrderSequenceImpl("BI_TXN", this.dataSource);
    }

    @Bean
    public OrderSequence acctTransInfoSeq() {
        return new OrderSequenceImpl("ACCT", this.dataSource);
    }

    @Bean
    public OrderSequence pinganReq() {
        return new OrderSequenceImpl("PINGAN_REQ", this.dataSource);
    }

    @Bean
    public OrderSequence recAmtConfirmReq() {
        return new OrderSequenceImpl("D_REC_AMT_CONFIRM_DOCNUM", this.dataSource);
    }

    @Bean
    public OrderSequence advanceReveiveReq() {
        return new OrderSequenceImpl("D_ADVANCE_RECEIVE_SEQ", this.dataSource);
    }

    @Bean(value={"invoiceApplication"})
    public OrderSequence invoiceApplicationReq() {
        return new OrderSequenceImpl("INVOICE_APPLICATION", this.dataSource);
    }

    @Bean(value={"payApplicationSeq"})
    public OrderSequence payApplicationSeq() {
        return new OrderSequenceImpl("FKSQ", this.dataSource);
    }
}

