/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.AccountantEngineService;
import com.tydic.fsc.settle.atom.SubAccountService;
import com.tydic.fsc.settle.atom.TransactionService;
import com.tydic.fsc.settle.atom.bo.AccountantEngineReqBO;
import com.tydic.fsc.settle.busi.api.bo.SubAcctInfoExt;
import com.tydic.fsc.settle.dao.BookEventMapper;
import com.tydic.fsc.settle.dao.po.BookEvent;
import com.tydic.fsc.settle.dao.po.TranDetail;
import com.tydic.fsc.settle.enums.BusinessType;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AccountantEngineServiceImpl
implements AccountantEngineService {
    private static final Log logger = LogFactory.getLog(AccountantEngineServiceImpl.class);
    @Autowired
    private BookEventMapper bookEventMapper;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private SubAccountService subAccountService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<Long> executeAccountantEngine(AccountantEngineReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u4f1a\u8ba1\u5f15\u64ce\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString()));
        }
        if (null == reqBO.getBusinessType()) {
            throw new BusinessException("1001", "\u4f1a\u8ba1\u5f15\u64ce\u670d\u52a1-\u4e1a\u52a1\u7c7b\u578b[businessType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSource()) {
            throw new BusinessException("1001", "\u4f1a\u8ba1\u5f15\u64ce\u670d\u52a1-\u6765\u6e90[source]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperUnit()) {
            throw new BusinessException("1001", "\u4f1a\u8ba1\u5f15\u64ce\u670d\u52a1-\u8fd0\u8425\u5546\u673a\u6784[operUnit]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<BigDecimal> amounts = reqBO.getAmounts();
        if (null == amounts || amounts.isEmpty()) {
            throw new BusinessException("1001", "\u4f1a\u8ba1\u5f15\u64ce\u670d\u52a1-\u4ea4\u6613\u91d1\u989d[amounts]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (BigDecimal bigDecimal : amounts) {
            if (bigDecimal != null) continue;
            logger.error((Object)("\u4f1a\u8ba1\u5f15\u64ce\u670d\u52a1-\u4ea4\u6613\u91d1\u989d[" + bigDecimal + "]\u4e0d\u80fd\u4e3a\u7a7a"));
            throw new BusinessException("1001", "\u4f1a\u8ba1\u5f15\u64ce\u670d\u52a1-\u4ea4\u6613\u91d1\u989d[" + bigDecimal + "]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<BookEvent> bookEvents = this.bookEventMapper.selectByBusinessType(reqBO.getBusinessType());
        if (bookEvents.isEmpty()) {
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u4f1a\u8ba1\u5f15\u64ce\u670d\u52a1-\u4f1a\u8ba1\u914d\u7f6e\u8868\u67e5\u8be2\u51fa\u9519\uff0c\u8bb0\u5f55\u4e3a\u7a7a");
        }
        if (bookEvents.size() % 2 != 0) {
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u4f1a\u8ba1\u5f15\u64ce\u670d\u52a1-\u4f1a\u8ba1\u914d\u7f6e\u8868\u51fa\u9519\uff0c\u8bb0\u5f55\u5e94\u4e3a\u5076\u6570");
        }
        if (!BusinessType.STOCK_IN.getCode().endsWith(reqBO.getBusinessType())) {
            if (BusinessType.STOCK_OUT.getCode().endsWith(reqBO.getBusinessType())) {
                this.adjustBookEvent(bookEvents, amounts);
            } else {
                for (BigDecimal amount : amounts) {
                    if (amount.compareTo(BigDecimal.ZERO) > 0) continue;
                    logger.error((Object)("\u4f1a\u8ba1\u5f15\u64ce\u670d\u52a1-\u4ea4\u6613\u91d1\u989d[" + amount + "]\u5fc5\u987b\u5927\u4e8e0"));
                    throw new BusinessException("1001", "\u4f1a\u8ba1\u5f15\u64ce\u670d\u52a1-\u4ea4\u6613\u91d1\u989d[" + amount + "]\u5fc5\u987b\u5927\u4e8e0");
                }
            }
        }
        LinkedList<Long> linkedList = new LinkedList<Long>();
        for (int i = 0; i < bookEvents.size() / 2; ++i) {
            SubAcctInfoExt subAcctInfo;
            if (amounts.get(i).compareTo(BigDecimal.ZERO) == 0) {
                logger.error((Object)("\u4f1a\u8ba1\u5f15\u64ce\u670d\u52a1-\u7b2c" + (i + 1) + "\u4e2a\u91d1\u989d\u4e3a0\uff0c\u8df3\u8fc7\u8bb0\u8d26"));
                continue;
            }
            Integer indexA = i * 2;
            Integer indexB = i * 2 + 1;
            BookEvent eventA = bookEvents.get(indexA);
            BookEvent eventB = bookEvents.get(indexB);
            if (eventA.getServiceType() == null || eventB.getServiceType() == null) {
                throw new BusinessException("RSP_CODE_DAO_ERROR", "\u4f1a\u8ba1\u5f15\u64ce\u670d\u52a1-serviceType\u4e3a\u7a7a");
            }
            if (eventA.getDrCrFlag() != null && eventA.getDrCrFlag().equals(eventB.getDrCrFlag())) {
                throw new BusinessException("RSP_CODE_DAO_ERROR", "\u4f1a\u8ba1\u5f15\u64ce\u670d\u52a1-\u4f1a\u8ba1\u914d\u7f6e\u8868\u51fa\u9519\uff1a\u540c\u4e00\u4e2aID\u7684\u4e24\u6761\u8bb0\u5f55\u501f\u8d37\u65b9\u5411\u76f8\u540c");
            }
            if (!eventA.getSyncFlag().equals(eventB.getSyncFlag())) {
                throw new BusinessException("RSP_CODE_DAO_ERROR", "\u4f1a\u8ba1\u5f15\u64ce\u670d\u52a1-\u4f1a\u8ba1\u914d\u7f6e\u8868\u51fa\u9519\uff1a\u540c\u4e00\u4e2aID\u7684\u4e24\u6761\u8bb0\u5f55\u662f\u5426\u540c\u6b65\u94f6\u884c\u6807\u5fd7\u987b\u76f8\u540c");
            }
            TranDetail tranDetail = new TranDetail();
            tranDetail.setSsn(reqBO.getSsn());
            tranDetail.setBusiSsn(reqBO.getBusiSsn());
            if ("1".equals(eventA.getServiceType().toString().substring(0, 1))) {
                if ("D".equals(eventA.getDrCrFlag())) {
                    tranDetail.setOrgId(reqBO.getOrgId());
                    tranDetail.setPayAcctNo(reqBO.getClientAcctNo());
                } else {
                    if (!"C".equals(eventA.getDrCrFlag())) throw new BusinessException("RSP_CODE_DAO_ERROR", "\u4f1a\u8ba1\u5f15\u64ce\u670d\u52a1-\u4f1a\u8ba1\u914d\u7f6e\u8868\u51fa\u9519\uff1a\u501f\u8d37\u65b9\u5411\u7b26\u53f7\u65e0\u6cd5\u8bc6\u522b");
                    tranDetail.setRecvAcctNo(reqBO.getClientAcctNo());
                }
            } else {
                subAcctInfo = this.subAccountService.getWithMainAccount(reqBO.getOperUnit(), reqBO.getSource(), reqBO.getOperUnit(), reqBO.getProjectId(), eventA.getServiceType());
                if (subAcctInfo == null) {
                    logger.debug((Object)("\u67e5\u8be2\u865a\u62df\u5b50\u8d26\u6237\u5165\u53c2\u4e3a\uff1a operUnitNo=" + reqBO.getOperUnit() + ", souce=" + reqBO.getSource() + ", operUnit=" + reqBO.getOperUnit() + ", projectId=" + reqBO.getProjectId() + ", serviceType= " + eventB.getServiceType()));
                    throw new BusinessException("1000", "\u4f1a\u8ba1\u5f15\u64ce\u670d\u52a1-\u539f\u5b50\u670d\u52a1\u5f02\u5e38\uff1a\u865a\u62df\u5b50\u8d26\u6237\u4e0d\u5b58\u5728");
                }
                if ("D".equals(eventA.getDrCrFlag())) {
                    tranDetail.setOrgId(reqBO.getOperUnit());
                    tranDetail.setPayAcctNo(subAcctInfo.getSubAcctNo());
                } else {
                    if (!"C".equals(eventA.getDrCrFlag())) throw new BusinessException("RSP_CODE_DAO_ERROR", "\u4f1a\u8ba1\u5f15\u64ce\u670d\u52a1-\u4f1a\u8ba1\u914d\u7f6e\u8868\u51fa\u9519\uff1a\u501f\u8d37\u65b9\u5411\u7b26\u53f7\u65e0\u6cd5\u8bc6\u522b");
                    tranDetail.setRecvAcctNo(subAcctInfo.getSubAcctNo());
                }
            }
            if ("1".equals(eventB.getServiceType().toString().substring(0, 1))) {
                if ("D".equals(eventB.getDrCrFlag())) {
                    tranDetail.setOrgId(reqBO.getOrgId());
                    tranDetail.setPayAcctNo(reqBO.getClientAcctNo());
                } else {
                    if (!"C".equals(eventB.getDrCrFlag())) throw new BusinessException("RSP_CODE_DAO_ERROR", "\u4f1a\u8ba1\u5f15\u64ce\u670d\u52a1-\u4f1a\u8ba1\u914d\u7f6e\u8868\u51fa\u9519\uff1a\u501f\u8d37\u65b9\u5411\u7b26\u53f7\u65e0\u6cd5\u8bc6\u522b");
                    tranDetail.setRecvAcctNo(reqBO.getClientAcctNo());
                }
            } else {
                subAcctInfo = this.subAccountService.getWithMainAccount(reqBO.getOperUnit(), reqBO.getSource(), reqBO.getOperUnit(), reqBO.getProjectId(), eventB.getServiceType());
                if (subAcctInfo == null) {
                    logger.debug((Object)("\u67e5\u8be2\u865a\u62df\u5b50\u8d26\u6237\u5165\u53c2\u4e3a\uff1a operUnitNo=" + reqBO.getOperUnit() + ", souce=" + reqBO.getSource() + ", operUnit=" + reqBO.getOperUnit() + ", projectId=" + reqBO.getProjectId() + ", serviceType= " + eventB.getServiceType()));
                    throw new BusinessException("1000", "\u4f1a\u8ba1\u5f15\u64ce\u670d\u52a1-\u539f\u5b50\u670d\u52a1\u5f02\u5e38\uff1a\u865a\u62df\u5b50\u8d26\u6237\u4e0d\u5b58\u5728");
                }
                if ("D".equals(eventB.getDrCrFlag())) {
                    tranDetail.setOrgId(reqBO.getOperUnit());
                    tranDetail.setPayAcctNo(subAcctInfo.getSubAcctNo());
                } else {
                    if (!"C".equals(eventB.getDrCrFlag())) throw new BusinessException("RSP_CODE_DAO_ERROR", "\u4f1a\u8ba1\u5f15\u64ce\u670d\u52a1-\u4f1a\u8ba1\u914d\u7f6e\u8868\u51fa\u9519\uff1a\u501f\u8d37\u65b9\u5411\u7b26\u53f7\u65e0\u6cd5\u8bc6\u522b");
                    tranDetail.setRecvAcctNo(subAcctInfo.getSubAcctNo());
                }
            }
            tranDetail.setTranAmt(amounts.get(i));
            tranDetail.setBusinessType(reqBO.getBusinessType());
            tranDetail.setServiceNo(reqBO.getServiceNo());
            tranDetail.setRemark(reqBO.getRemark());
            tranDetail.setSsn(reqBO.getSsn());
            tranDetail.setPostDate(reqBO.getPostDate());
            tranDetail.setLoginId(reqBO.getLoginId());
            logger.debug((Object)tranDetail);
            boolean syncFlag = "Y".equals(eventA.getSyncFlag());
            TranDetail result = this.transactionService.transfer(tranDetail, syncFlag, null);
            if (result == null || StringUtils.isEmpty((Object)result.getTxnNo())) {
                throw new BusinessException("1003", "\u4f1a\u8ba1\u5f15\u64ce\u670d\u52a1-\u8c03\u7528\u8f6c\u8d26\u5904\u7406\u539f\u5b50\u670d\u52a1\uff0c\u8fd4\u56de\u4e3a\u7a7a");
            }
            linkedList.add(result.getTxnNo());
        }
        return linkedList;
    }

    private void adjustBookEvent(List<BookEvent> bookEvents, List<BigDecimal> amounts) {
        for (int i = 0; i < amounts.size(); ++i) {
            BigDecimal amount = amounts.get(i);
            if (amount.compareTo(BigDecimal.ZERO) >= 0) continue;
            amounts.set(i, amount.abs());
            Integer indexA = i * 2;
            Integer indexB = i * 2 + 1;
            BookEvent bookEventA = bookEvents.get(indexA);
            BookEvent bookEventB = bookEvents.get(indexB);
            String drCrFlag = bookEventA.getDrCrFlag();
            bookEventA.setDrCrFlag(bookEventB.getDrCrFlag());
            bookEventB.setDrCrFlag(drCrFlag);
        }
    }
}

