/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.BusiAccountBalanceCheckingService;
import com.tydic.fsc.settle.busi.api.bo.BusiAccountBalanceCheckingReqBO;
import com.tydic.fsc.settle.busi.api.bo.SubAcctInfoExt;
import com.tydic.fsc.settle.dao.SubAcctInfoMapper;
import com.tydic.fsc.settle.enums.SubAccountServiceType;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BusiAccountBalanceCheckingServiceImpl
implements BusiAccountBalanceCheckingService {
    private static final Logger logger = LoggerFactory.getLogger(BusiAccountBalanceCheckingServiceImpl.class);
    @Autowired
    private SubAcctInfoMapper subAcctInfoMapper;

    public FscBaseRspBo process(BusiAccountBalanceCheckingReqBO reqBO) {
        SubAcctInfoExt record;
        if (logger.isDebugEnabled()) {
            logger.debug("\u8d26\u6237\u4f59\u989d\u5bf9\u8d26\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        String copyFromSubAcctInfo = reqBO.getCopyFromSubAcctInfo();
        String url = reqBO.getUrl();
        List mainAcctNos = reqBO.getMainAcctNos();
        List subAcctNos = reqBO.getSubAcctNos();
        if (!StringUtils.hasText((String)url)) {
            url = "http://172.16.1.48:7072";
        }
        if (CollectionUtils.isEmpty((Collection)mainAcctNos)) {
            mainAcctNos = null;
        }
        if (CollectionUtils.isEmpty((Collection)subAcctNos)) {
            subAcctNos = null;
        }
        if ("1".equals(copyFromSubAcctInfo)) {
            record = new SubAcctInfoExt();
            this.subAcctInfoMapper.deleteCheckingResult(record);
            this.subAcctInfoMapper.initCheckingResult(record);
        }
        record = new SubAcctInfoExt();
        record.setMainAcctNos(mainAcctNos);
        record.setSubAcctNos(subAcctNos);
        record.setServiceType(SubAccountServiceType.DEFAULT.getCode());
        List<SubAcctInfoExt> accts = this.subAcctInfoMapper.selectCheckingResult(record);
        SimpleDateFormat dateFormat1 = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat dateFormat2 = new SimpleDateFormat("HHmmss");
        Date date = new Date();
        for (SubAcctInfoExt acct : accts) {
            int bodyLength;
            String mainAcctNo = acct.getMainAcctNo();
            String subAcctNo = acct.getSubAcctNo();
            PostMethod postMethod = new PostMethod(url);
            StringBuilder body = new StringBuilder();
            body.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("<service version=\"2.0\">").append("<SYS_HEAD>").append("<SERVICE_CODE attr=\"s,11\">bms_zizhxxcx</SERVICE_CODE>").append("<SERVICE_SCENE attr=\"s,2\">00</SERVICE_SCENE>").append("<CONSUMER_ID attr=\"s,6\">505036</CONSUMER_ID>").append("<CONSUMER_SEQ_NO attr=\"s,52\">5050201707210000000001</CONSUMER_SEQ_NO>").append("<TRAN_DATE attr=\"s,8\">").append(dateFormat1.format(date)).append("</TRAN_DATE>").append("<TRAN_TIMESTAMP attr=\"s,9\">").append(dateFormat2.format(date)).append("</TRAN_TIMESTAMP>").append("<RET attr=\"array\">").append("<struct>").append("<RET_MSG attr=\"s,30\">msg1</RET_MSG>").append("<RET_CODE attr=\"s,30\">code1</RET_CODE>").append("</struct>").append("</RET>").append("</SYS_HEAD>").append("<APP_HEAD>").append("<BIZ_SEQ_NO attr=\"s,50\"></BIZ_SEQ_NO>").append("<USER_ID attr=\"s,20\">EB001</USER_ID>").append("<ACCOUNT_DATE attr=\"s,8\"></ACCOUNT_DATE>").append("<BRANCH_ID attr=\"s,10\">9998</BRANCH_ID>").append("</APP_HEAD>").append("<LOCAL_HEAD>").append("</LOCAL_HEAD>").append("<BODY>").append("<zhuzhanghao attr=\"s,50\">").append(mainAcctNo).append("</zhuzhanghao>").append("<zizhanghao attr=\"s,50\">").append(subAcctNo).append("</zizhanghao>").append("</BODY>").append("</service>");
            StringBuilder head = new StringBuilder();
            head.append("A001350201505036              ");
            try {
                bodyLength = body.toString().getBytes("GBK").length;
            }
            catch (UnsupportedEncodingException e) {
                logger.error("\u62a5\u6587\u4f53\u89e3\u6790\u51fa\u9519\u3002\u62a5\u6587\u4f53\uff1a" + body, (Throwable)e);
                record = new SubAcctInfoExt();
                record.setSubAcctNo(subAcctNo);
                record.setCheckingRemark("\u62a5\u6587\u4f53\u89e3\u6790\u51fa\u9519\u3002\u9519\u8bef\u4fe1\u606f\uff1a" + e);
                record.setCheckingDate(new Date());
                this.processResult(record);
                this.subAcctInfoMapper.updateCheckingResult(record);
                continue;
            }
            String bodyLengthString = String.format("%010d", bodyLength);
            head.append(bodyLengthString);
            head.append("000000000000120180911101632000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001RSA-SHA1000000000000000");
            String xml = head.append((CharSequence)body).toString();
            logger.debug("\u8bf7\u6c42\u62a5\u6587\uff1a" + xml);
            try {
                postMethod.setRequestEntity((RequestEntity)new StringRequestEntity(xml, "text/html", "GBK"));
            }
            catch (UnsupportedEncodingException e) {
                logger.error("\u8bf7\u6c42\u62a5\u6587\u89e3\u6790\u51fa\u9519\u3002\u8bf7\u6c42\u62a5\u6587\uff1a" + xml, (Throwable)e);
                record = new SubAcctInfoExt();
                record.setSubAcctNo(subAcctNo);
                record.setCheckingRemark("\u8bf7\u6c42\u62a5\u6587\u89e3\u6790\u51fa\u9519\u3002\u9519\u8bef\u4fe1\u606f\uff1a" + e);
                record.setCheckingDate(new Date());
                this.processResult(record);
                this.subAcctInfoMapper.updateCheckingResult(record);
                continue;
            }
            postMethod.setRequestHeader("Content-Type", "text/xml; charset=GBK");
            HttpClient httpClient = new HttpClient();
            int status = 0;
            try {
                status = httpClient.executeMethod((HttpMethod)postMethod);
            }
            catch (Exception e) {
                logger.error("http\u8bf7\u6c42\u51fa\u9519\u3002\u8bf7\u6c42\u62a5\u6587\uff1a" + xml, (Throwable)e);
                record = new SubAcctInfoExt();
                record.setSubAcctNo(subAcctNo);
                record.setCheckingRemark("http\u8bf7\u6c42\u51fa\u9519\u3002\u9519\u8bef\u4fe1\u606f\uff1a" + e);
                record.setCheckingDate(new Date());
                this.processResult(record);
                this.subAcctInfoMapper.updateCheckingResult(record);
                continue;
            }
            logger.debug("http\u8bf7\u6c42\u54cd\u5e94\u72b6\u6001\uff1a" + status);
            String res = null;
            try {
                res = new String(postMethod.getResponseBody(), "GBK");
            }
            catch (Exception e) {
                logger.error("\u54cd\u5e94\u62a5\u6587\u89e3\u6790\u51fa\u9519", (Throwable)e);
                record = new SubAcctInfoExt();
                record.setSubAcctNo(subAcctNo);
                record.setCheckingRemark("\u54cd\u5e94\u62a5\u6587\u89e3\u6790\u51fa\u9519\u3002\u9519\u8bef\u4fe1\u606f\uff1a" + e);
                record.setCheckingDate(new Date());
                this.processResult(record);
                this.subAcctInfoMapper.updateCheckingResult(record);
                continue;
            }
            logger.debug("\u54cd\u5e94\u62a5\u6587\uff1a" + res);
            postMethod.releaseConnection();
            BigDecimal zizhye = null;
            int serviceNodeStart = res.indexOf("<zizhye");
            int serviceNodeEnd = res.indexOf("</zizhye");
            if (serviceNodeStart >= 0 && serviceNodeEnd >= 0) {
                try {
                    String tmp = res.substring(serviceNodeStart, serviceNodeEnd);
                    tmp = tmp.substring(tmp.indexOf(">") + 1);
                    zizhye = new BigDecimal(tmp);
                }
                catch (Exception e) {
                    logger.error("\u54cd\u5e94\u62a5\u6587\u89e3\u6790\u51fa\u9519\u3002\u54cd\u5e94\u62a5\u6587\uff1a" + res, (Throwable)e);
                    record = new SubAcctInfoExt();
                    record.setSubAcctNo(subAcctNo);
                    record.setCheckingRemark("\u54cd\u5e94\u62a5\u6587\u89e3\u6790\u51fa\u9519\u3002\u9519\u8bef\u4fe1\u606f\uff1a" + e);
                    record.setCheckingDate(new Date());
                    this.processResult(record);
                    this.subAcctInfoMapper.updateCheckingResult(record);
                    continue;
                }
            }
            if (zizhye == null) continue;
            record = new SubAcctInfoExt();
            record.setSubAcctNo(subAcctNo);
            record.setBalanceBank(zizhye);
            record.setCheckingRemark("");
            record.setCheckingDate(new Date());
            this.processResult(record);
            this.subAcctInfoMapper.updateCheckingResult(record);
        }
        return new FscBaseRspBo();
    }

    private void processResult(SubAcctInfoExt record) {
        String checkingRemark = record.getCheckingRemark();
        if (StringUtils.hasText((String)checkingRemark)) {
            checkingRemark = checkingRemark.length() > 1000 ? checkingRemark.substring(0, 1000) : checkingRemark;
        }
        record.setCheckingRemark(checkingRemark);
    }
}

