/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.BusiAddBillNotificationImportInfoService;
import com.tydic.fsc.settle.busi.api.bo.BillNotificationImportInfoBO;
import com.tydic.fsc.settle.busi.api.bo.BusiAddBillNotificationImportInfoReqBO;
import com.tydic.fsc.settle.dao.BillNotificationImportInfoMapper;
import com.tydic.fsc.settle.dao.BillNotificationInfoMapper;
import com.tydic.fsc.settle.dao.po.BillNotificationImportInfo;
import com.tydic.fsc.settle.dao.po.BillNotificationInfo;
import com.tydic.fsc.settle.enums.NotificationInvoiceStatus;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BusiAddBillNotificationImportInfoServiceImpl
implements BusiAddBillNotificationImportInfoService {
    private static final Logger logger = LoggerFactory.getLogger(BusiAddBillNotificationImportInfoServiceImpl.class);
    @Autowired
    private BillNotificationImportInfoMapper billNotificationImportInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private EnumsService enumsService;

    public FscBaseRspBo insert(BusiAddBillNotificationImportInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u65b0\u589e\u5f00\u7968\u901a\u77e5\u5355\u5bfc\u5165\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (null == reqBO) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List importInfoList = reqBO.getNotificationImportInfoList();
        if (CollectionUtils.isEmpty((Collection)importInfoList)) {
            throw new BusinessException("1001", "\u5f00\u7968\u901a\u77e5\u5355\u53f7\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String newLineStr = "<br/>";
        StringBuilder errorSbContnet = new StringBuilder();
        for (BillNotificationImportInfoBO importInfoBO : importInfoList) {
            String notificationNo = importInfoBO.getNotificationNo();
            BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByPrimaryKey(notificationNo);
            if (null == billNotificationInfo) {
                errorSbContnet.append("\u5f00\u7968\u901a\u77e5\u5355" + notificationNo + ",\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u8be5\u6761\u901a\u77e5\u5355,\u5bfc\u5165\u5931\u8d25\u3002").append(newLineStr);
                continue;
            }
            NotificationInvoiceStatus invoiceStatusEnum = NotificationInvoiceStatus.getInstance(billNotificationInfo.getInvoiceStatus());
            if (NotificationInvoiceStatus.HAS_MAKE.getCode().equals(invoiceStatusEnum.getCode())) continue;
            errorSbContnet.append("\u5f00\u7968\u901a\u77e5\u5355" + notificationNo + ",\u53d1\u7968\u72b6\u6001\u4e3a" + this.enumsService.getDescr(invoiceStatusEnum) + ",\u5bfc\u5165\u5931\u8d25\u3002").append(newLineStr);
        }
        if (errorSbContnet.length() >= 1) {
            Calendar cal = Calendar.getInstance();
            StringBuilder errorSbHead = new StringBuilder();
            errorSbHead.append(cal.get(1)).append("\u5e74").append(cal.get(2) + 1).append("\u6708").append(cal.get(5)).append("\u65e5").append("\u5bfc\u5165\u7ed3\u679c:\u5171\u8ba1\u5bfc\u5165").append(importInfoList.size()).append("\u6761\u5355\u636e,").append(0).append("\u6761\u6210\u529f,").append(importInfoList.size()).append("\u6761\u5931\u8d25\uff0c\u5931\u8d25\u7684\u8be6\u7ec6\u5185\u5bb9\u5982\u4e0b:").append(newLineStr);
            StringBuilder errorSbTail = new StringBuilder("\u56e0\u5bfc\u5165\u5185\u5bb9\u5b58\u5728\u5931\u8d25\u7684\u5f00\u7968\u901a\u77e5\u5355\uff0c\u8bf7\u6574\u7406\u7ebf\u4e0b\u6570\u636e\u540e\u91cd\u8bd5\u3002");
            String errorMsg = errorSbHead.append(errorSbContnet.toString()).append(errorSbTail.toString()).toString();
            throw new BusinessException("1001", errorMsg);
        }
        this.billNotificationImportInfoMapper.deleteAll();
        ArrayList<BillNotificationImportInfo> list = new ArrayList<BillNotificationImportInfo>();
        for (BillNotificationImportInfoBO importInfoBO : importInfoList) {
            BillNotificationImportInfo billNotificationImportInfo = new BillNotificationImportInfo();
            BeanUtils.copyProperties((Object)importInfoBO, (Object)billNotificationImportInfo);
            list.add(billNotificationImportInfo);
        }
        this.billNotificationImportInfoMapper.insertBatch(list);
        return new FscBaseRspBo();
    }
}

