/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.SubAccountService;
import com.tydic.fsc.settle.atom.UserInfoService;
import com.tydic.fsc.settle.busi.api.BusiAdvanceRecQueryService;
import com.tydic.fsc.settle.busi.api.bo.BusiAdvanceRecQueryReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiAdvanceRecQueryRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiAdvanceRecQuerySubRspBO;
import com.tydic.fsc.settle.busi.api.bo.SubAcctInfoExt;
import com.tydic.fsc.settle.dao.AdvanceReceiveMapper;
import com.tydic.fsc.settle.dao.SubAcctInfoMapper;
import com.tydic.fsc.settle.dao.po.AdvanceReceive;
import com.tydic.fsc.settle.dao.po.SubAcctInfo;
import com.tydic.fsc.settle.dao.vo.AdvanceRecQueryVO;
import com.tydic.fsc.settle.dao.vo.AdvanceReceiveVO;
import com.tydic.fsc.settle.enums.AdvanceReceiveStatus;
import com.tydic.fsc.settle.enums.BaseEnums;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.ReceiveType;
import com.tydic.fsc.settle.utils.FileUtils;
import com.tydic.fsc.supplier.bo.ProjectInfoBO;
import com.tydic.fsc.supplier.bo.UserDetailInfoBO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiAdvanceRecQueryServiceImpl
implements BusiAdvanceRecQueryService {
    private static final Logger logger = LoggerFactory.getLogger(BusiAdvanceRecQueryServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private OrganizationInfoService organizationInfoService;
    private UserInfoService userInfoService;
    private SubAccountService subAccountService;
    private EnumsService enumsService;
    private AdvanceReceiveMapper advanceReceiveMapper;
    private SubAcctInfoMapper subAcctInfoMapper;

    @Autowired
    private BusiAdvanceRecQueryServiceImpl(OrganizationInfoService organizationInfoService, UserInfoService userInfoService, SubAccountService subAccountService, EnumsService enumsService, AdvanceReceiveMapper advanceReceiveMapper, SubAcctInfoMapper subAcctInfoMapper) {
        this.organizationInfoService = organizationInfoService;
        this.userInfoService = userInfoService;
        this.subAccountService = subAccountService;
        this.enumsService = enumsService;
        this.advanceReceiveMapper = advanceReceiveMapper;
        this.subAcctInfoMapper = subAcctInfoMapper;
    }

    public BusiAdvanceRecQueryRspBO queryBusiAdvanceRec(BusiAdvanceRecQueryReqBO reqBO) {
        UserDetailInfoBO userDetailInfoBO;
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u6536\u6b3e\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (null != (userDetailInfoBO = this.userInfoService.queryUserInfoByUserId(reqBO.getUserId()))) {
            reqBO.setOrgId(userDetailInfoBO.getOrgId());
            reqBO.setCompanyId(userDetailInfoBO.getCompanyId());
        }
        if (reqBO.getCompanyId() == null || reqBO.getCompanyId() <= 0L) {
            throw new BusinessException("1001", "\u516c\u53f8ID[companyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSource())) {
            throw new BusinessException("1001", "\u67e5\u8be2\u6536\u6b3e\u4fe1\u606f\u670d\u52a1-\u6765\u6e90[source]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AdvanceRecQueryVO vo = new AdvanceRecQueryVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)vo);
        vo.setOrgId(reqBO.getCompanyId());
        vo.setJiaoylsh(reqBO.getSsn());
        vo.setAccountId(reqBO.getAccountId());
        vo.setOrderBy("POST_DATE desc");
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<AdvanceReceiveVO> rows = this.advanceReceiveMapper.selectByConditions(vo, (Page<Map<String, Object>>)page);
        BusiAdvanceRecQueryRspBO rspBO = new BusiAdvanceRecQueryRspBO();
        BeanUtils.copyProperties((Object)vo, (Object)rspBO);
        ArrayList<BusiAdvanceRecQuerySubRspBO> detailRows = new ArrayList<BusiAdvanceRecQuerySubRspBO>();
        for (AdvanceReceiveVO rowVo : rows) {
            AdvanceReceiveStatus receiveStatus;
            BusiAdvanceRecQuerySubRspBO detail = new BusiAdvanceRecQuerySubRspBO();
            BeanUtils.copyProperties((Object)rowVo, (Object)detail);
            AdvanceReceive row = new AdvanceReceive();
            BeanUtils.copyProperties((Object)rowVo, (Object)row);
            String payOrgName = this.organizationInfoService.obtainOrgNameByAdvanceReceive(row);
            detail.setPayOrgName(payOrgName);
            String recOrgName = this.organizationInfoService.queryOrgName(rowVo.getRecOrgId());
            detail.setRecOrgName(recOrgName);
            if (payOrgName != null) {
                if (payOrgName.equals(detail.getTransferAcctName())) {
                    detail.setAgreement("\u4e00\u81f4");
                } else {
                    detail.setAgreement("\u4e0d\u4e00\u81f4");
                }
            }
            detail.setRecTypeName(this.enumsService.getDescr(ReceiveType.getInstance(rowVo.getRecType())));
            SubAcctInfoExt subAcctInfoExt = this.subAccountService.getWithMainAccount(rowVo.getRecSubAcct());
            if (subAcctInfoExt != null) {
                detail.setSourceName(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)subAcctInfoExt.getSource())));
            }
            detail.setStatusDescr(null == (receiveStatus = AdvanceReceiveStatus.getInstance(rowVo.getStatus())) ? "" : receiveStatus.getCodeDescr());
            try {
                String subAcctNo = row.getRecSubAcct();
                SubAcctInfo subAcctInfo = this.subAcctInfoMapper.selectByPrimaryKey(subAcctNo);
                logger.info("\u67e5\u8be2\u5230\u7684accountId\u662f:" + subAcctInfo.getProjectId());
                Long account = subAcctInfo.getProjectId();
                ProjectInfoBO projectInfoBO = this.organizationInfoService.queryProjectName(account);
                detail.setIsVirtual(Integer.toString(projectInfoBO.getIsShadowAccount()));
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u670d\u52a1\u53d1\u751f\u9519\u8bef" + e);
            }
            detail.setToReceiveAmt(detail.getTranAmt().subtract(detail.getWriteoffAmt()));
            detail.setReceiptUrl(FileUtils.obtainOSSUrl(detail.getReceipt()));
            detailRows.add(detail);
        }
        rspBO.setRows(detailRows);
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(page.getPageNo());
        return rspBO;
    }
}

