/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.JdExpressTokenService;
import com.tydic.fsc.settle.busi.api.bo.BusiApplyMailForInvoiceReqBO;
import com.tydic.fsc.settle.busi.api.bo.QueryBillApplyForMailReqBO;
import com.tydic.fsc.settle.busi.api.vo.BusiApplyMailVO;
import com.tydic.fsc.settle.busi.api.vo.InvoiceForMailVO;
import com.tydic.fsc.settle.busi.impl.BusiApplyMailForInvoiceRunnable;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.SaleInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.SaleInvoiceMailInfoMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.po.JdexpressToken;
import com.tydic.fsc.settle.dao.po.SaleInvoiceInfo;
import com.tydic.fsc.settle.dao.po.SaleInvoiceMailInfo;
import com.tydic.fsc.settle.enums.InvoiceMailSentStatus;
import com.tydic.fsc.settle.utils.FscStringUtils;
import com.tydic.fsc.settle.utils.SpringApplicationContext;
import com.tydic.fsc.supplier.BusiJdExpressService;
import com.tydic.fsc.supplier.bo.JdexpressTokenVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.StringUtils;

@Component
public class BusiApplyMailForImportInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(BusiApplyMailForImportInvoiceService.class);
    @Autowired
    private SaleInvoiceMailInfoMapper saleInvoiceMailInfoMapper;
    @Autowired
    private BusiJdExpressService busiJdExpressConfigService;
    @Autowired
    private JdExpressTokenService jdExpressTokenService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private EnumsService enumsService;

    public void process(BusiApplyMailForInvoiceReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u90ae\u5bc4\u53d1\u7968\uff08\u5bfc\u5165\u7684\u53d1\u7968\uff09\uff08\u4e0d\u5305\u62ec\u5e73\u53f0\u4f7f\u7528\u8d39\uff09\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO.getCompanyId() == null) {
            throw new BusinessException("1001", "\u4e13\u4e1a\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getUserId() == null) {
            throw new BusinessException("1001", "\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSenderName())) {
            throw new BusinessException("1001", "\u5bc4\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSenderAddr())) {
            throw new BusinessException("1001", "\u5bc4\u65b9\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSenderPhone())) {
            throw new BusinessException("1001", "\u5bc4\u65b9\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getApplyMailVoList() == null || reqBO.getApplyMailVoList().isEmpty()) {
            throw new BusinessException("1001", "\u8bf7\u52fe\u9009");
        }
        DataSourceTransactionManager transactionManager = SpringApplicationContext.getTransactionManager();
        DefaultTransactionDefinition transDefinition = new DefaultTransactionDefinition();
        transDefinition.setPropagationBehavior(3);
        TransactionStatus transactionStatus = transactionManager.getTransaction((TransactionDefinition)transDefinition);
        List<BusiApplyMailForInvoiceRunnable> runnables = null;
        try {
            runnables = this.process2(reqBO);
            transactionManager.commit(transactionStatus);
        }
        catch (Exception e) {
            logger.error("\u90ae\u5bc4\u5931\u8d25", (Throwable)e);
            transactionManager.rollback(transactionStatus);
            throw new BusinessException("1002", e.getMessage());
        }
        int size = runnables.size();
        logger.debug("\u9700\u8981\u90ae\u5bc4\u7684\u5feb\u9012\u5355\u6570\u91cf\uff1a" + size);
        int maxThreadSize = this.enumsService.queryMaxThreadSize();
        ExecutorService executorService = Executors.newFixedThreadPool(size > maxThreadSize ? maxThreadSize : size);
        CountDownLatch latch = new CountDownLatch(size);
        for (BusiApplyMailForInvoiceRunnable runnable : runnables) {
            runnable.setLatch(latch);
            executorService.submit(runnable);
        }
        executorService.shutdown();
        try {
            latch.await(this.enumsService.queryMaxSleepTime(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    private List<BusiApplyMailForInvoiceRunnable> process2(BusiApplyMailForInvoiceReqBO reqBO) {
        JdexpressToken token = this.jdExpressTokenService.getToken(reqBO.getCompanyId());
        if (null == token) {
            throw new BusinessException("1002", "token\u4fe1\u606f\u672a\u7ef4\u62a4,\u8bf7\u5148\u7ef4\u62a4");
        }
        JdexpressTokenVO tokenVO = new JdexpressTokenVO();
        BeanUtils.copyProperties((Object)token, (Object)tokenVO);
        List toMailList = reqBO.getApplyMailVoList();
        List mailTicketNos = new ArrayList();
        Integer toMailCount = toMailList.size();
        try {
            if (toMailCount > 100) {
                Integer circleTimes = toMailCount % 100 > 0 ? toMailCount / 100 + 1 : toMailCount / 100;
                for (int i = 0; i < circleTimes; ++i) {
                    int count = i == circleTimes - 1 && toMailCount % 100 > 0 ? toMailCount % 100 : 100;
                    mailTicketNos.addAll(this.busiJdExpressConfigService.applyBillCode(count, tokenVO));
                }
            } else {
                mailTicketNos = this.busiJdExpressConfigService.applyBillCode(toMailCount.intValue(), tokenVO);
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u4eac\u4e1c-\u7533\u8bf7\u5feb\u9012\u5355\u53f7\u63a5\u53e3\u51fa\u9519", (Throwable)e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u8c03\u7528\u4eac\u4e1c-\u7533\u8bf7\u5feb\u9012\u5355\u53f7\u63a5\u53e3\u51fa\u9519", (Throwable)e);
        }
        if (null == mailTicketNos) {
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u7533\u8bf7\u5feb\u9012\u5355\u53f7\u5931\u8d25");
        }
        if (mailTicketNos.size() < toMailCount) {
            logger.error("\u6ca1\u6709\u7533\u8bf7\u5230\u8db3\u591f\u6570\u91cf\u7684\u5feb\u9012\u5355\u53f7\uff0c\u9700\u8981\u7684\u6570\u91cf\uff1a" + toMailCount + "\uff0c\u7533\u8bf7\u7684\u6570\u91cf\uff1a" + mailTicketNos.size());
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u6ca1\u6709\u7533\u8bf7\u5230\u8db3\u591f\u6570\u91cf\u7684\u5feb\u9012\u5355\u53f7");
        }
        ArrayList<BusiApplyMailForInvoiceRunnable> runnables = new ArrayList<BusiApplyMailForInvoiceRunnable>();
        QueryBillApplyForMailReqBO condition = new QueryBillApplyForMailReqBO();
        condition.setSource(reqBO.getSource());
        condition.setCompanyId(reqBO.getCompanyId());
        condition.setUserId(reqBO.getUserId());
        ArrayList<BusiApplyMailVO> keyFields = new ArrayList<BusiApplyMailVO>();
        condition.setKeyFields(keyFields);
        for (BusiApplyMailVO toMail : toMailList) {
            BusiApplyMailVO keyField = new BusiApplyMailVO();
            keyFields.add(keyField);
            keyField.setInvoceName(toMail.getInvoceName());
            keyField.setName(toMail.getName());
        }
        String orderBy = "b.SEQ asc";
        List<InvoiceForMailVO> invoiceForMailVOs = this.saleInvoiceMailInfoMapper.queryToMailInvoiceImport(condition, orderBy);
        int i = 0;
        for (BusiApplyMailVO toMail : toMailList) {
            String mailTicketNo = (String)mailTicketNos.get(i++);
            ArrayList<InvoiceForMailVO> invoices = new ArrayList<InvoiceForMailVO>();
            Iterator<InvoiceForMailVO> iterator = invoiceForMailVOs.iterator();
            while (iterator.hasNext()) {
                InvoiceForMailVO invoice = iterator.next();
                if (toMail.getInvoceName().equals(invoice.getInvoceName()) && toMail.getName().equals(invoice.getName())) {
                    invoices.add(invoice);
                    iterator.remove();
                    continue;
                }
                if (invoices.size() <= 0) continue;
                break;
            }
            if (invoices.isEmpty()) continue;
            InvoiceForMailVO firstInvoice = (InvoiceForMailVO)invoices.get(0);
            BillApplyInfo applyInfoPO = this.billApplyInfoMapper.selectByPrimaryKey(firstInvoice.getApplyNo());
            String province = FscStringUtils.valueOf(applyInfoPO.getProvince());
            String city = FscStringUtils.valueOf(applyInfoPO.getCity());
            String county = FscStringUtils.valueOf(applyInfoPO.getCounty());
            String town = FscStringUtils.valueOf(applyInfoPO.getTown());
            String addrDesc = FscStringUtils.valueOf(applyInfoPO.getAddrDesc());
            String addressStr = FscStringUtils.simplifyAddrdesc(province, city, county, town, addrDesc);
            SaleInvoiceMailInfo po = new SaleInvoiceMailInfo();
            po.setMailTicketNo(mailTicketNo);
            po.setOperUnitNo(reqBO.getCompanyId());
            po.setInvoiceType(firstInvoice.getInvoiceType());
            po.setInvoceName(toMail.getInvoceName());
            po.setMailStatus(InvoiceMailSentStatus.PROCCESSING.getCode());
            po.setAddress(addressStr);
            po.setReceiver(toMail.getName());
            po.setTel(applyInfoPO.getMobile());
            po.setJdAssignStatus(null);
            po.setFailReason(null);
            po.setCreateUser(reqBO.getUsername());
            po.setCreateDate(new Date());
            po.setSender(reqBO.getSenderName());
            po.setSenderAddress(reqBO.getSenderAddr());
            po.setSenderTel(reqBO.getSenderPhone());
            this.saleInvoiceMailInfoMapper.insert(po);
            for (int j = 0; j < invoices.size(); ++j) {
                InvoiceForMailVO invoice = (InvoiceForMailVO)invoices.get(j);
                SaleInvoiceInfo saleInvoiceInfo = new SaleInvoiceInfo();
                saleInvoiceInfo.setInvoiceNo(invoice.getInvoiceNo());
                saleInvoiceInfo.setMailTicketNo(mailTicketNo);
                saleInvoiceInfo.setOrderId(j + 1);
                this.saleInvoiceInfoMapper.updateByPrimaryKeySelective(saleInvoiceInfo);
            }
            BusiApplyMailForInvoiceRunnable runnable = new BusiApplyMailForInvoiceRunnable();
            runnable.setJdToken(tokenVO);
            runnable.setMailTicketNo(mailTicketNo);
            runnables.add(runnable);
        }
        return runnables;
    }
}

