/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.BusiCancelBillApplyInfoDlzqService;
import com.tydic.fsc.settle.busi.api.bo.BusiCancelBillApplyInfoDlzqReqBO;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.SaleItemInfoMapper;
import com.tydic.fsc.settle.dao.SaleOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.po.SaleItemInfo;
import com.tydic.fsc.settle.dao.po.SaleOrderInfo;
import com.tydic.fsc.settle.dao.vo.BillApplyInfoVO;
import com.tydic.fsc.settle.dao.vo.SaleItemInfoVO;
import com.tydic.fsc.settle.dao.vo.SaleOrderInfoVO;
import com.tydic.fsc.settle.enums.BillStatus;
import com.tydic.fsc.settle.enums.OrderStatus;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiCancelBillApplyInfoDlzqServiceImpl
implements BusiCancelBillApplyInfoDlzqService {
    private static final Logger logger = LoggerFactory.getLogger(BusiCancelBillApplyInfoDlzqServiceImpl.class);
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;

    public FscBaseRspBo update(BusiCancelBillApplyInfoDlzqReqBO reqBO) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("\u53d6\u6d88\u5f00\u7968\u7533\u8bf7\u670d\u52a1(\u7535\u529b\u4e13\u533a)\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List applyNoList = reqBO.getApplyNoList();
        if (applyNoList == null || applyNoList.isEmpty()) {
            throw new BusinessException("1001", "\u5165\u53c2\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u3010applyNoList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setApplyNoList(applyNoList);
        List<BillApplyInfo> applys = this.billApplyInfoMapper.getList(billApplyInfoVO);
        for (BillApplyInfo apply : applys) {
            if (!BillStatus.NO_APPLY.getCode().equals(apply.getBillStatus())) {
                throw new BusinessException("1002", "\u5f00\u7968\u72b6\u6001\u5fc5\u987b\u662f" + BillStatus.NO_APPLY.getDescr());
            }
            if (reqBO.getCompanyId().equals(apply.getOperUnitNo())) continue;
            throw new BusinessException("1002", "\u4e0d\u80fd\u529e\u7406\u5176\u4ed6\u516c\u53f8\u7684\u4e1a\u52a1");
        }
        billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setApplyNoList(applyNoList);
        billApplyInfoVO.setBillStatus(BillStatus.NO_APPLY.getCode());
        BillApplyInfo billApplyInfo = new BillApplyInfo();
        billApplyInfo.setBillStatus(BillStatus.CANCEL_APPLY.getCode());
        this.billApplyInfoMapper.updateByCondition(billApplyInfoVO, billApplyInfo);
        SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
        saleItemInfoVO.setApplyNoList(applyNoList);
        List<Long> inspectionIdList = this.saleItemInfoMapper.selectDistinctInspectionId(saleItemInfoVO);
        if (!inspectionIdList.isEmpty()) {
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            saleOrderInfoVO.setInspectionIdList(inspectionIdList);
            SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
            saleOrderInfo.setApplyNo(null);
            saleOrderInfo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
            this.saleOrderInfoMapper.cancelBillApplyInfo(saleOrderInfoVO, saleOrderInfo);
        }
        saleItemInfoVO = new SaleItemInfoVO();
        saleItemInfoVO.setApplyNoList(applyNoList);
        SaleItemInfo saleItemInfo = new SaleItemInfo();
        saleItemInfo.setApplyNo(null);
        saleItemInfo.setItemStatus(OrderStatus.NO_APPLY.getCode());
        this.saleItemInfoMapper.cancelBillApplyInfo(saleItemInfoVO, saleItemInfo);
        return new FscBaseRspBo();
    }
}

