/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.BillSNService;
import com.tydic.fsc.settle.atom.FscWfStartAtomService;
import com.tydic.fsc.settle.atom.bo.FscWfStartAtomReqBO;
import com.tydic.fsc.settle.atom.bo.FscWfStartAtomRspBO;
import com.tydic.fsc.settle.busi.api.BusiCreateEntryTotalInfoService;
import com.tydic.fsc.settle.busi.api.bo.BusiCreateEntryToatalInfoReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiCreateEntryToatalInfoRspBO;
import com.tydic.fsc.settle.dao.EntryInfoMapper;
import com.tydic.fsc.settle.dao.EntryTotalInfoMapper;
import com.tydic.fsc.settle.dao.po.EntryInfoPO;
import com.tydic.fsc.settle.dao.po.EntryTotalInfoPO;
import com.tydic.fsc.settle.enums.BillType;
import com.tydic.fsc.settle.enums.WFBillType;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BusiCreateEntryTotalInfoServiceImpl
implements BusiCreateEntryTotalInfoService {
    private static final Logger logger = LoggerFactory.getLogger(BusiCreateEntryTotalInfoServiceImpl.class);
    @Autowired
    private EntryInfoMapper entryInfoMapper;
    @Autowired
    private EntryTotalInfoMapper entryTotalInfoMapper;
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private FscWfStartAtomService fscWfStartAtomService;

    public BusiCreateEntryToatalInfoRspBO createEntryTotalInfo(BusiCreateEntryToatalInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u751f\u6210\u6c47\u603b\u5355\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getEntryNoList())) {
            throw new BusinessException("1002", "\u5165\u5e93\u5355\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        logger.debug("\u589e\u52a0\u4e0d\u540c\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e00\u8d77\u6c47\u603b\u7684\u6821\u9a8c");
        List<Long> supplierIds = this.entryInfoMapper.getSupIdByIds(reqBO.getEntryNoList());
        HashSet<Long> set = new HashSet<Long>(supplierIds);
        if (set.size() != 1) {
            throw new BusinessException("8888", "\u4e0d\u540c\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e00\u8d77\u6c47\u603b");
        }
        Date documentationDate = new Date();
        BusiCreateEntryToatalInfoRspBO rspBO = new BusiCreateEntryToatalInfoRspBO();
        String applyNo = this.billSNService.getSnAsString(BillType.MATERIAL_COLLECT);
        BigDecimal notTaxAmt = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal amt = BigDecimal.ZERO;
        String source = null;
        Long purchaseId = null;
        for (String entryNo : reqBO.getEntryNoList()) {
            EntryInfoPO entryInfoPO = null;
            try {
                entryInfoPO = this.entryInfoMapper.getModelById(entryNo);
            }
            catch (Exception e) {
                logger.error("\u6839\u636e\u5165\u5e93\u5355\u53f7\u67e5\u8be2\u5165\u5e93\u5355\u8bb0\u5f55\u5931\u8d25,\u5165\u5e93\u5355\u53f7\u4e3a\uff1a" + entryNo, (Throwable)e);
                throw new BusinessException("1002", "\u67e5\u8be2\u5165\u5e93\u5355\u8bb0\u5f55\u5931\u8d25");
            }
            if (entryInfoPO == null) {
                logger.error("\u627e\u4e0d\u5230\u5165\u5e93\u5355\u53f7\u5bf9\u5e94\u7684\u5165\u5e93\u5355\u8bb0\u5f55\uff0c\u5165\u5e93\u5355\u53f7\u4e3a" + entryNo);
                throw new BusinessException("1002", "\u627e\u4e0d\u5230\u5165\u5e93\u5355\u53f7\u5bf9\u5e94\u7684\u5165\u5e93\u5355\u8bb0\u5f55\uff0c\u5165\u5e93\u5355\u53f7\u4e3a" + entryNo);
            }
            if ("02".equals(entryInfoPO.getStatus())) {
                logger.error("\u751f\u6210\u6c47\u603b\u5355\u5931\u8d25\uff0c\u5165\u5e93\u7f16\u53f7\u4e3a" + entryNo + "\u7684\u5165\u5e93\u5355\u5df2\u6c47\u603b");
                throw new BusinessException("1002", "\u751f\u6210\u6c47\u603b\u5355\u5931\u8d25\uff0c\u5165\u5e93\u7f16\u53f7\u4e3a" + entryNo + "\u7684\u5165\u5e93\u5355\u5df2\u6c47\u603b");
            }
            entryInfoPO.setApplyNo(applyNo);
            entryInfoPO.setStatus("02");
            try {
                this.entryInfoMapper.updateById(entryInfoPO);
            }
            catch (Exception e) {
                logger.error("entryInfoMapper========>updateById\u66f4\u65b0\u5165\u5e93\u5355\u8bb0\u5f55\u5931\u8d25\uff0c\u5165\u5e93\u7f16\u53f7\u4e3a\uff1a" + entryInfoPO.getEntryNo() + e);
                throw new BusinessException("1002", "\u66f4\u65b0\u5165\u5e93\u5355\u8bb0\u5f55\u5931\u8d25");
            }
            logger.info("\u6210\u529f\u6c47\u603b\u4e00\u7b14\u5165\u5e93\u5355\uff0c\u5165\u5e93\u5355\u53f7\u4e3a\uff1a" + entryNo + ",\u6c47\u603b\u7f16\u53f7\u4e3a\uff1a" + applyNo);
            if (entryInfoPO.getNotTaxAmt() == null) {
                logger.error("\u5165\u5e93\u5355\u53f7\u4e3a\uff1a" + entryInfoPO.getEntryNo() + "\u7684\u4e0d\u542b\u7a0e\u91d1\u989d\u4e3a\u7a7a");
                throw new BusinessException("1002", "\u5165\u5e93\u5355\u53f7\u4e3a\uff1a" + entryInfoPO.getEntryNo() + "\u7684\u4e0d\u542b\u7a0e\u91d1\u989d\u4e3a\u7a7a");
            }
            if (entryInfoPO.getTax() == null) {
                logger.error("\u5165\u5e93\u5355\u53f7\u4e3a" + entryInfoPO.getEntryNo() + "\u7684\u7a0e\u989d\u4e3a\u7a7a");
                throw new BusinessException("1002", "\u5165\u5e93\u5355\u53f7\u4e3a" + entryInfoPO.getEntryNo() + "\u7684\u7a0e\u989d\u4e3a\u7a7a");
            }
            if (entryInfoPO.getAmt() == null) {
                logger.error("\u5165\u5e93\u5355\u53f7\u4e3a" + entryInfoPO.getEntryNo() + "\u7684\u4ef7\u7a0e\u5408\u8ba1\u91d1\u989d\u4e3a\u7a7a");
                throw new BusinessException("1002", "\u5165\u5e93\u5355\u53f7\u4e3a" + entryInfoPO.getEntryNo() + "\u7684\u4ef7\u7a0e\u5408\u8ba1\u91d1\u989d\u4e3a\u7a7a");
            }
            notTaxAmt = notTaxAmt.add(entryInfoPO.getNotTaxAmt());
            tax = tax.add(entryInfoPO.getTax());
            amt = amt.add(entryInfoPO.getAmt());
            source = entryInfoPO.getSource();
            purchaseId = entryInfoPO.getPurchaseId();
        }
        EntryTotalInfoPO entryTotalInfoPO = new EntryTotalInfoPO();
        entryTotalInfoPO.setApplyNo(applyNo);
        entryTotalInfoPO.setNotTaxAmt(notTaxAmt);
        entryTotalInfoPO.setTax(tax);
        entryTotalInfoPO.setAmt(amt);
        entryTotalInfoPO.setSource(source);
        entryTotalInfoPO.setDocumentationDate(documentationDate);
        entryTotalInfoPO.setPurchaseId(purchaseId);
        entryTotalInfoPO.setDocumentationId(reqBO.getUserId());
        entryTotalInfoPO.setCompanyId(reqBO.getCompanyId());
        try {
            this.entryTotalInfoMapper.insert(entryTotalInfoPO);
        }
        catch (Exception e) {
            logger.error("\u63d2\u5165\u6c47\u603b\u5355\u8bb0\u5f55\u5931\u8d25\uff0c\u5236\u5355\u4eba\u4e3a\uff1a" + reqBO.getUserId(), (Throwable)e);
            throw new BusinessException("1002", "\u63d2\u5165\u6c47\u603b\u5355\u8bb0\u5f55\u5931\u8d25");
        }
        FscWfStartAtomReqBO atomReqBO = new FscWfStartAtomReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)atomReqBO));
        atomReqBO.setBillNo(applyNo);
        atomReqBO.setBillType(WFBillType.PURCHASE_STORAGE);
        atomReqBO.setFinishEvtServiceId("entryTotalWorkFlowFinshEventImpl");
        FscWfStartAtomRspBO atomRspBO = this.fscWfStartAtomService.dealStartApproval(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new BusinessException("1002", "\u751f\u6210\u7269\u8d44\u6c47\u603b\u5355\u670d\u52a1\u5931\u8d25,\u53d1\u8d77\u5ba1\u6279\u5931\u8d25");
        }
        logger.info("\u6210\u529f\u5411\u6c47\u603b\u5355\u8868\uff08d_entry_total_info\uff09\u63d2\u5165\u4e00\u7b14\u6c47\u603b\u5355\u8bb0\u5f55\uff0c\u6c47\u603b\u5355\u53f7\u4e3a\uff1a" + applyNo);
        rspBO.setApplyNo(applyNo);
        return rspBO;
    }
}

