/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.busi.api.BusiForConfirmQrySaleOrderInfoXbjService;
import com.tydic.fsc.settle.busi.api.bo.BusiForConfirmQrySaleOrderInfoXbjReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiForConfirmQrySaleOrderInfoXbjRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiForConfirmQrySaleOrderXbjListRspBO;
import com.tydic.fsc.settle.dao.SaleInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.SaleOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.SaleOrderInfo;
import com.tydic.fsc.settle.dao.vo.SaleOrderInfoVO;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.OrderStatus;
import com.tydic.fsc.settle.utils.FscStringUtils;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiForConfirmQrySaleOrderInfoXbjServiceImpl
implements BusiForConfirmQrySaleOrderInfoXbjService {
    private static final Logger logger = LoggerFactory.getLogger(BusiForConfirmQrySaleOrderInfoXbjServiceImpl.class);
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;

    public BusiForConfirmQrySaleOrderXbjListRspBO query(BusiForConfirmQrySaleOrderInfoXbjReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u8be2\u6bd4\u4ef7\u914d\u9001\u7c7b\u9500\u552e\u8ba2\u5355\u5217\u8868\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getCompanyId() || reqBO.getCompanyId() <= 0L) {
            throw new BusinessException("1001", "\u4e13\u4e1a\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SaleOrderInfoVO queryVO = new SaleOrderInfoVO();
        queryVO.setOperUnitNo(reqBO.getCompanyId());
        queryVO.setSourceList(Arrays.asList(OrderSource.CONSULT_PRICE_FRAME.getCode(), OrderSource.CONSULT_PRICE.getCode()));
        queryVO.setPurchaseProjectId(reqBO.getPurchaseProjectId());
        queryVO.setSaleOrderCode(reqBO.getSaleOrderCode());
        queryVO.setSupplierNo(reqBO.getSupplierNo());
        queryVO.setPurchaserName(reqBO.getPurchaserName());
        queryVO.setMinOrderAmt(reqBO.getMinOrderAmt());
        queryVO.setMaxOrderAmt(reqBO.getMaxOrderAmt());
        queryVO.setOrderDateStart(reqBO.getBeginOrderDate());
        queryVO.setOrderDateEnd(reqBO.getEndOrderDate());
        queryVO.setBeginRecvDate(reqBO.getBeginRecvDate());
        queryVO.setEndRecvDate(reqBO.getEndRecvDate());
        queryVO.setInvoiceNoStart(reqBO.getInvoiceNoStart());
        queryVO.setInvoiceNoEnd(reqBO.getInvoiceNoEnd());
        queryVO.setIsExecute("1");
        queryVO.setOrderBy("t.ORDER_ID DESC, t.INSPECTION_ID DESC");
        BusiForConfirmQrySaleOrderXbjListRspBO rspBO = new BusiForConfirmQrySaleOrderXbjListRspBO();
        LinkedList<BusiForConfirmQrySaleOrderInfoXbjRspBO> rows = new LinkedList<BusiForConfirmQrySaleOrderInfoXbjRspBO>();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<SaleOrderInfo> saleOrderList = this.saleOrderInfoMapper.getListPageJoinRecvAmtDetail(queryVO, (Page<Map<String, Object>>)page);
        for (SaleOrderInfo saleOrderInfoBO : saleOrderList) {
            BusiForConfirmQrySaleOrderInfoXbjRspBO infoRspBO = new BusiForConfirmQrySaleOrderInfoXbjRspBO();
            BeanUtils.copyProperties((Object)saleOrderInfoBO, (Object)infoRspBO);
            infoRspBO.setPurchaseName(this.organizationInfoService.queryProjectName(saleOrderInfoBO.getPurchaseProjectId()).getAccountName());
            infoRspBO.setOrderStatusDesrc(this.enumsService.getDescr(OrderStatus.getInstance(saleOrderInfoBO.getOrderStatus())));
            List<String> invoiceNoList = this.saleInvoiceInfoMapper.getInvoiceNoByInspectionId(saleOrderInfoBO.getInspectionId());
            String invoiceNo = FscStringUtils.list2String(invoiceNoList, null);
            infoRspBO.setInvoiceNo(invoiceNo);
            rows.add(infoRspBO);
        }
        rspBO.setRows(rows);
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(page.getPageNo());
        return rspBO;
    }
}

