/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.BusiHangPayPurchaseOrderInfoService;
import com.tydic.fsc.settle.busi.api.bo.ProcessCancelHangReqBO;
import com.tydic.fsc.settle.busi.api.bo.ProcessHangReqBO;
import com.tydic.fsc.settle.dao.PayPurchaseOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.PayPurchaseOrderInfo;
import com.tydic.fsc.settle.enums.OrderStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiHangPayPurchaseOrderInfoServiceImpl
implements BusiHangPayPurchaseOrderInfoService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusiHangPayPurchaseOrderInfoServiceImpl.class);
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;

    @Autowired
    private BusiHangPayPurchaseOrderInfoServiceImpl(PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper) {
        this.payPurchaseOrderInfoMapper = payPurchaseOrderInfoMapper;
    }

    public FscBaseRspBo processHang(ProcessHangReqBO reqBO) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u6302\u8d77\u91c7\u8d2d\u8ba2\u5355\u670d\u52a1(\u7535\u5b50\u8d85\u5e02)\u5165\u53c2\uff1a" + reqBO);
        }
        Long inspectionId = reqBO.getInspectionId();
        String remark = reqBO.getRemark();
        if (null == inspectionId) {
            throw new BusinessException("1001", "\u5165\u53c2\u9a8c\u6536\u5355\u53f7\u3010inspectionId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PayPurchaseOrderInfo orderInfo = new PayPurchaseOrderInfo();
        orderInfo.setInspectionId(inspectionId);
        PayPurchaseOrderInfo purchaseOrderInfo = this.payPurchaseOrderInfoMapper.getModelBy(orderInfo);
        if (null == purchaseOrderInfo) {
            throw new BusinessException("1002", "\u8ba2\u5355\u672a\u627e\u5230");
        }
        if (!OrderStatus.NO_APPLY.getCode().equals(purchaseOrderInfo.getOrderStatus())) {
            throw new BusinessException("1002", "\u672a\u63d0\u4ea4\u7684\u8ba2\u5355\u624d\u80fd\u6302\u8d77");
        }
        orderInfo = new PayPurchaseOrderInfo();
        orderInfo.setInspectionId(inspectionId);
        orderInfo.setOrderStatus(OrderStatus.HANGING.getCode());
        orderInfo.setRemark(remark);
        int count = this.payPurchaseOrderInfoMapper.updateBy(orderInfo);
        if (count > 0) {
            FscBaseRspBo rspBo = new FscBaseRspBo();
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6302\u8d77\u8ba2\u5355\u6210\u529f");
            return rspBo;
        }
        throw new BusinessException("1002", "\u66f4\u65b0\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
    }

    public FscBaseRspBo processCancelHang(ProcessCancelHangReqBO reqBO) {
        Long inspectionId;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u53d6\u6d88\u6302\u8d77\u91c7\u8d2d\u8ba2\u5355\u670d\u52a1(\u7535\u5b50\u8d85\u5e02)\u5165\u53c2\uff1a" + reqBO);
        }
        if (null == (inspectionId = reqBO.getInspectionId())) {
            throw new BusinessException("1001", "\u5165\u53c2\u9a8c\u6536\u5355\u53f7\u3010inspectionId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PayPurchaseOrderInfo orderInfo = new PayPurchaseOrderInfo();
        orderInfo.setInspectionId(inspectionId);
        PayPurchaseOrderInfo purchaseOrderInfo = this.payPurchaseOrderInfoMapper.getModelBy(orderInfo);
        if (null == purchaseOrderInfo) {
            throw new BusinessException("1002", "\u8ba2\u5355\u672a\u627e\u5230");
        }
        if (!OrderStatus.HANGING.getCode().equals(purchaseOrderInfo.getOrderStatus())) {
            throw new BusinessException("1002", "\u4e0d\u662f\u6302\u8d77\u72b6\u6001\uff0c\u4e0d\u80fd\u53d6\u6d88\u6302\u8d77");
        }
        orderInfo = new PayPurchaseOrderInfo();
        orderInfo.setInspectionId(inspectionId);
        orderInfo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
        orderInfo.setRemark("");
        int count = this.payPurchaseOrderInfoMapper.updateBy(orderInfo);
        if (count > 0) {
            FscBaseRspBo rspBo = new FscBaseRspBo();
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u53d6\u6d88\u6302\u8d77\u8ba2\u5355\u6210\u529f");
            return rspBo;
        }
        throw new BusinessException("1002", "\u66f4\u65b0\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
    }
}

