/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.busi.api.BusiQryPayStatusService;
import com.tydic.fsc.settle.busi.api.bo.BusiQryPayStatusReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQryPayStatusRspBO;
import com.tydic.fsc.settle.busi.api.vo.TranDetailVo;
import com.tydic.fsc.settle.dao.TranDetailMapper;
import com.tydic.fsc.settle.dao.po.TranDetail;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiQryPayStatusServiceImpl
implements BusiQryPayStatusService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQryPayStatusServiceImpl.class);
    @Autowired
    private TranDetailMapper tranDetailMapper;

    public BusiQryPayStatusRspBO busiQryAcctStat(BusiQryPayStatusReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u4ed8\u6b3e\u72b6\u6001\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        BusiQryPayStatusRspBO result = new BusiQryPayStatusRspBO();
        if (null == reqBO.getOrderNo()) {
            throw new BusinessException("1001", "\u4ed8\u6b3e\u72b6\u6001\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1-\u8ba2\u5355\u7f16\u53f7[orderNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<Object> tranDetails = new LinkedList();
        try {
            tranDetails = this.tranDetailMapper.selectByBusiTypeAndServiceNo("21", reqBO.getOrderNo());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6570\u636e\u5e93\u64cd\u4f5c\u9519\u8bef", (Object)e.getMessage(), (Object)e);
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u4ed8\u6b3e\u72b6\u6001\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1-\u6570\u636e\u5e93\u5f02\u5e38\uff0c\u4ea4\u6613\u6d41\u6c34\u8868\u67e5\u8be2\u51fa\u9519", (Throwable)e);
        }
        if (!tranDetails.isEmpty() && ((TranDetail)((Object)tranDetails.get(0))).getTxnNo() != null) {
            result.setStatus("Y");
        } else {
            result.setStatus("N");
        }
        return result;
    }

    public List<TranDetailVo> selectByBusiTypeAndServiceNo(String businessType, String serviceNo) {
        List<TranDetail> tranDetails = this.tranDetailMapper.selectByBusiTypeAndServiceNo(businessType, serviceNo);
        ArrayList<TranDetailVo> tranDetailVoList = new ArrayList<TranDetailVo>();
        for (TranDetail tranDetail : tranDetails) {
            TranDetailVo vo = new TranDetailVo();
            BeanUtils.copyProperties((Object)vo, (Object)((Object)tranDetail));
            tranDetailVoList.add(vo);
        }
        return tranDetailVoList;
    }
}

