/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.bo.FscPageRspBo;
import com.tydic.fsc.settle.busi.api.BusiQueryOutInvoiceService;
import com.tydic.fsc.settle.busi.api.bo.OutInvoiceInfoRepBO;
import com.tydic.fsc.settle.busi.api.bo.OutInvoiceInfoRspBO;
import com.tydic.fsc.settle.busi.impl.QueryEntryInfoServiceImpl;
import com.tydic.fsc.settle.dao.SaleInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.po.OutInvoicePO;
import com.tydic.fsc.settle.enums.InvoiceType;
import com.tydic.fsc.settle.utils.AntiSqlInjectionManage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BusiQueryOutInvoiceServiceImpl
implements BusiQueryOutInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(QueryEntryInfoServiceImpl.class);
    private final SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    private final OrganizationInfoService organizationInfoService;
    private final EnumsService enumsService;

    public BusiQueryOutInvoiceServiceImpl(SaleInvoiceInfoMapper saleInvoiceInfoMapper, OrganizationInfoService organizationInfoService, EnumsService enumsService) {
        this.saleInvoiceInfoMapper = saleInvoiceInfoMapper;
        this.organizationInfoService = organizationInfoService;
        this.enumsService = enumsService;
    }

    public FscPageRspBo<OutInvoiceInfoRspBO> queryPageOutInvoice(OutInvoiceInfoRepBO reqBO) {
        List<OutInvoicePO> outInvoiceList;
        if (!StringUtils.hasText((String)reqBO.getTotalNo())) {
            throw new BusinessException("1001", "\u6c47\u603b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String orderBy = null;
        if (!StringUtils.isEmpty((Object)reqBO.getSortName()) && !StringUtils.isEmpty((Object)reqBO.getSortOrder())) {
            if (AntiSqlInjectionManage.sqlValidate(reqBO.getSortName()) || AntiSqlInjectionManage.sqlValidate(reqBO.getSortOrder())) {
                throw new BusinessException("8888", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
            }
            orderBy = reqBO.getSortName() + " " + reqBO.getSortOrder();
        }
        if (!StringUtils.hasText(orderBy)) {
            orderBy = " t2.APPLY_NO asc,t2.INVOICE_NO asc";
        }
        FscPageRspBo rspPageBO = new FscPageRspBo();
        rspPageBO.setRespCode("0000");
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        if (!StringUtils.hasText((String)reqBO.getApplyNo())) {
            List<OutInvoicePO> outInvoiceList2;
            try {
                outInvoiceList2 = this.saleInvoiceInfoMapper.selectListByTotalNo(reqBO.getTotalNo(), (Page<Map<String, Object>>)page, orderBy);
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u51fa\u5e93\u5355\u53d1\u7968\u5931\u8d25\uff0c\u6c47\u603b\u7f16\u53f7\u4e3a\uff1a" + reqBO.getTotalNo(), (Throwable)e);
                throw new BusinessException("8888", "\u67e5\u8be2\u51fa\u5e93\u5355\u53d1\u7968\u5931\u8d25");
            }
            if (CollectionUtils.isEmpty(outInvoiceList2)) {
                logger.error("\u627e\u4e0d\u5230\u6c47\u603b\u5355\u53f7\u5bf9\u5e94\u7684\u53d1\u7968\u8bb0\u5f55\uff0c\u6c47\u603b\u5355\u53f7\u4e3a\uff1a" + reqBO.getTotalNo());
                rspPageBO.setRespDesc("\u627e\u4e0d\u5230\u6c47\u603b\u5355\u53f7\u5bf9\u5e94\u7684\u53d1\u7968\u8bb0\u5f55");
                return rspPageBO;
            }
            this.assembleRspBO(outInvoiceList2, (Page<Map<String, Object>>)page, (FscPageRspBo<OutInvoiceInfoRspBO>)rspPageBO);
            return rspPageBO;
        }
        try {
            outInvoiceList = this.saleInvoiceInfoMapper.getListByApplyNo(reqBO.getApplyNo(), (Page<Map<String, Object>>)page, orderBy);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u51fa\u5e93\u5355\u53d1\u7968\u5931\u8d25\uff0c\u53d1\u7968\u901a\u77e5\u5355\u7f16\u53f7\u4e3a\uff1a" + reqBO.getApplyNo(), (Throwable)e);
            throw new BusinessException("8888", "\u67e5\u8be2\u51fa\u5e93\u5355\u53d1\u7968\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(outInvoiceList)) {
            logger.error("\u627e\u4e0d\u5230\u53d1\u7968\u901a\u77e5\u5355\u5bf9\u5e94\u7684\u53d1\u7968\u8bb0\u5f55\uff0c\u53d1\u7968\u901a\u77e5\u5355\u4e3a\uff1a" + reqBO.getApplyNo());
            rspPageBO.setRespDesc("\u627e\u4e0d\u5230\u53d1\u7968\u901a\u77e5\u5355\u5bf9\u5e94\u7684\u53d1\u7968\u8bb0\u5f55");
            return rspPageBO;
        }
        this.assembleRspBO(outInvoiceList, (Page<Map<String, Object>>)page, (FscPageRspBo<OutInvoiceInfoRspBO>)rspPageBO);
        return rspPageBO;
    }

    private void assembleRspBO(List<OutInvoicePO> outInvoiceList, Page<Map<String, Object>> page, FscPageRspBo<OutInvoiceInfoRspBO> rspPageBO) {
        ArrayList<OutInvoiceInfoRspBO> outInvoiceInfoRspBO = new ArrayList<OutInvoiceInfoRspBO>();
        for (OutInvoicePO outInvoice : outInvoiceList) {
            OutInvoiceInfoRspBO outInvoiceInfoBO = new OutInvoiceInfoRspBO();
            outInvoice.setSupplierName(this.organizationInfoService.querySupplierName(outInvoice.getSupplierNo()));
            outInvoice.setInvoiceTypeName(this.enumsService.getDescr(InvoiceType.getInstance(outInvoice.getInvoiceType())));
            BeanUtils.copyProperties((Object)outInvoice, (Object)outInvoiceInfoBO);
            outInvoiceInfoRspBO.add(outInvoiceInfoBO);
        }
        rspPageBO.setRespDesc("\u67e5\u8be2\u51fa\u5e93\u5355\u53d1\u7968\u6210\u529f");
        rspPageBO.setRows(outInvoiceInfoRspBO);
        rspPageBO.setRecordsTotal(page.getTotalCount());
        rspPageBO.setTotal(page.getTotalPages());
        rspPageBO.setPageNo(page.getPageNo());
    }
}

