/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.busi.api.BusiQuerySaleOrderDetailInfoService;
import com.tydic.fsc.settle.busi.api.bo.BusiSaleOrderDetailInfoReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiSaleOrderDetailInfoRspBO;
import com.tydic.fsc.settle.busi.api.bo.SaleItemInfoRspBO;
import com.tydic.fsc.settle.busi.api.bo.SaleOrderInfoRspBO;
import com.tydic.fsc.settle.dao.PayPurchaseOrderInfoMapper;
import com.tydic.fsc.settle.dao.SaleItemInfoMapper;
import com.tydic.fsc.settle.dao.SaleOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.PayPurchaseOrderInfo;
import com.tydic.fsc.settle.dao.po.SaleItemInfo;
import com.tydic.fsc.settle.dao.po.SaleOrderInfo;
import com.tydic.fsc.settle.dao.vo.SaleItemInfoVO;
import com.tydic.fsc.settle.enums.OrderStatus;
import com.tydic.fsc.supplier.bo.ProjectInfoBO;
import com.tydic.fsc.supplier.bo.TsupplierInfoRspBO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiQuerySaleOrderDetailInfoServiceImpl
implements BusiQuerySaleOrderDetailInfoService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQuerySaleOrderDetailInfoServiceImpl.class);
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;

    public BusiSaleOrderDetailInfoRspBO querySaleOrderDetailInfo(BusiSaleOrderDetailInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug(" \u67e5\u8be2\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (null == reqBO.getInspectionId()) {
            throw new BusinessException("8888", "\u9a8c\u6536\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiSaleOrderDetailInfoRspBO rspBO = new BusiSaleOrderDetailInfoRspBO();
        SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
        saleOrderInfo.setInspectionId(reqBO.getInspectionId());
        SaleOrderInfo saleOrder = this.saleOrderInfoMapper.getModelBy(saleOrderInfo);
        if (saleOrder == null) {
            logger.error("\u6839\u636e\u9a8c\u6536\u5355\u53f7\uff1a" + reqBO.getInspectionId() + "\u627e\u4e0d\u5230\u9500\u552e\u8ba2\u5355\u3002");
            throw new BusinessException("8888", "\u6839\u636e\u9a8c\u6536\u5355\u53f7\uff1a" + reqBO.getInspectionId() + "\u627e\u4e0d\u5230\u9500\u552e\u8ba2\u5355");
        }
        SaleOrderInfoRspBO saleOrderInfoRspBO = new SaleOrderInfoRspBO();
        BeanUtils.copyProperties((Object)saleOrder, (Object)saleOrderInfoRspBO);
        saleOrderInfoRspBO.setOrderStatusDescr(this.enumsService.getDescr(OrderStatus.getInstance(saleOrder.getOrderStatus())));
        PayPurchaseOrderInfo purchaseOrder = new PayPurchaseOrderInfo();
        purchaseOrder.setInspectionId(saleOrder.getInspectionId());
        purchaseOrder = this.payPurchaseOrderInfoMapper.getModelBy(purchaseOrder);
        if (purchaseOrder == null) {
            throw new BusinessException("RSP_CODE_DATA_NULL", "\u6839\u636e\u9a8c\u6536\u5355\u53f7\uff1a" + saleOrder.getInspectionId() + "\u627e\u4e0d\u5230\u91c7\u8d2d\u8ba2\u5355");
        }
        saleOrderInfoRspBO.setExtOrderId(purchaseOrder.getExtOrderId());
        String serviceName = "";
        try {
            TsupplierInfoRspBO supplier;
            serviceName = "UmcQryEnterpriseAccountDetailAbilityService";
            ProjectInfoBO projectInfoBO = this.organizationInfoService.queryProjectName(saleOrder.getPurchaseProjectId());
            if (projectInfoBO != null) {
                saleOrderInfoRspBO.setPurchaseProjectName(projectInfoBO.getPurchaseOrgName());
            }
            serviceName = "UmcQrySupplierInfoListAbilityService";
            ArrayList<Long> supIds = new ArrayList<Long>();
            supIds.add(saleOrder.getSupplierNo());
            Map<Long, TsupplierInfoRspBO> suppliers = this.organizationInfoService.querySupplies(supIds);
            if (suppliers != null && (supplier = suppliers.get(saleOrder.getSupplierNo())) != null) {
                saleOrderInfoRspBO.setLinkMan(supplier.getLinkMan());
                saleOrderInfoRspBO.setTel(supplier.getTel());
                saleOrderInfoRspBO.setPhoneNumber(supplier.getPhoneNumber());
                saleOrderInfoRspBO.setAddrDesc(supplier.getAddrDesc());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new BusinessException("8888", "\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u63a5\u53e3" + serviceName + "\u5f02\u5e38");
        }
        rspBO.setSaleOrderInfo(saleOrderInfoRspBO);
        SaleItemInfoVO vo = new SaleItemInfoVO();
        vo.setInspectionId(reqBO.getInspectionId());
        List<SaleItemInfo> saleItemInfoList = this.saleItemInfoMapper.getList(vo);
        ArrayList<SaleItemInfoRspBO> itemList = new ArrayList<SaleItemInfoRspBO>();
        for (SaleItemInfo saleItemInfo : saleItemInfoList) {
            SaleItemInfoRspBO saleItemInfoRspBO = new SaleItemInfoRspBO();
            BeanUtils.copyProperties((Object)saleItemInfo, (Object)saleItemInfoRspBO);
            itemList.add(saleItemInfoRspBO);
        }
        rspBO.setSaleItemList(itemList);
        return rspBO;
    }
}

