/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.busi.api.BusiReconcilitionService;
import com.tydic.fsc.settle.busi.api.bo.BusiReconcilitionRepBO;
import com.tydic.fsc.settle.busi.api.bo.BusiReconcilitionRspBO;
import com.tydic.fsc.settle.busi.impl.QueryEntryInfoServiceImpl;
import com.tydic.fsc.settle.dao.PayPurchaseOrderInfoMapper;
import com.tydic.fsc.settle.dao.ReconcilitionHisMapper;
import com.tydic.fsc.settle.dao.po.ReconcilitionHis;
import com.tydic.fsc.settle.enums.OrderStatus;
import com.tydic.fsc.settle.enums.ReconciliationStatus;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BusiReconcilitionServiceImpl
implements BusiReconcilitionService {
    private static final Logger logger = LoggerFactory.getLogger(QueryEntryInfoServiceImpl.class);
    @Autowired
    private ReconcilitionHisMapper reconcilitionHisMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;

    public BusiReconcilitionRspBO registerReconcilition(BusiReconcilitionRepBO reqBO) {
        List<Long> orderId;
        List<ReconcilitionHis> reconcilitionHis;
        if (logger.isDebugEnabled()) {
            logger.debug("\u7ed3\u7b97\u5bf9\u8d26\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a" + reqBO.getVersionNo());
        }
        BusiReconcilitionRspBO rspBO = new BusiReconcilitionRspBO();
        if (!StringUtils.hasText((String)reqBO.getVersionNo())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u65e0\u5bf9\u8d26\u6570\u636e\u4e0d\u80fd\u5bf9\u8d26\uff0c\u8bf7\u5bfc\u5165\u5bf9\u8d26\u6570\u636e");
            return rspBO;
        }
        try {
            reconcilitionHis = this.reconcilitionHisMapper.selectByVersionNo(Integer.valueOf(reqBO.getVersionNo()));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
            throw new BusinessException("1002", "\u67e5\u8be2\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(reconcilitionHis)) {
            List<Long> orderId2;
            try {
                this.reconcilitionHisMapper.insertAccountAgreement(Integer.valueOf(reqBO.getVersionNo()), OrderStatus.AFTER_SALE.getCode(), ReconciliationStatus.AGREEMENT.getCode());
            }
            catch (Exception e) {
                logger.error("\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
                throw new BusinessException("1002", "\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25");
            }
            try {
                orderId2 = this.payPurchaseOrderInfoMapper.selectByrstatus(Integer.valueOf(reqBO.getVersionNo()), ReconciliationStatus.AGREEMENT.getCode());
                if (!CollectionUtils.isEmpty(orderId2)) {
                    this.payPurchaseOrderInfoMapper.updateReconciliation(orderId2, ReconciliationStatus.AGREEMENT.getCode());
                }
            }
            catch (Exception e) {
                logger.error("\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
                throw new BusinessException("1002", "\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u66f4\u65b0\u72b6\u6001\u5931\u8d25");
            }
            try {
                this.reconcilitionHisMapper.insertAccountDisagreement(Integer.valueOf(reqBO.getVersionNo()), OrderStatus.AFTER_SALE.getCode(), ReconciliationStatus.DISAGREEMENT.getCode());
            }
            catch (Exception e) {
                logger.error("\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
                throw new BusinessException("1002", "\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25");
            }
            try {
                orderId2 = this.payPurchaseOrderInfoMapper.selectByrstatus(Integer.valueOf(reqBO.getVersionNo()), ReconciliationStatus.DISAGREEMENT.getCode());
                if (!CollectionUtils.isEmpty(orderId2)) {
                    this.payPurchaseOrderInfoMapper.updateReconciliation(orderId2, ReconciliationStatus.DISAGREEMENT.getCode());
                }
            }
            catch (Exception e) {
                logger.error("\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
                throw new BusinessException("1002", "\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u66f4\u65b0\u72b6\u6001\u5931\u8d25");
            }
            try {
                this.reconcilitionHisMapper.insertAftersale(Integer.valueOf(reqBO.getVersionNo()), OrderStatus.AFTER_SALE.getCode(), ReconciliationStatus.AFTER_SALE.getCode());
            }
            catch (Exception e) {
                logger.error("e\u8d2d\u552e\u540e\u4e2d\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
                throw new BusinessException("1002", "e\u8d2d\u552e\u540e\u4e2d\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25");
            }
        }
        try {
            this.reconcilitionHisMapper.updateAccountAgreement(Integer.valueOf(reqBO.getVersionNo()), OrderStatus.AFTER_SALE.getCode(), ReconciliationStatus.AGREEMENT.getCode());
        }
        catch (Exception e) {
            logger.error("\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
            throw new BusinessException("1002", "\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u66f4\u65b0\u5931\u8d25");
        }
        try {
            orderId = this.payPurchaseOrderInfoMapper.selectByrstatus(Integer.valueOf(reqBO.getVersionNo()), ReconciliationStatus.AGREEMENT.getCode());
            if (!CollectionUtils.isEmpty(orderId)) {
                this.payPurchaseOrderInfoMapper.updateReconciliation(orderId, ReconciliationStatus.AGREEMENT.getCode());
            }
        }
        catch (Exception e) {
            logger.error("\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
            throw new BusinessException("1002", "\u66f4\u65b0\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u66f4\u65b0\u72b6\u6001\u5931\u8d25");
        }
        try {
            this.reconcilitionHisMapper.updateAccountDisagreement(Integer.valueOf(reqBO.getVersionNo()), OrderStatus.AFTER_SALE.getCode(), ReconciliationStatus.DISAGREEMENT.getCode());
        }
        catch (Exception e) {
            logger.error("\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
            throw new BusinessException("1002", "\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u66f4\u65b0\u5931\u8d25");
        }
        try {
            orderId = this.payPurchaseOrderInfoMapper.selectByrstatus(Integer.valueOf(reqBO.getVersionNo()), ReconciliationStatus.DISAGREEMENT.getCode());
            if (!CollectionUtils.isEmpty(orderId)) {
                this.payPurchaseOrderInfoMapper.updateReconciliation(orderId, ReconciliationStatus.DISAGREEMENT.getCode());
            }
        }
        catch (Exception e) {
            logger.error("\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
            throw new BusinessException("1002", "\u66f4\u65b0\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u66f4\u65b0\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setBatchNo(Integer.valueOf(reqBO.getVersionNo()));
        return rspBO;
    }
}

