/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.JdExpressTokenService;
import com.tydic.fsc.settle.atom.TransactionService;
import com.tydic.fsc.settle.busi.api.BusiPushPayPurchaseOrderInfoService;
import com.tydic.fsc.settle.busi.api.BusiTestDataCreateService;
import com.tydic.fsc.settle.busi.api.bo.BusiPushPayPurchaseOrderInfoItemReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiPushPayPurchaseOrderInfoOrderReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiPushPayPurchaseOrderInfoReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiTestDataCreateReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiTestDataCreateRspBO;
import com.tydic.fsc.settle.dao.BillNotificationInfoMapper;
import com.tydic.fsc.settle.dao.PayInvoiceDetailMapper;
import com.tydic.fsc.settle.dao.PayInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.PayItemInfoMapper;
import com.tydic.fsc.settle.dao.po.BillNotificationInfo;
import com.tydic.fsc.settle.dao.po.JdexpressToken;
import com.tydic.fsc.settle.dao.po.PayInvoiceDetail;
import com.tydic.fsc.settle.dao.po.PayInvoiceInfo;
import com.tydic.fsc.settle.dao.po.PayItemInfo;
import com.tydic.fsc.settle.dao.vo.Statis;
import com.tydic.fsc.settle.enums.InvoiceMailStatus;
import com.tydic.fsc.settle.enums.NotificationInvoiceStatus;
import com.tydic.fsc.supplier.BusiJdExpressService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiTestDataCreateServiceImpl
implements BusiTestDataCreateService {
    private static final Logger logger = LoggerFactory.getLogger(BusiTestDataCreateService.class);
    @Autowired
    private BusiPushPayPurchaseOrderInfoService busiPushPayPurchaseOrderInfoService;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private PayInvoiceDetailMapper payInvoiceDetailMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private BusiJdExpressService busiJdExpressService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private JdExpressTokenService jdExpressTokenService;

    public BusiTestDataCreateRspBO createData(BusiTestDataCreateReqBO reqBo) {
        String dataType = reqBo.getDataType();
        BusiTestDataCreateRspBO resp = new BusiTestDataCreateRspBO();
        if (!StringUtils.hasText((String)dataType)) {
            return resp;
        }
        if ("ORDER".equals(dataType = dataType.toUpperCase())) {
            this.createOrder(reqBo);
        } else if ("INVOICE".equals(dataType)) {
            this.createInvoice(reqBo);
        } else if ("LINKCOREBUSI".equals(dataType)) {
            int okcnt = this.transactionService.linkBusiAndCoreSsn(reqBo.getParam1(), reqBo.getParam2());
            resp.setReturnMsg("Update " + okcnt);
        } else if ("JDEXPRESSTOKEN".equals(dataType)) {
            JdexpressToken token = new JdexpressToken();
            token.setOperUnitNo(Long.valueOf(reqBo.getParam1()));
            token.setToken(reqBo.getParam2());
            token.setCustCode(reqBo.getParam3());
            token.setWarehouseCode(reqBo.getParam4());
            resp.setReturnMsg("Update OK:" + this.jdExpressTokenService.updateToken(token));
        } else {
            resp.setReturnMsg("dataType,param1,param2,param3");
        }
        return resp;
    }

    private Date getYestoday(Date date, int dayCntBefore) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(5, dayCntBefore);
        return cal.getTime();
    }

    private void createOrder(BusiTestDataCreateReqBO reqBo) {
        String purchaseNo;
        int cnt;
        String p1 = reqBo.getParam1();
        if (p1 == null) {
            p1 = "1";
        }
        if ((cnt = Integer.valueOf(p1).intValue()) > 4) {
            cnt = 4;
        }
        if ((purchaseNo = reqBo.getParam2()) == null) {
            purchaseNo = "198611010842";
        }
        long id = System.currentTimeMillis() * 10L;
        BusiPushPayPurchaseOrderInfoReqBO order = new BusiPushPayPurchaseOrderInfoReqBO();
        order.setItemList(new ArrayList());
        order.setOrderInfo(new BusiPushPayPurchaseOrderInfoOrderReqBO());
        order.getOrderInfo().setParentOrderId(Long.valueOf(9999999L));
        order.getOrderInfo().setOrderId(Long.valueOf(id));
        order.getOrderInfo().setInspectionId(Long.valueOf(id));
        order.getOrderInfo().setPurchaseName("\u6d4b\u8bd5\u6570\u636e\u670d\u52a1\u9020");
        order.getOrderInfo().setOrderDate(this.getYestoday(new Date(), -1));
        order.getOrderInfo().setRecvDate(this.getYestoday(new Date(), -10));
        order.getOrderInfo().setSupplierNo(Long.valueOf(1L));
        order.getOrderInfo().setSupplierName("\u4eac\u4e1c");
        order.getOrderInfo().setOrderAmt(new BigDecimal("1200"));
        order.getOrderInfo().setPurchaseNo(Long.valueOf(purchaseNo));
        order.getOrderInfo().setOperUnitNo(Long.valueOf(198611010879L));
        order.getOrderInfo().setSource("2");
        order.getOrderInfo().setPurchaseProjectId(Long.valueOf(id));
        String[] infs = new String[20];
        infs[0] = "13830384702;\u6865\u9632 \u9632\u7206\u6c7d\u8f66\u6273\u624b\uff0c\u94dd\u9752\u94dc\uff0c62mm\uff0c127A-62-AL;200;170.94;29.06;200;\u628a";
        infs[1] = "2010293938483;\u65e0\u82af\u5377\u7eb8\u8d85\u97e73\u5c42140g\u536b\u751f\u7eb8*12\u5377;60;51.28;8.72;60;\u7bb1";
        infs[2] = "13830268954;\u65b0\u826f\u7119\u98df\u5c1a\u66f2\u5947\u997c\u5e72\u7c89 \u4f4e\u7b4b\u9762\u7c89 \u66f2\u5947\u997c\u5e72\u7c89 \u84dd\u7f50500g;900;769.23;130.77;900;\u76d2";
        infs[3] = "13830193700;\u5b9c\u5ba2\u83b1(ECOLA)  \u591a\u5408\u4e00\u9ad8\u901fUSB\u8bfb\u5361\u5668 64GB \u53ef\u76f4\u8bfb\u624b\u673a\u5361CRD-016WT(\u767d\u8272);80;68.38;11.62;80;\u4e2a";
        BigDecimal sumAmt = BigDecimal.ZERO;
        for (int i = 0; i < cnt; ++i) {
            BusiPushPayPurchaseOrderInfoItemReqBO item = new BusiPushPayPurchaseOrderInfoItemReqBO();
            String[] inf = infs[i].split(";");
            BigDecimal saleAmt = new BigDecimal(inf[2]);
            BigDecimal untaxAmt = new BigDecimal(inf[3]);
            BigDecimal taxAmt = new BigDecimal(inf[4]);
            BigDecimal amt = new BigDecimal(inf[5]);
            sumAmt = sumAmt.add(amt);
            item.setItemNo(Long.valueOf(i + 1));
            item.setSkuId(Long.valueOf(inf[0]));
            item.setItemName(inf[1]);
            item.setPurchaseUnitPrice(new BigDecimal("0"));
            item.setQuantity(new BigDecimal("1"));
            item.setTaxRate(new BigDecimal("0.17"));
            item.setSaleUnitPrice(saleAmt);
            item.setPurchaseUnitPrice(saleAmt);
            item.setUntaxAmt(untaxAmt);
            item.setTaxAmt(taxAmt);
            item.setUnitName(inf[6]);
            item.setAmount(amt);
            order.getItemList().add(item);
        }
        order.getOrderInfo().setOrderAmt(sumAmt);
        this.busiPushPayPurchaseOrderInfoService.add(order);
        logger.info("--------------------\u6210\u529f\u4ea7\u751f\u8ba2\u5355\u6570\u636e-----------,\u8ba2\u5355\u53f7=" + id);
    }

    private void createInvoice(BusiTestDataCreateReqBO reqBo) {
        String notificationNo = reqBo.getParam1();
        String invoiceNo = reqBo.getParam2();
        String hasDetail = reqBo.getParam3();
        if (!StringUtils.hasText((String)notificationNo)) {
            throw new BusinessException("1001", "\u901a\u77e5\u5355\u53f7notificationNo\u5fc5\u987b\u8f93\u5165");
        }
        BillNotificationInfo bill = this.billNotificationInfoMapper.selectByPrimaryKey(notificationNo);
        if (bill == null) {
            throw new BusinessException("1001", "\u901a\u77e5\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        NotificationInvoiceStatus sta = NotificationInvoiceStatus.getInstance(bill.getInvoiceStatus());
        if (NotificationInvoiceStatus.SUBMITED != sta) {
            throw new BusinessException("1001", "\u6b64\u901a\u77e5\u5355\u53f7\u7684\u72b6\u6001\u4e0d\u662f\u5df2\u63d0\u4ea4");
        }
        Statis ordStatis = this.payItemInfoMapper.orderStatis(notificationNo);
        PayInvoiceInfo invoice = new PayInvoiceInfo();
        BeanUtils.copyProperties((Object)bill, (Object)invoice);
        invoice.setName(bill.getInvoceName());
        invoice.setInvoiceNo(invoiceNo);
        invoice.setInvoiceCode(invoiceNo);
        invoice.setInvoiceType(bill.getInvoceType());
        invoice.setInvoiceDate(new Date());
        invoice.setAddress(bill.getAddr());
        invoice.setBankAcNo(bill.getBankAccNo());
        invoice.setNotTaxAmt(ordStatis.getTotUntaxAmt());
        invoice.setTaxAmt(ordStatis.getTotTaxAmt());
        invoice.setMailStatus(InvoiceMailStatus.NOT_SIGNED.getCode());
        if ("Y".equals(hasDetail)) {
            List<PayItemInfo> sampItems = this.payItemInfoMapper.selectByNotifNo(notificationNo);
            ArrayList<PayInvoiceDetail> ivDetails = new ArrayList<PayInvoiceDetail>();
            for (int i = 0; i < sampItems.size(); ++i) {
                PayItemInfo samp = sampItems.get(i);
                PayInvoiceDetail detail = new PayInvoiceDetail();
                BeanUtils.copyProperties((Object)samp, (Object)detail);
                detail.setInvoiceCode(invoice.getInvoiceCode());
                detail.setInvoiceNo(invoice.getInvoiceCode());
                detail.setInvoiceDate(invoice.getInvoiceDate());
                detail.setPriceIntax(samp.getPurchaseUnitPrice());
                detail.setSpecOrModel(samp.getSpec());
                detail.setItemUnit(samp.getUnitName());
                ivDetails.add(detail);
            }
            this.payInvoiceDetailMapper.insertByBatch(ivDetails);
        }
        this.payInvoiceInfoMapper.insert(invoice);
        BillNotificationInfo forUpdate = new BillNotificationInfo();
        forUpdate.setNotificationNo(bill.getNotificationNo());
        forUpdate.setInvoiceStatus(NotificationInvoiceStatus.HAS_MAKE.getCode());
        this.billNotificationInfoMapper.updateByPrimaryKeySelective(forUpdate);
    }
}

