/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.busi.api.InvoiceReturnApplyService;
import com.tydic.fsc.settle.busi.api.bo.InvoiceReturnApplyReqBO;
import com.tydic.fsc.settle.busi.api.bo.InvoiceReturnApplyRspBO;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.InvoiceReturnDetailMapper;
import com.tydic.fsc.settle.dao.InvoiceReturnMapper;
import com.tydic.fsc.settle.dao.SaleInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.po.InvoiceReturn;
import com.tydic.fsc.settle.dao.po.InvoiceReturnDetail;
import com.tydic.fsc.settle.dao.po.SaleInvoiceInfo;
import com.tydic.fsc.settle.dao.vo.InvoiceReturnDetailVO;
import com.tydic.fsc.settle.dao.vo.SaleInvoiceInfoVO;
import com.tydic.fsc.settle.enums.InvoiceReturnStatus;
import com.tydic.fsc.settle.utils.FscStringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class InvoiceReturnApplyServiceImpl
implements InvoiceReturnApplyService {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceReturnApplyServiceImpl.class);
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;

    public InvoiceReturnApplyRspBO process(InvoiceReturnApplyReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u9000\u7968\u7533\u8bf7\u670d\u52a1\uff08\u5e73\u53f0\u4f7f\u7528\u8d39\u9000\u7968\uff09\u5165\u53c2\uff1a" + reqBO);
        }
        String billNo = reqBO.getBillNo();
        String type = reqBO.getType();
        String remark = reqBO.getRemark();
        String mailCompany = reqBO.getMailCompany();
        String mailTicketNo = reqBO.getMailTicketNo();
        String createUser = reqBO.getCreateUser();
        String createPhone = reqBO.getCreatePhone();
        String createOrg = reqBO.getCreateOrg();
        List invoiceNos = reqBO.getInvoiceNos();
        if (!StringUtils.hasText((String)billNo)) {
            throw new BusinessException("1001", "\u9000\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)type)) {
            throw new BusinessException("1001", "\u9000\u7968\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)createUser)) {
            throw new BusinessException("1001", "\u7533\u8bf7\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)createPhone)) {
            throw new BusinessException("1001", "\u7533\u8bf7\u4eba\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)createOrg)) {
            throw new BusinessException("1001", "\u7533\u8bf7\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)invoiceNos)) {
            throw new BusinessException("1001", "\u8bf7\u52fe\u9009");
        }
        InvoiceReturn invoiceReturn = this.invoiceReturnMapper.selectByPrimaryKey(billNo);
        List<String> applyNo1s = FscStringUtils.string2List(invoiceReturn.getApplyNo1(), ",");
        BillApplyInfo billApplyInfo1 = this.billApplyInfoMapper.selectByPrimaryKey(applyNo1s.get(0));
        SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
        saleInvoiceInfoVO.setInvoiceNoList(invoiceNos);
        List<SaleInvoiceInfo> saleInvoiceInfos = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
        if (saleInvoiceInfos.size() < invoiceNos.size()) {
            throw new BusinessException("1001", "\u52fe\u9009\u7684\u53d1\u7968\u4e0d\u5b58\u5728");
        }
        InvoiceReturnDetailVO vo = new InvoiceReturnDetailVO();
        vo.setInvoiceNo1s(invoiceNos);
        vo.setStatusNotIn(Arrays.asList(InvoiceReturnStatus.REJECTED.getCode(), InvoiceReturnStatus.CANCELED.getCode()));
        List<InvoiceReturnDetail> invoiceReturnDetails = this.invoiceReturnDetailMapper.selectListJoin(vo);
        Iterator<Object> iterator = invoiceReturnDetails.iterator();
        if (iterator.hasNext()) {
            InvoiceReturnDetail invoiceReturnDetail = iterator.next();
            throw new BusinessException("1001", "\u53d1\u7968\u53f7\u7801" + invoiceReturnDetail.getInvoiceNo1() + "\u5df2\u7ecf\u7533\u8bf7\u9000\u7968\uff0c\u4e0d\u80fd\u91cd\u590d\u7533\u8bf7\u9000\u7968");
        }
        invoiceReturn = new InvoiceReturn();
        invoiceReturn.setBillNo(billNo);
        invoiceReturn.setType(type);
        invoiceReturn.setRemark(remark);
        invoiceReturn.setStatus(InvoiceReturnStatus.TO_APPROVE.getCode());
        invoiceReturn.setSupplierNo(billApplyInfo1.getSupplierNo());
        invoiceReturn.setOperUnitNo(billApplyInfo1.getOperUnitNo());
        invoiceReturn.setMailCompany(mailCompany);
        invoiceReturn.setMailTicketNo(mailTicketNo);
        invoiceReturn.setCreateUser(createUser);
        invoiceReturn.setCreatePhone(createPhone);
        invoiceReturn.setCreateOrg(createOrg);
        invoiceReturn.setCreateDate(new Date());
        this.invoiceReturnMapper.updateByPrimaryKeySelective(invoiceReturn);
        for (SaleInvoiceInfo saleInvoiceInfo : saleInvoiceInfos) {
            InvoiceReturnDetail invoiceReturnDetail = new InvoiceReturnDetail();
            invoiceReturnDetail.setBillNo(billNo);
            invoiceReturnDetail.setApplyNo1(saleInvoiceInfo.getApplyNo());
            invoiceReturnDetail.setInvoiceNo1(saleInvoiceInfo.getInvoiceNo());
            this.invoiceReturnDetailMapper.insert(invoiceReturnDetail);
        }
        InvoiceReturnApplyRspBO rspBO = new InvoiceReturnApplyRspBO();
        rspBO.setMsg(null);
        return rspBO;
    }
}

