/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.InvoiceReturnCheckService;
import com.tydic.fsc.settle.busi.api.bo.InvoiceReturnCheckReqBO;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.vo.BillApplyInfoVO;
import com.tydic.fsc.settle.enums.BillStatus;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InvoiceReturnCheckServiceImpl
implements InvoiceReturnCheckService {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceReturnCheckServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;

    public FscBaseRspBo query(InvoiceReturnCheckReqBO reqBO) {
        List applyNos;
        if (logger.isDebugEnabled()) {
            logger.debug("\u9000\u7968\u6821\u9a8c\u670d\u52a1\uff08\u5e73\u53f0\u4f7f\u7528\u8d39\u9000\u7968\uff09\u5165\u53c2\uff1a" + reqBO);
        }
        if (CollectionUtils.isEmpty((Collection)(applyNos = reqBO.getApplyNos()))) {
            throw new BusinessException("1001", "\u8bf7\u52fe\u9009");
        }
        BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setApplyNoList(applyNos);
        List<BillApplyInfo> applys = this.billApplyInfoMapper.getList(billApplyInfoVO);
        Long supplierNo = null;
        Long operUnitNo = null;
        String invoiceType = null;
        String invoiceClasses = null;
        for (BillApplyInfo apply : applys) {
            if (!BillStatus.SEND_BILL.getCode().equals(apply.getBillStatus())) {
                throw new BusinessException("1001", "\u5f00\u7968\u7533\u8bf7\u5355\u7684\u72b6\u6001\u5fc5\u987b\u662f" + this.enumsService.getDescr(BillStatus.SEND_BILL));
            }
            if (supplierNo == null) {
                supplierNo = apply.getSupplierNo();
            } else if (!supplierNo.equals(apply.getSupplierNo())) {
                throw new BusinessException("1001", "\u4e0d\u540c\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e00\u8d77\u7533\u8bf7\u9000\u7968");
            }
            if (operUnitNo == null) {
                operUnitNo = apply.getOperUnitNo();
            } else if (!operUnitNo.equals(apply.getOperUnitNo())) {
                throw new BusinessException("1001", "\u4e0d\u540c\u4e13\u4e1a\u516c\u53f8\u4e0d\u80fd\u4e00\u8d77\u7533\u8bf7\u9000\u7968");
            }
            if (invoiceType == null) {
                invoiceType = apply.getInvoiceType();
            } else if (!invoiceType.equals(apply.getInvoiceType())) {
                throw new BusinessException("1001", "\u4e13\u7968\u548c\u666e\u7968\u4e0d\u80fd\u4e00\u8d77\u7533\u8bf7\u9000\u7968");
            }
            if (invoiceClasses == null) {
                invoiceClasses = apply.getInvoiceClasses();
                continue;
            }
            if (invoiceClasses.equals(apply.getInvoiceClasses())) continue;
            throw new BusinessException("1001", "\u7535\u5b50\u53d1\u7968\u548c\u7eb8\u8d28\u53d1\u7968\u4e0d\u80fd\u4e00\u8d77\u7533\u8bf7\u9000\u7968");
        }
        return new FscBaseRspBo();
    }
}

