/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.base.PayBaseService;
import com.tydic.fsc.settle.bo.FscBaseReqBo;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.PayAddTradeServiceFeeService;
import com.tydic.fsc.settle.busi.api.bo.PayAddTradeServiceFeeReqBO;
import com.tydic.fsc.settle.dao.InquiryPayOrderMapper;
import com.tydic.fsc.settle.dao.po.InquiryPayOrder;
import com.tydic.fsc.settle.enums.InquiryApprovalStatus;
import com.tydic.fsc.settle.enums.InquiryMailStatus;
import com.tydic.fsc.settle.enums.InquiryPayFeeType;
import com.tydic.fsc.settle.enums.InquiryPayFlag;
import com.tydic.fsc.settle.enums.InquiryPaymentStatus;
import com.tydic.fsc.settle.enums.OrderStatus;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayAddTradeServiceFeeServiceImpl
extends PayBaseService<FscBaseRspBo>
implements PayAddTradeServiceFeeService {
    private static final Logger logger = LoggerFactory.getLogger(PayAddTradeServiceFeeServiceImpl.class);
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;

    public FscBaseRspBo addTradeServiceFee(PayAddTradeServiceFeeReqBO reqBO) {
        FscBaseRspBo rspBO = (FscBaseRspBo)this.queryRspOrSaveLog((FscBaseReqBo)reqBO);
        if (rspBO != null) {
            return rspBO;
        }
        try {
            rspBO = this.addTradeServiceFee2(reqBO);
        }
        catch (Exception e) {
            logger.error("\u5931\u8d25", (Throwable)e);
            this.updateLog((FscBaseReqBo)reqBO, e);
            throw new BusinessException("1002", e.getMessage());
        }
        this.updateLog((FscBaseReqBo)reqBO, rspBO);
        return rspBO;
    }

    public FscBaseRspBo addTradeServiceFee2(PayAddTradeServiceFeeReqBO reqBO) {
        if (null == reqBO.getPayOrderNo()) {
            logger.error("\u7f34\u8d39\u8ba2\u5355\u53f7[payOrderNo]\u4e3a\u7a7a");
            throw new BusinessException("1001", "\u7f34\u8d39\u8ba2\u5355\u53f7[payOrderNo]\u4e3a\u7a7a");
        }
        if (null == reqBO.getInquiryNo()) {
            logger.error("\u8be2\u4ef7\u5355\u53f7[inquiryNo]\u4e3a\u7a7a");
            throw new BusinessException("1001", "\u8be2\u4ef7\u5355\u53f7[inquiryNo]\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderDate()) {
            logger.error("\u8ba2\u5355\u65e5\u671f[orderDate]\u4e3a\u7a7a");
            throw new BusinessException("1001", "\u8ba2\u5355\u65e5\u671f[orderDate]\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderTotalMoney()) {
            logger.error("\u8ba2\u5355\u603b\u91d1\u989d[totalAmount]\u4e3a\u7a7a");
            throw new BusinessException("1001", "\u8ba2\u5355\u603b\u91d1\u989d[totalAmount]\u4e3a\u7a7a");
        }
        if (null == reqBO.getPayMoney()) {
            logger.error("\u7f34\u8d39\u91d1\u989d[payMoney]\u4e3a\u7a7a");
            throw new BusinessException("1001", "\u7f34\u8d39\u91d1\u989d[payMoney]\u4e3a\u7a7a");
        }
        if (null == reqBO.getPayOrderName()) {
            logger.error("\u7f34\u8d39\u8ba2\u5355\u540d\u79f0[payOrderName]\u4e3a\u7a7a");
            throw new BusinessException("1001", "\u7f34\u8d39\u8ba2\u5355\u540d\u79f0[payOrderName]\u4e3a\u7a7a");
        }
        if (null == reqBO.getCompanyType()) {
            logger.error("\u7f34\u8d39\u5355\u4f4d\u7c7b\u578b[companyType]\u4e3a\u7a7a");
            throw new BusinessException("1001", "\u7f34\u8d39\u5355\u4f4d\u7c7b\u578b[companyType]\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperUnitNo()) {
            logger.error("\u6536\u6b3e\u5355\u4f4d\u673a\u6784\u53f7[operUnitNo]\u4e3a\u7a7a");
            throw new BusinessException("1001", "\u6536\u6b3e\u5355\u4f4d\u673a\u6784\u53f7[operUnitNo]\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierId()) {
            logger.error("\u7f34\u8d39\u5355\u4f4d\u7f16\u53f7[supplierId]\u4e3a\u7a7a");
            throw new BusinessException("1001", "\u7f34\u8d39\u5355\u4f4d\u7f16\u53f7[supplierId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperator()) {
            logger.error("\u7ed3\u7b97\u5458[operator]\u4e3a\u7a7a");
            throw new BusinessException("1001", "\u7ed3\u7b97\u5458[operator]\u4e3a\u7a7a");
        }
        if (null == reqBO.getPlanUserId()) {
            logger.error("\u4e1a\u52a1\u5458[planUserId]\u4e3a\u7a7a");
            throw new BusinessException("1001", "\u4e1a\u52a1\u5458[planUserId]\u4e3a\u7a7a");
        }
        InquiryPayOrder payOrderInfo = new InquiryPayOrder();
        payOrderInfo.setInquiryNo(reqBO.getInquiryNo());
        payOrderInfo.setPayOrderNo(reqBO.getPayOrderNo());
        payOrderInfo.setOrderTime(reqBO.getOrderDate());
        payOrderInfo.setOrderTotalMoney(reqBO.getOrderTotalMoney());
        payOrderInfo.setPayOrderName(reqBO.getPayOrderName());
        payOrderInfo.setPayMoney(reqBO.getPayMoney());
        payOrderInfo.setCompanyType(reqBO.getCompanyType().getCode());
        payOrderInfo.setOperUnitNo(reqBO.getOperUnitNo());
        payOrderInfo.setSupplierId(reqBO.getSupplierId());
        payOrderInfo.setOperator(reqBO.getOperator());
        payOrderInfo.setPlanUserId(reqBO.getPlanUserId());
        if (null == reqBO.getPayFeeType()) {
            payOrderInfo.setPayFeeType(InquiryPayFeeType.TRADE_SERVICE_FEE.getCode());
        } else {
            payOrderInfo.setPayFeeType(reqBO.getPayFeeType());
        }
        if (reqBO.getPayFlag() == null) {
            payOrderInfo.setPayFlag(InquiryPayFlag.CONFIRMED.getCode());
        } else {
            payOrderInfo.setPayFlag(reqBO.getPayFlag());
        }
        payOrderInfo.setMark(reqBO.getMark());
        payOrderInfo.setPaymentStatus(InquiryPaymentStatus.NO_PAYMENT.getCode());
        payOrderInfo.setMailStatus(InquiryMailStatus.NOT_MAILING.getCode());
        payOrderInfo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
        payOrderInfo.setApprovalStatus(InquiryApprovalStatus.UNSUBMITTED.getCode());
        this.inquiryPayOrderMapper.insert(payOrderInfo);
        return new FscBaseRspBo();
    }

    @Override
    protected FscBaseRspBo fillRspBO(String respPackage) {
        FscBaseRspBo rspBO = new FscBaseRspBo();
        JSONObject jsonObject = JSONObject.fromObject((Object)respPackage);
        rspBO.setRespCode(jsonObject.containsKey((Object)"respCode") ? jsonObject.getString("respCode") : null);
        rspBO.setRespDesc(jsonObject.containsKey((Object)"respDesc") ? jsonObject.getString("respDesc") : null);
        return rspBO;
    }
}

