/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.busi.api.PayTradeServiceFeeRecordListService;
import com.tydic.fsc.settle.busi.api.bo.PayTradeServiceFeeRecordListReqBO;
import com.tydic.fsc.settle.busi.api.bo.PayTradeServiceFeeRecordListRspBO;
import com.tydic.fsc.settle.busi.api.bo.PayTradeServiceFeeRecordRspBO;
import com.tydic.fsc.settle.dao.InquiryPayOrderMapper;
import com.tydic.fsc.settle.dao.InquiryTranInfoMapper;
import com.tydic.fsc.settle.dao.po.InquiryPayOrder;
import com.tydic.fsc.settle.dao.po.InquiryPayOrderExt;
import com.tydic.fsc.settle.dao.po.InquiryTranInfoPO;
import com.tydic.fsc.settle.dao.vo.InquiryTranInfoVO;
import com.tydic.fsc.settle.enums.InquiryPayFeeType;
import com.tydic.fsc.settle.enums.InquiryPayPass;
import com.tydic.fsc.settle.enums.InquiryTradeState;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayTradeServiceFeeRecordListServiceImpl
implements PayTradeServiceFeeRecordListService {
    @Autowired
    private InquiryTranInfoMapper inquiryTranInfoMapper;
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;
    @Autowired
    private EnumsService enumsService;

    public PayTradeServiceFeeRecordListRspBO tradeServiceFeeRecordList(PayTradeServiceFeeRecordListReqBO reqBO) {
        if (null == reqBO.getSupId()) {
            throw new BusinessException("1001", "\u4f9b\u5e94\u5546\u7f16\u53f7[supId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PayTradeServiceFeeRecordListRspBO rspBO = new PayTradeServiceFeeRecordListRspBO();
        int idx = (reqBO.getPageNo() - 1) * reqBO.getPageSize();
        if (idx < 0) {
            idx = 0;
        }
        int recordsTotal = 0;
        int total = 0;
        InquiryTranInfoPO inquiryTranInfoPO = new InquiryTranInfoPO();
        inquiryTranInfoPO.setInquiryNo(reqBO.getInquiryNo());
        inquiryTranInfoPO.setTradeState(reqBO.getTradeState());
        inquiryTranInfoPO.setSupplierId(reqBO.getSupId());
        ArrayList<String> payFeeTypeList = new ArrayList<String>();
        payFeeTypeList.add(InquiryPayFeeType.TRADE_SERVICE_FEE.getCode());
        payFeeTypeList.add(InquiryPayFeeType.PURCH_SERVICE_FEE.getCode());
        inquiryTranInfoPO.setPayFeeTypeList(payFeeTypeList);
        recordsTotal = this.inquiryTranInfoMapper.queryCountByConditions(inquiryTranInfoPO);
        if (recordsTotal > 0) {
            total = recordsTotal / reqBO.getPageSize() + (recordsTotal % reqBO.getPageSize() > 0 ? 1 : 0);
        }
        ArrayList<PayTradeServiceFeeRecordRspBO> rows = new ArrayList<PayTradeServiceFeeRecordRspBO>();
        InquiryTranInfoVO inquiryTranInfoVO = new InquiryTranInfoVO();
        BeanUtils.copyProperties((Object)inquiryTranInfoPO, (Object)inquiryTranInfoVO);
        inquiryTranInfoVO.setRowIndex(idx);
        inquiryTranInfoVO.setPageSize(reqBO.getPageSize());
        inquiryTranInfoVO.setSortOrder("MER_DATE desc");
        List<InquiryTranInfoPO> tranList = this.inquiryTranInfoMapper.queryListByConditions(inquiryTranInfoVO);
        if (null != tranList && !tranList.isEmpty()) {
            for (InquiryTranInfoPO tranInfo : tranList) {
                PayTradeServiceFeeRecordRspBO pts = new PayTradeServiceFeeRecordRspBO();
                BeanUtils.copyProperties((Object)tranInfo, (Object)pts);
                InquiryPayOrderExt inquiryPayOrderExt = new InquiryPayOrderExt();
                inquiryPayOrderExt.setInquiryNo(pts.getInquiryNo());
                InquiryPayOrder inquiryPayOrder = this.inquiryPayOrderMapper.selectByPrimaryKey(inquiryPayOrderExt);
                if (inquiryPayOrder != null) {
                    pts.setPayOrderName(inquiryPayOrder.getPayOrderName());
                }
                pts.setTradeStateDesc(this.enumsService.getDescr(InquiryTradeState.getInstance(tranInfo.getTradeState())));
                pts.setPayPassDesc(this.enumsService.getDescr(InquiryPayPass.getInstance(tranInfo.getPayType())));
                pts.setPayOrderNo(tranInfo.getGoodsId());
                rows.add(pts);
            }
        }
        rspBO.setRecordsTotal(recordsTotal);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setTotal(total);
        rspBO.setRows(rows);
        return rspBO;
    }
}

