/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.JdExpressTokenService;
import com.tydic.fsc.settle.busi.api.PlatfUseFeeMailForInvoiceService;
import com.tydic.fsc.settle.busi.api.bo.PlatfUseFeeMailForInvoiceServiceReqBO;
import com.tydic.fsc.settle.busi.api.bo.PlatfUseFeeMailForInvoiceServiceRspBO;
import com.tydic.fsc.settle.busi.impl.PlatfUseFeeMailForInvoiceServiceThread;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.SaleInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.SaleInvoiceMailInfoMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.po.JdexpressToken;
import com.tydic.fsc.settle.dao.po.SaleInvoiceInfo;
import com.tydic.fsc.settle.dao.po.SaleInvoiceMailInfo;
import com.tydic.fsc.settle.dao.vo.SaleInvoiceInfoVO;
import com.tydic.fsc.settle.enums.InvoiceMailSentStatus;
import com.tydic.fsc.settle.utils.FscStringUtils;
import com.tydic.fsc.supplier.BusiJdExpressService;
import com.tydic.fsc.supplier.bo.JdexpressTokenVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PlatfUseFeeMailForInvoiceServiceImpl
implements PlatfUseFeeMailForInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(PlatfUseFeeMailForInvoiceServiceImpl.class);
    @Autowired
    private SaleInvoiceMailInfoMapper invoiceMailInfoMapper;
    @Autowired
    private BusiJdExpressService busiJdExpressConfigService;
    @Autowired
    private JdExpressTokenService jdExpressTokenService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;

    public PlatfUseFeeMailForInvoiceServiceRspBO makeMailForInvoice(PlatfUseFeeMailForInvoiceServiceReqBO reqBO) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("\u53d1\u8d77\u90ae\u5bc4\u53d1\u7968\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO.getCompanyId() == null) {
            throw new BusinessException("1001", "\u4e13\u4e1a\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSenderName() == null || reqBO.getSenderName() == "") {
            throw new BusinessException("1001", "\u5bc4\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSenderAddr() == null || reqBO.getSenderAddr() == "") {
            throw new BusinessException("1001", "\u5bc4\u65b9\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSenderPhone() == null || reqBO.getSenderPhone() == "") {
            throw new BusinessException("1001", "\u5bc4\u65b9\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getInvoiceNoList() == null || reqBO.getInvoiceNoList().isEmpty()) {
            throw new BusinessException("1001", "\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JdexpressToken token = this.jdExpressTokenService.getToken(reqBO.getCompanyId());
        if (null == token) {
            throw new BusinessException("1002", "token\u4fe1\u606f\u672a\u7ef4\u62a4,\u8bf7\u5148\u7ef4\u62a4");
        }
        JdexpressTokenVO tokenVO = new JdexpressTokenVO();
        BeanUtils.copyProperties((Object)token, (Object)tokenVO);
        List invoiceNoList = reqBO.getInvoiceNoList();
        List expressIds = new ArrayList();
        logger.debug("\u53d1\u8d77\u90ae\u5bc4\u53d1\u7968\u670d\u52a1-\u9700\u8981\u83b7\u53d6\u65b0\u5feb\u9012\u5355\u7684\u5f85\u90ae\u5bc4\u53d1\u7968\u6570\u4e3a" + invoiceNoList.size());
        Integer totalMail = invoiceNoList.size();
        try {
            if (totalMail > 100) {
                Integer circleTimes = totalMail % 100 > 0 ? totalMail / 100 + 1 : totalMail / 100;
                for (int i = 0; i < circleTimes; ++i) {
                    int count = i == circleTimes - 1 && totalMail % 100 > 0 ? totalMail % 100 : 100;
                    expressIds.addAll(this.busiJdExpressConfigService.applyBillCode(count, tokenVO));
                }
            } else {
                expressIds = this.busiJdExpressConfigService.applyBillCode(totalMail.intValue(), tokenVO);
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u4eac\u4e1c-\u83b7\u53d6\u5feb\u9012\u5355\u63a5\u53e3\u51fa\u9519", (Throwable)e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u8c03\u7528\u4eac\u4e1c-\u83b7\u53d6\u5feb\u9012\u5355\u63a5\u53e3\u51fa\u9519", (Throwable)e);
        }
        if (CollectionUtils.isEmpty(expressIds)) {
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u8c03\u7528\u4eac\u4e1c-\u83b7\u53d6\u5feb\u9012\u5355\u63a5\u53e3\u51fa\u9519");
        }
        if (expressIds.size() != totalMail.intValue()) {
            logger.error("\u8c03\u7528\u4eac\u4e1c-\u83b7\u53d6\u5feb\u9012\u5355\u63a5\u53e3\u51fa\u9519\uff0c\u8fd4\u56de\u5355\u6570" + expressIds.size() + "\u4e0e\u8bf7\u6c42\u5355\u6570" + totalMail + "\u4e0d\u4e00\u81f4");
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u8c03\u7528\u4eac\u4e1c-\u83b7\u53d6\u5feb\u9012\u5355\u63a5\u53e3\u51fa\u9519\uff0c\u8fd4\u56de\u5355\u6570" + expressIds.size() + "\u4e0e\u8bf7\u6c42\u5355\u6570" + totalMail + "\u4e0d\u4e00\u81f4");
        }
        Integer expressId = 0;
        for (String invoiceNo : invoiceNoList) {
            SaleInvoiceInfo saleInvoiceInfo = this.saleInvoiceInfoMapper.selectByPrimaryKey(invoiceNo);
            BillApplyInfo applyInfoPO = this.billApplyInfoMapper.selectByPrimaryKey(saleInvoiceInfo.getApplyNo());
            String province = FscStringUtils.valueOf(applyInfoPO.getProvince());
            String city = FscStringUtils.valueOf(applyInfoPO.getCity());
            String county = FscStringUtils.valueOf(applyInfoPO.getCounty());
            String town = FscStringUtils.valueOf(applyInfoPO.getTown());
            String addrDesc = FscStringUtils.valueOf(applyInfoPO.getAddrDesc());
            String addressStr = FscStringUtils.simplifyAddrdesc(province, city, county, town, addrDesc);
            SaleInvoiceMailInfo po = new SaleInvoiceMailInfo();
            po.setMailTicketNo((String)expressIds.get(expressId));
            po.setInvoceName(applyInfoPO.getInvoceName());
            po.setMailStatus(InvoiceMailSentStatus.NOT_SENT.getCode());
            po.setAddress(addressStr);
            po.setReceiver(applyInfoPO.getName());
            po.setTel(applyInfoPO.getMobile());
            po.setJdAssignStatus("");
            po.setFailReason("");
            po.setCreateUser(reqBO.getUsername());
            po.setCreateDate(new Date());
            this.invoiceMailInfoMapper.insert(po);
            SaleInvoiceInfoVO updateInvoiceVO = new SaleInvoiceInfoVO();
            updateInvoiceVO.setInvoiceNo(invoiceNo);
            updateInvoiceVO.setMailTicketNo((String)expressIds.get(expressId));
            this.saleInvoiceInfoMapper.updateBy(updateInvoiceVO);
            Integer n = expressId;
            Integer n2 = expressId = Integer.valueOf(expressId + 1);
        }
        for (String expressVal : expressIds) {
            SaleInvoiceMailInfo singleMailing = new SaleInvoiceMailInfo();
            singleMailing.setMailTicketNo(expressVal);
            singleMailing.setMailStatus(InvoiceMailSentStatus.PROCCESSING.getCode());
            this.invoiceMailInfoMapper.updateByMailTicketNo(singleMailing);
            logger.debug("\u6210\u529f\u5c06\u5feb\u9012\u5355\u53f7" + expressVal + "\u5bf9\u5e94\u7684\u5f85\u90ae\u5bc4\u8bb0\u5f55\u72b6\u6001\u66f4\u65b0\u4e3a11-\u5904\u7406\u4e2d");
        }
        PlatfUseFeeMailForInvoiceServiceThread thread = new PlatfUseFeeMailForInvoiceServiceThread();
        thread.setInvoiceNoList(invoiceNoList);
        thread.setSenderName(reqBO.getSenderName());
        thread.setSenderAddr(reqBO.getSenderAddr());
        thread.setSenderPhone(reqBO.getSenderPhone());
        thread.setJdToken(tokenVO);
        thread.start();
        PlatfUseFeeMailForInvoiceServiceRspBO rspBO = new PlatfUseFeeMailForInvoiceServiceRspBO();
        return rspBO;
    }
}

