/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.UserInfoService;
import com.tydic.fsc.settle.bo.FscPageRspBo;
import com.tydic.fsc.settle.busi.api.QueryApplyPayInfoService;
import com.tydic.fsc.settle.busi.api.bo.ApplyPayInfoBO;
import com.tydic.fsc.settle.busi.api.bo.PurchaseOrderDetailInfoRspBO;
import com.tydic.fsc.settle.busi.api.bo.QueryApplyPayInfoReqBO;
import com.tydic.fsc.settle.dao.ApplyPayInfoMapper;
import com.tydic.fsc.settle.dao.PayableDetailMapper;
import com.tydic.fsc.settle.dao.po.PayableDetailPO;
import com.tydic.fsc.settle.dao.vo.ApplyPayInfoVO;
import com.tydic.fsc.settle.enums.BaseEnums;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.PayResultStatus;
import com.tydic.fsc.settle.enums.WFStatus;
import com.tydic.fsc.settle.utils.AntiSqlInjectionManage;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryApplyPayInfoServiceImpl
implements QueryApplyPayInfoService {
    private static final Logger logger = LoggerFactory.getLogger(QueryApplyPayInfoServiceImpl.class);
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private PayableDetailMapper payableDetailMapper;

    public FscPageRspBo<ApplyPayInfoBO> queryListPage(QueryApplyPayInfoReqBO queryApplyPayInfoReqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u4ed8\u6b3e\u7533\u8bf7\u670d\u52a1\u5165\u53c2\uff1a" + queryApplyPayInfoReqBO.toString());
        }
        FscPageRspBo rspPageBO = new FscPageRspBo();
        ApplyPayInfoVO applyPayInfoVO = new ApplyPayInfoVO();
        BeanUtils.copyProperties((Object)queryApplyPayInfoReqBO, (Object)applyPayInfoVO);
        String orderBy = null;
        if (queryApplyPayInfoReqBO.getSupplierId() != null) {
            applyPayInfoVO.setSupplierId(queryApplyPayInfoReqBO.getSupplierId());
        }
        if (queryApplyPayInfoReqBO.getSource() != null) {
            applyPayInfoVO.setSource(String.valueOf(queryApplyPayInfoReqBO.getSource()));
        }
        if (!StringUtils.isEmpty((CharSequence)queryApplyPayInfoReqBO.getSortName()) && !StringUtils.isEmpty((CharSequence)queryApplyPayInfoReqBO.getSortOrder())) {
            if (AntiSqlInjectionManage.sqlValidate(queryApplyPayInfoReqBO.getSortName()) || AntiSqlInjectionManage.sqlValidate(queryApplyPayInfoReqBO.getSortOrder())) {
                logger.error("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                throw new BusinessException("1002", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
            }
            orderBy = queryApplyPayInfoReqBO.getSortName() + " " + queryApplyPayInfoReqBO.getSortOrder();
        } else {
            orderBy = " PAYNO desc";
        }
        Page page = new Page(queryApplyPayInfoReqBO.getPageNo(), queryApplyPayInfoReqBO.getPageSize());
        BeanUtils.copyProperties((Object)queryApplyPayInfoReqBO, (Object)applyPayInfoVO);
        applyPayInfoVO.setCompanyId(queryApplyPayInfoReqBO.getCompanyId());
        Date startDate = queryApplyPayInfoReqBO.getApplyDateStart();
        Date endDate = queryApplyPayInfoReqBO.getApplyDateEnd();
        List<ApplyPayInfoVO> applyPayInfoVOs = this.applyPayInfoMapper.getListPageByTermsExt(applyPayInfoVO, startDate, endDate, (Page<Map<String, Object>>)page, orderBy);
        LinkedList<ApplyPayInfoBO> applyPayInfoBOs = new LinkedList<ApplyPayInfoBO>();
        if (!applyPayInfoVOs.isEmpty()) {
            for (int i = 0; i < applyPayInfoVOs.size(); ++i) {
                applyPayInfoVO = applyPayInfoVOs.get(i);
                ApplyPayInfoBO applyPayInfoBO = new ApplyPayInfoBO();
                BeanUtils.copyProperties((Object)applyPayInfoVO, (Object)applyPayInfoBO);
                OrderSource orderSourceEnum = OrderSource.getInstance((String)String.valueOf(applyPayInfoBO.getSource()));
                applyPayInfoBO.setSourceStr(this.enumsService.getDescr((BaseEnums)orderSourceEnum));
                String supplierStr = this.organizationInfoService.querySupplierName(applyPayInfoBO.getSupplierId());
                applyPayInfoBO.setSupplierStr(supplierStr);
                PayResultStatus payResultEnum = PayResultStatus.getInstance(applyPayInfoBO.getPayStatus());
                applyPayInfoBO.setPayStatusStr(this.enumsService.getDescr(payResultEnum));
                String operName = this.userInfoService.queryUserNameByUserId(applyPayInfoBO.getOperatorId());
                applyPayInfoBO.setOperatorName(operName);
                applyPayInfoBO.setBranchCompanyName(this.organizationInfoService.queryOrgName(applyPayInfoVO.getBranchCompany()));
                PayResultStatus sta = PayResultStatus.getInstance(applyPayInfoBO.getPayStatus());
                if (sta != null && (sta == PayResultStatus.CANCEL || sta == PayResultStatus.SUCCESS)) {
                    applyPayInfoBO.setApplyClosed("Y");
                } else {
                    applyPayInfoBO.setApplyClosed("N");
                }
                if (StringUtils.isNotBlank((CharSequence)applyPayInfoBO.getApprovalStatus())) {
                    applyPayInfoBO.setApprovalStatusDescr(this.enumsService.getDescr(WFStatus.getInstance(applyPayInfoBO.getApprovalStatus())));
                }
                applyPayInfoBO.setLastOperator(this.userInfoService.queryUserNameByUserId(applyPayInfoVO.getLastOperator()));
                LinkedList<PurchaseOrderDetailInfoRspBO> purchaseOrderDetailList = new LinkedList<PurchaseOrderDetailInfoRspBO>();
                List<PayableDetailPO> payDetailList = this.payableDetailMapper.selectListJoinApplyPayInfo(applyPayInfoBO.getPayno());
                for (PayableDetailPO po : payDetailList) {
                    PurchaseOrderDetailInfoRspBO rspBO = new PurchaseOrderDetailInfoRspBO();
                    rspBO.setInspectionId(po.getInspectionId());
                    rspBO.setPurchaseOrderCode(po.getPurchaseOrderCode());
                    rspBO.setPurchaseOrderName(po.getPurchaseOrderName());
                    purchaseOrderDetailList.add(rspBO);
                }
                applyPayInfoBO.setPurchaseOrderDetailList(purchaseOrderDetailList);
                applyPayInfoBOs.add(applyPayInfoBO);
            }
        }
        rspPageBO.setRows(applyPayInfoBOs);
        rspPageBO.setRecordsTotal(page.getTotalCount());
        rspPageBO.setTotal(page.getTotalPages());
        rspPageBO.setPageNo(page.getPageNo());
        return rspPageBO;
    }
}

