/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.DictionaryAtomService;
import com.tydic.fsc.settle.atom.bo.DictionaryAtomReqBo;
import com.tydic.fsc.settle.atom.bo.DictionaryAtomRspBo;
import com.tydic.fsc.settle.busi.api.ReconciliationHisService;
import com.tydic.fsc.settle.busi.api.bo.ReconciliationReqBo;
import com.tydic.fsc.settle.busi.api.vo.ReconciliationHisVo;
import com.tydic.fsc.settle.busi.api.vo.ReconciliationRspVo;
import com.tydic.fsc.settle.dao.PayPurchaseOrderInfoMapper;
import com.tydic.fsc.settle.dao.ReconcilitionHisMapper;
import com.tydic.fsc.settle.dao.po.PayPurchaseOrderInfo;
import com.tydic.fsc.settle.dao.po.ReconcilitionHis;
import com.tydic.fsc.settle.enums.ReconciliationStatus;
import com.tydic.fsc.settle.utils.DateUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ReconciliationHisServiceImpl
implements ReconciliationHisService {
    private DictionaryAtomService dicDictionaryService;
    private ReconcilitionHisMapper reconcilitionHisMapper;
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;

    @Autowired
    private ReconciliationHisServiceImpl(DictionaryAtomService dicDictionaryService, ReconcilitionHisMapper reconcilitionHisMapper, PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper) {
        this.dicDictionaryService = dicDictionaryService;
        this.reconcilitionHisMapper = reconcilitionHisMapper;
        this.payPurchaseOrderInfoMapper = payPurchaseOrderInfoMapper;
    }

    public ReconciliationRspVo getReceiptInfoBO(ReconciliationReqBo condition) {
        if (null == condition) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map<String, String> reconclStatusMap = this.getDictMap("RECONCIL_STATUS");
        ReconciliationRspVo rspVo = new ReconciliationRspVo();
        Page page = new Page(condition.getPageNo() < 1 ? 1 : condition.getPageNo(), condition.getPageSize() < 1 ? 10 : condition.getPageSize());
        List<ReconcilitionHis> hisRows = this.reconcilitionHisMapper.getPageListByCondition(condition, (Page<Map<String, Object>>)page);
        ArrayList<ReconciliationHisVo> rows = new ArrayList<ReconciliationHisVo>();
        for (ReconcilitionHis reconciliationHis : hisRows) {
            ReconciliationHisVo vo = new ReconciliationHisVo();
            BeanUtils.copyProperties((Object)reconciliationHis, (Object)vo);
            if (null != reconciliationHis.getOrderAmt()) {
                vo.setEorderAmt(reconciliationHis.getOrderAmt());
            }
            if (null != reconciliationHis.getOutAmt()) {
                vo.setOrderAmt(reconciliationHis.getOutAmt());
            }
            if (null != reconciliationHis.getOrderId()) {
                vo.setOrderId(reconciliationHis.getOrderId() + "");
            }
            if (null != reconciliationHis.getReconciliationStatus()) {
                vo.setReconciliStatusName(reconclStatusMap.get(reconciliationHis.getReconciliationStatus() + ""));
            }
            if (null != reconciliationHis.getOrderDate()) {
                vo.setOrderDate(DateUtil.dateToStr(reconciliationHis.getOrderDate()));
            }
            if (null != reconciliationHis.getReconciliationDate()) {
                vo.setReconcilDate(DateUtil.dateToStr(reconciliationHis.getReconciliationDate()));
            }
            if (null != reconciliationHis.getRecvDate()) {
                vo.setRecvDate(DateUtil.dateToStr(reconciliationHis.getRecvDate()));
            }
            if (null != reconciliationHis.getOrderId()) {
                Long orderId = reconciliationHis.getOrderId();
                PayPurchaseOrderInfo payPurchaseOrderInfo = new PayPurchaseOrderInfo();
                payPurchaseOrderInfo.setPurchaseOrderCode(orderId + "");
                PayPurchaseOrderInfo modelBy = this.payPurchaseOrderInfoMapper.getModelBy(payPurchaseOrderInfo);
                if (null != modelBy) {
                    String notificationNo = modelBy.getNotificationNo();
                    vo.setNotificationNo(notificationNo);
                }
            }
            rows.add(vo);
        }
        rspVo.setPageNo(page.getPageNo());
        rspVo.setRecordsTotal(page.getTotalCount());
        rspVo.setTotal(page.getTotalPages());
        rspVo.setRows(rows);
        rspVo.setRespCode("0000");
        rspVo.setRespDesc("\u6210\u529f");
        return rspVo;
    }

    public ReconciliationRspVo getHisExcel(ReconciliationReqBo condition) {
        if (null == condition) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ReconciliationRspVo rspVo = new ReconciliationRspVo();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Map<String, String> reconclStatusMap = this.getDictMap("RECONCIL_STATUS");
        List<ReconcilitionHis> hisRows = this.reconcilitionHisMapper.getHisByCondition(condition);
        ArrayList<ReconciliationHisVo> rows = new ArrayList<ReconciliationHisVo>();
        for (ReconcilitionHis reconciliationHis : hisRows) {
            if (reconciliationHis == null) continue;
            ReconciliationHisVo vo = new ReconciliationHisVo();
            BeanUtils.copyProperties((Object)reconciliationHis, (Object)vo);
            if (null != reconciliationHis.getOrderAmt()) {
                vo.setEorderAmt(reconciliationHis.getOrderAmt());
            }
            if (null != reconciliationHis.getOutAmt()) {
                vo.setOrderAmt(reconciliationHis.getOutAmt());
            }
            if (null != reconciliationHis.getOrderId()) {
                vo.setOrderId(reconciliationHis.getOrderId() + "");
            }
            if (null != reconciliationHis.getOrderDate()) {
                vo.setOrderDate(simpleDateFormat.format(reconciliationHis.getOrderDate()));
            }
            if (null != reconciliationHis.getReconciliationDate()) {
                vo.setReconcilDate(simpleDateFormat.format(reconciliationHis.getReconciliationDate()));
            }
            if (null != reconciliationHis.getReconciliationStatus()) {
                vo.setReconciliStatusName(reconclStatusMap.get(reconciliationHis.getReconciliationStatus() + ""));
            }
            rows.add(vo);
        }
        rspVo.setRows(rows);
        return rspVo;
    }

    public ReconciliationRspVo getReceiptInfoByTabId(ReconciliationReqBo condition) {
        if (null == condition) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Integer tabId = condition.getTabId();
        condition.setReconciliationStatus(tabId);
        boolean withPage = true;
        ReconciliationRspVo rspVo = Integer.valueOf(ReconciliationStatus.NOT_RECONCILED.getCode()).equals(tabId) ? this.getOrderByTabId(condition, withPage) : this.getReceiptInByTabId(condition, tabId, withPage);
        return rspVo;
    }

    public ReconciliationRspVo getExcelByTabId(ReconciliationReqBo condition) {
        if (null == condition) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Integer tabId = condition.getTabId();
        boolean withPage = false;
        ReconciliationRspVo rspVo = tabId == 0 ? this.getOrderByTabId(condition, withPage) : this.getReceiptInByTabId(condition, tabId, withPage);
        return rspVo;
    }

    private ReconciliationRspVo getReceiptInByTabId(ReconciliationReqBo condition, Integer tabId, boolean withPage) {
        List<ReconcilitionHis> listrows;
        if (null == condition) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ReconciliationRspVo rspVo = new ReconciliationRspVo();
        ArrayList<ReconciliationHisVo> rows = new ArrayList<ReconciliationHisVo>();
        Page page = new Page(condition.getPageNo() < 1 ? 1 : condition.getPageNo(), condition.getPageSize() < 1 ? 10 : condition.getPageSize());
        if (withPage) {
            condition.setReconciliationStatus(tabId);
            listrows = this.reconcilitionHisMapper.getPageListByCondition(condition, (Page<Map<String, Object>>)page);
        } else {
            condition.setReconciliationStatus(tabId);
            listrows = this.reconcilitionHisMapper.getHisByCondition(condition);
        }
        Map<String, String> reconclStatusMap = this.getDictMap("RECONCIL_STATUS");
        for (ReconcilitionHis reconcilitionHis : listrows) {
            ReconciliationHisVo vo = new ReconciliationHisVo();
            BeanUtils.copyProperties((Object)reconcilitionHis, (Object)vo);
            if (null != reconcilitionHis.getOrderId()) {
                vo.setOrderId(reconcilitionHis.getOrderId() + "");
            }
            if (null != reconcilitionHis.getReconciliationStatus()) {
                vo.setReconciliStatusName(reconclStatusMap.get(reconcilitionHis.getReconciliationStatus() + ""));
            }
            if (null != reconcilitionHis.getOrderDate()) {
                vo.setOrderDate(DateUtil.dateToStr(reconcilitionHis.getOrderDate()));
            }
            if (null != reconcilitionHis.getReconciliationDate()) {
                vo.setReconcilDate(DateUtil.dateToStr(reconcilitionHis.getReconciliationDate()));
            }
            if (null != reconcilitionHis.getRecvDate()) {
                vo.setRecvDate(DateUtil.dateToStr(reconcilitionHis.getRecvDate()));
            }
            if (null != reconcilitionHis.getOutAmt()) {
                vo.setOrderAmt(reconcilitionHis.getOutAmt());
            }
            if (null != reconcilitionHis.getOrderAmt()) {
                vo.setEorderAmt(reconcilitionHis.getOrderAmt());
            }
            rows.add(vo);
        }
        rspVo.setRows(rows);
        rspVo.setPageNo(page.getPageNo());
        rspVo.setRecordsTotal(page.getTotalCount());
        rspVo.setTotal(page.getTotalPages());
        rspVo.setRespCode("0000");
        rspVo.setRespDesc("\u6210\u529f");
        return rspVo;
    }

    private ReconciliationRspVo getOrderByTabId(ReconciliationReqBo condition, boolean withPage) {
        ReconciliationRspVo rspVo = new ReconciliationRspVo();
        Page page = new Page(condition.getPageNo() < 1 ? 1 : condition.getPageNo(), condition.getPageSize() < 1 ? 10 : condition.getPageSize());
        if (null != condition.getReconciliationDateStart() || null != condition.getReconciliationrDateEnd()) {
            rspVo.setPageNo(1);
            rspVo.setRecordsTotal(0);
            rspVo.setTotal(0);
            rspVo.setRows(new ArrayList());
            rspVo.setRespCode("0000");
            rspVo.setRespDesc("\u6210\u529f");
            return rspVo;
        }
        List<PayPurchaseOrderInfo> payPurchaseOrderInfoList = withPage ? this.payPurchaseOrderInfoMapper.getReconclListPage(condition, (Page<Map<String, Object>>)page) : this.payPurchaseOrderInfoMapper.getReconclListPage(condition);
        ArrayList<ReconciliationHisVo> rows = new ArrayList<ReconciliationHisVo>();
        Map<String, String> reconcilStatusMap = this.getDictMap("RECONCIL_STATUS");
        Map<String, String> orderStatusMap = this.getDictMap("D_SALE_ORDER_INFO_ORDER_STATUS");
        if (!CollectionUtils.isEmpty(payPurchaseOrderInfoList)) {
            for (PayPurchaseOrderInfo orderInfo : payPurchaseOrderInfoList) {
                ReconciliationHisVo vo = new ReconciliationHisVo();
                BeanUtils.copyProperties((Object)orderInfo, (Object)vo);
                vo.setOrderId(orderInfo.getPurchaseOrderCode());
                vo.setOrderStatusName(orderStatusMap.get(orderInfo.getOrderStatus()));
                if (null != orderInfo.getOrderDate()) {
                    vo.setOrderDate(DateUtil.dateToStr(orderInfo.getOrderDate()));
                }
                if (null != orderInfo.getRecvDate()) {
                    vo.setRecvDate(DateUtil.dateToStr(orderInfo.getRecvDate()));
                }
                if (null != orderInfo.getReconcilitionStatus()) {
                    vo.setReconciliStatusName(reconcilStatusMap.get(orderInfo.getReconcilitionStatus()));
                }
                if (null != orderInfo.getOrderAmt()) {
                    vo.setEorderAmt(orderInfo.getOrderAmt());
                }
                rows.add(vo);
            }
        }
        rspVo.setPageNo(page.getPageNo());
        rspVo.setRecordsTotal(page.getTotalCount());
        rspVo.setTotal(page.getTotalPages());
        rspVo.setRows(rows);
        rspVo.setRespCode("0000");
        rspVo.setRespDesc("\u6210\u529f");
        return rspVo;
    }

    private Map<String, String> getDictMap(String pcode) {
        Map<String, String> map = new HashMap<String, String>(2);
        DictionaryAtomReqBo dictionaryAtomReqBo = new DictionaryAtomReqBo();
        dictionaryAtomReqBo.setpCode(pcode);
        DictionaryAtomRspBo dictionaryAtomRspBo = this.dicDictionaryService.qryDic(dictionaryAtomReqBo);
        if (null != dictionaryAtomRspBo) {
            map = dictionaryAtomRspBo.getData();
        }
        return map;
    }
}

