/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.utils;

import com.tydic.fsc.settle.utils.SpringApplicationContext;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);
    public static String ossAccessUrlPrivate;
    public static String filePayPath;
    private static String portalEthernetUrl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fileToBase64(File file) {
        FileInputStream fin = null;
        BufferedInputStream bin = null;
        ByteArrayOutputStream baos = null;
        FilterOutputStream bout = null;
        try {
            fin = new FileInputStream(file);
            bin = new BufferedInputStream(fin);
            baos = new ByteArrayOutputStream();
            bout = new BufferedOutputStream(baos);
            byte[] buffer = new byte[1024];
            int len = bin.read(buffer);
            while (len != -1) {
                ((BufferedOutputStream)bout).write(buffer, 0, len);
                len = bin.read(buffer);
            }
            ((BufferedOutputStream)bout).flush();
            byte[] bytes = baos.toByteArray();
            String string = Base64.encodeBase64String((byte[])bytes);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                fin.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                bin.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                bout.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                baos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String fileToBase64(ByteArrayOutputStream byteArrayOutputStream) {
        String base64String = "";
        if (byteArrayOutputStream != null) {
            try {
                base64String = Base64.encodeBase64String((byte[])byteArrayOutputStream.toByteArray());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return base64String;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void base64ToFile(String filename, String base64String) {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            byte[] bytes = Base64.decodeBase64((String)base64String);
            inputStream = new ByteArrayInputStream(bytes);
            outputStream = new FileOutputStream(filename);
            byte[] buff = new byte[1024];
            int len = 0;
            while ((len = inputStream.read(buff)) != -1) {
                outputStream.write(buff, 0, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String obtainOSSUrl(String filename) {
        return null;
    }

    private static void init() {
    }

    public static String fileToBase64(InputStream inputStream) {
        String base64String = "";
        if (inputStream != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                int len = 0;
                while ((len = inputStream.read(buffer)) > -1) {
                    byteArrayOutputStream.write(buffer, 0, len);
                }
                byteArrayOutputStream.flush();
                base64String = FileUtils.fileToBase64(byteArrayOutputStream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return base64String;
    }

    public static String getPdfBase64StrByAccessPortal(String subUrl, Map<String, Object> urlParam) {
        String base64Str = "";
        if (StringUtils.hasText((String)subUrl) && null != urlParam) {
            Properties prop = (Properties)SpringApplicationContext.getBean("propertyConfigurer");
            if (prop != null) {
                portalEthernetUrl = prop.getProperty("PORTAL_ETHERNET_URL");
            }
            CloseableHttpClient httpClient = HttpClients.createDefault();
            String url = portalEthernetUrl + subUrl;
            StringBuilder paramSb = new StringBuilder("?");
            for (Map.Entry<String, Object> entry : urlParam.entrySet()) {
                paramSb.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
            }
            String param = paramSb.toString().substring(0, paramSb.toString().length() - 1);
            logger.debug("\u8bbf\u95ee\u95e8\u6237\u8bf7\u6c42URL:" + url + param);
            HttpGet httpGet = new HttpGet(url + param);
            InputStream inputStream = null;
            try {
                HttpEntity httpEntity;
                CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
                int statusCode = httpResponse.getStatusLine().getStatusCode();
                if (statusCode == 200 && null != (httpEntity = httpResponse.getEntity()) && null != httpEntity.getContent()) {
                    inputStream = httpEntity.getContent();
                    base64Str = FileUtils.fileToBase64(inputStream);
                }
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528\u5bfc\u51faPDF\u63a7\u5236\u5668\u5931\u8d25:" + e.getMessage());
            }
        }
        return base64Str;
    }

    public static Map<String, Object> getTransmitYuanGuangFileInfo(String billTypeCode, String billNo, Long companyId, String suffixName, String subUrl, Map<String, Object> urlParam, double bytesTotalLen) {
        HashMap<String, Object> fileInfoMap = new HashMap<String, Object>();
        return fileInfoMap;
    }
}

