/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.aop;

import com.alibaba.dubbo.rpc.RpcContext;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.taobao.eagleeye.EagleEye;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=100)
public class FscBusiAspect {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String SEPARATOR = "|";
    private static final String EXCLUDE_METHODS = "subscribe";
    private static final String CLASS_METHOD_SEPARATOR = ".";
    private static final String START_IDENTIFICATION = "START";
    private static final String ERROR_IDENTIFICATION = "ERROR";
    private static final String END_IDENTIFICATION = "END";
    private static final String HIDDEN_PARM_KEY = "traceId";
    private static final Logger busiLog = LoggerFactory.getLogger(FscBusiAspect.class);

    @Pointcut(value="execution(* com.tydic.fsc.settle.busi.impl..*(..))")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        Map hiddenParm = RpcContext.getContext().getAttachments();
        String traceId = "";
        if (hiddenParm.containsKey(HIDDEN_PARM_KEY)) {
            traceId = (String)hiddenParm.get(HIDDEN_PARM_KEY);
        } else {
            traceId = EagleEye.getTraceId();
            hiddenParm.put(HIDDEN_PARM_KEY, traceId);
        }
        MethodSignature methodSignature = (MethodSignature)pjp.getSignature();
        Method method = methodSignature.getMethod();
        Class<?> rspClass = method.getReturnType();
        Object rspObj = null;
        String[] infos = this.printBusiAopStartLog(pjp, traceId);
        try {
            rspObj = pjp.proceed();
            this.putCodeToRsp(rspObj, "0000", "\u6210\u529f");
        }
        catch (BusinessException e) {
            if (busiLog.isDebugEnabled()) {
                busiLog.debug("BusinessException", (Throwable)e);
            }
            rspObj = rspClass.newInstance();
            String msgCode = e.getMsgCode();
            String desc = e.getMessage();
            if (StringUtils.isEmpty((CharSequence)msgCode)) {
                msgCode = "8888";
            }
            if (StringUtils.isEmpty((CharSequence)desc)) {
                desc = "\u5931\u8d25";
            }
            busiLog.info("busi\u5c42 BusinessException\uff1a{}", (Object)desc);
            this.printBusiAopErrorLog(infos, e);
            this.putCodeToRsp(rspObj, msgCode, desc);
        }
        catch (ResourceException e) {
            if (busiLog.isDebugEnabled()) {
                busiLog.debug("ResourceException", (Throwable)e);
            }
            rspObj = rspClass.newInstance();
            String msgCode = e.getMsgCode();
            String desc = e.getMessage();
            if (StringUtils.isEmpty((CharSequence)msgCode)) {
                msgCode = "8888";
            }
            if (StringUtils.isEmpty((CharSequence)desc)) {
                desc = "\u5931\u8d25";
            }
            busiLog.info("busi\u5c42 ResourceException\uff1a{}", (Object)desc);
            this.printBusiAopErrorLog(infos, e);
            this.putCodeToRsp(rspObj, msgCode, desc);
        }
        catch (Throwable e) {
            if (!rspClass.isInterface()) {
                this.printBusiAopErrorLog(infos, e);
                rspObj = rspClass.newInstance();
                this.putCodeToRsp(rspObj, "8888", "\u670d\u52a1\u8c03\u7528\u5f02\u5e38:" + e.getMessage());
            }
            throw e;
        }
        this.printBusiAopEndLog(infos, rspObj);
        return rspObj;
    }

    private void printBusiAopErrorLog(String[] infos, Throwable e) {
        if (infos == null) {
            return;
        }
        long nowTime = System.currentTimeMillis();
        infos[1] = ERROR_IDENTIFICATION;
        infos[3] = Long.toString(nowTime);
        if (null != this.getThrowableStrRep(e)) {
            infos[5] = this.getThrowableStrRep(e);
        }
        busiLog.error(this.getLogInfoByStrings(infos));
    }

    private void putCodeToRsp(Object object, String code, String desc) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        this.putCodeToRsp(object, code, desc, false);
    }

    private void putCodeToRsp(Object object, String code, String desc, boolean fource) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        if (object instanceof FscBaseRspBo) {
            Field field = FscBaseRspBo.class.getDeclaredField("respCode");
            field.setAccessible(true);
            if (!fource && field.get(object) == null) {
                field.set(object, code);
                field = FscBaseRspBo.class.getDeclaredField("respDesc");
                field.setAccessible(true);
                field.set(object, desc);
            } else if (fource && field.get(object) == null) {
                field.set(object, code);
                field = FscBaseRspBo.class.getDeclaredField("respDesc");
                field.setAccessible(true);
                field.set(object, desc);
            }
        }
    }

    private String[] printBusiAopStartLog(ProceedingJoinPoint pjp, String traceId) {
        long nowTime = System.currentTimeMillis();
        StringBuilder commonHead = new StringBuilder(traceId + SEPARATOR);
        String className = pjp.getTarget().getClass().getName();
        String methodString = pjp.getSignature().getName();
        if (EXCLUDE_METHODS.equals(methodString)) {
            return new String[0];
        }
        commonHead.append(className);
        commonHead.append(CLASS_METHOD_SEPARATOR);
        commonHead.append(methodString);
        String[] infos = new String[8];
        infos[0] = commonHead.toString();
        infos[1] = START_IDENTIFICATION;
        infos[2] = Long.toString(nowTime);
        infos[3] = "";
        Object[] params = pjp.getArgs();
        if (params != null && params.length > 0) {
            if (params.length == 1) {
                try {
                    infos[4] = MAPPER.writeValueAsString(params[0]);
                }
                catch (JsonProcessingException e) {
                    infos[4] = ("\u8bf7\u6c42\u62a5\u6587\u8f6cjson\u51fa\u9519\uff0c\u6539\u7528toString\u65b9\u6cd5" + params[0]).replace("\r\n", "");
                }
            } else {
                StringBuilder paramsStr = new StringBuilder();
                paramsStr.append("[");
                for (Object obj : params) {
                    String objStr = null;
                    if (obj != null) {
                        try {
                            objStr = MAPPER.writeValueAsString(obj);
                        }
                        catch (JsonProcessingException e) {
                            objStr = null;
                        }
                    }
                    paramsStr.append(objStr);
                    paramsStr.append(",");
                }
                paramsStr.setLength(paramsStr.length() - 1);
                paramsStr.append("]");
            }
        }
        busiLog.info(this.getLogInfoByStrings(infos));
        return infos;
    }

    private void printBusiAopEndLog(String[] infos, Object object) {
        if (infos == null) {
            return;
        }
        long nowTime = System.currentTimeMillis();
        infos[1] = END_IDENTIFICATION;
        infos[3] = Long.toString(nowTime);
        if (object instanceof FscBaseRspBo) {
            FscBaseRspBo resp = (FscBaseRspBo)object;
            infos[4] = resp.getRespCode();
            infos[5] = resp.getRespDesc();
            infos[6] = "\u7528\u65f6\uff1a" + (Long.parseLong(infos[3]) - Long.parseLong(infos[2])) + "ms";
            infos[7] = object.toString();
        }
        busiLog.info(this.getLogInfoByStrings(infos));
    }

    private String getLogInfoByStrings(String[] infos) {
        StringBuilder stb = new StringBuilder();
        for (String info : infos) {
            if (StringUtils.isBlank((CharSequence)info)) {
                info = "";
            }
            stb.append(info).append(SEPARATOR);
        }
        if (stb.length() > 1) {
            stb.setLength(stb.length() - 1);
        }
        return stb.toString();
    }

    private String getThrowableStrRep(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        pw.flush();
        LineNumberReader reader = new LineNumberReader(new StringReader(sw.toString()));
        StringBuilder sb = new StringBuilder();
        try {
            String line = reader.readLine();
            while (line != null) {
                sb.append(line).append("\r\n");
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            sb.append(ex.toString());
        }
        return sb.toString();
    }
}

