/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.atom;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.dao.JdexpressTokenMapper;
import com.tydic.fsc.settle.dao.po.JdexpressToken;
import com.tydic.fsc.settle.utils.DatesUtils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="jdExpressTokenService")
public class JdExpressTokenService {
    private static final Logger logger = LoggerFactory.getLogger(JdExpressTokenService.class);
    @Autowired
    private JdexpressTokenMapper jdexpressTokenMapper;

    public JdexpressToken getToken(Long operUnitNo) {
        return this.jdexpressTokenMapper.selectByPrimaryKey(operUnitNo);
    }

    public JdexpressToken updateToken(JdexpressToken token) {
        if (token.getOperUnitNo() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8bf7\u6307\u5b9a\u4e13\u4e1a\u516c\u53f8ID(operUnitNo)");
        }
        if (token.getCustCode() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u4eac\u4e1c\u5ba2\u6237\u53f7\u5fc5\u987b\u6307\u5b9a(custNo)");
        }
        try {
            token.setTokenCreateDate(new Date());
            token.setTokenExpiredDate(DatesUtils.dateBefore(365));
            int cnt = this.jdexpressTokenMapper.updateByPrimaryKeySelective(token);
            logger.info("\u66f4\u65b0\u4eac\u4e1c\u5feb\u9012Token,\u6570\u91cf=" + cnt);
            if (cnt == 0) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u4eac\u4e1c\u5feb\u9012Token\u5931\u8d25,\u627e\u4e0d\u5230\u8981\u66f4\u65b0\u7684\u8bb0\u5f55");
            }
            return token;
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u4eac\u4e1c\u5feb\u9012Token\u5931\u8d25", (Throwable)e);
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u4eac\u4e1c\u5feb\u9012Token\u5931\u8d25" + e.getMessage());
        }
    }
}

