/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.ContractService;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.QueryDictKeyValueService;
import com.tydic.fsc.settle.atom.SourceMappingService;
import com.tydic.fsc.settle.atom.UserInfoService;
import com.tydic.fsc.settle.atom.WorkFlowFinishEvent;
import com.tydic.fsc.settle.dao.ApplyDetailMapper;
import com.tydic.fsc.settle.dao.ApplyPayInfoMapper;
import com.tydic.fsc.settle.dao.FinanceConfigMapper;
import com.tydic.fsc.settle.dao.PayableDetailMapper;
import com.tydic.fsc.settle.dao.SupplierInfoMapper;
import com.tydic.fsc.settle.dao.po.ApplyDetail;
import com.tydic.fsc.settle.dao.po.ApplyPayInfoPO;
import com.tydic.fsc.settle.dao.po.FinanceConfig;
import com.tydic.fsc.settle.dao.po.SupplierInfo;
import com.tydic.fsc.settle.dao.po.WorkFlowDataInfo;
import com.tydic.fsc.settle.dao.vo.WFEventResult;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.YuanGuangBillType;
import com.tydic.fsc.settle.enums.YuanGuangType;
import com.tydic.fsc.settle.utils.FileUtils;
import com.tydic.fsc.settle.utils.FscStringUtils;
import com.tydic.fsc.supplier.BusiTransferApplyPayService;
import com.tydic.fsc.supplier.bo.BusiTransferApplyPayFileVO;
import com.tydic.fsc.supplier.bo.BusiTransferApplyPayItemVO;
import com.tydic.fsc.supplier.bo.BusiTransferApplyPayReqBO;
import com.tydic.fsc.supplier.bo.BusiTransferApplyPayRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="applyPayWorkFlowFinshEventImpl")
public class ApplyPayWorkFlowFinshEventImpl
implements WorkFlowFinishEvent {
    private static final Logger logger = LoggerFactory.getLogger(ApplyPayWorkFlowFinshEventImpl.class);
    @Value(value="${fsc.mock.active}")
    private boolean mockActive;
    @Autowired
    private BusiTransferApplyPayService busiTransferApplyPayService;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private SupplierInfoMapper supplierInfoMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private FinanceConfigMapper financeConfigMapper;
    @Autowired
    private QueryDictKeyValueService queryDictKeyValueService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private SourceMappingService sourceMappingService;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private ContractService contractService;

    @Override
    public WFEventResult process(WorkFlowDataInfo workFlowDataInfo, String billType, String billNo) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u4ed8\u6b3e\u7533\u8bf7\u5355\u5de5\u4f5c\u6d41\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff0cworkFlowDataInfo=" + workFlowDataInfo.toString() + ";billType=" + billType + ";billNo=" + billNo);
        }
        if (this.mockActive) {
            WFEventResult wfEventResult = new WFEventResult();
            wfEventResult.setSuccess(true);
            return wfEventResult;
        }
        long payNo = Long.parseLong(billNo);
        ApplyPayInfoPO applyPayInfoPO = this.applyPayInfoMapper.getModelById(payNo);
        if (applyPayInfoPO == null) {
            logger.error("\u6839\u636e\u4ed8\u6b3e\u7533\u8bf7\u5355\u53f7\u67e5\u8be2\u4ed8\u6b3e\u7533\u8bf7\u5355\u4fe1\u606f\u8fd4\u56de\u4e3a\u7a7a\uff0c\u4ed8\u6b3e\u7533\u8bf7\u5355\u53f7\u4e3a\uff1a" + billNo);
            throw new BusinessException("1002", "\u6839\u636e\u4ed8\u6b3e\u7533\u8bf7\u5355\u53f7\u67e5\u8be2\u4ed8\u6b3e\u7533\u8bf7\u5355\u4fe1\u606f\u8fd4\u56de\u4e3a\u7a7a");
        }
        String source = applyPayInfoPO.getSource();
        String targetSource = this.sourceMappingService.queryYuanguangTargetSource(source);
        String documentType = YuanGuangType.PAYMNET_APPROVAL_MATERIAL.getCode();
        FinanceConfig financeConfig = new FinanceConfig();
        financeConfig.setSource(targetSource);
        financeConfig.setOperUnitNo(applyPayInfoPO.getCompanyId());
        financeConfig.setBillType(documentType);
        financeConfig = this.financeConfigMapper.selectByFinanceConfig(financeConfig);
        if (null == financeConfig) {
            throw new BusinessException("1000", "\u8d22\u52a1\u914d\u7f6e\u8868\u6ca1\u6709\u914d\u7f6e\uff1a\u6765\u6e90" + targetSource + "\u4e13\u4e1a\u516c\u53f8" + applyPayInfoPO.getCompanyId() + "\u5355\u636e\u7c7b\u578b" + documentType);
        }
        Map<String, String> keyValue = this.queryDictKeyValueService.queryDictKeyValue(targetSource, documentType);
        BusiTransferApplyPayReqBO reqBO = new BusiTransferApplyPayReqBO();
        reqBO.setSeqid("PAY" + YuanGuangType.PAYMNET_APPROVAL_MATERIAL.getCode() + billNo);
        reqBO.setFlowid(financeConfig.getProcessId());
        reqBO.setSsdw(financeConfig.getUnitName());
        reqBO.setYhdm(this.userInfoService.queryFinanceUserCodeByUserId(source, financeConfig, applyPayInfoPO.getOperatorId()));
        ArrayList<Object> items = new ArrayList<Object>();
        reqBO.setItems(items);
        String supplierName = "";
        List<ApplyDetail> applyDetailList = this.applyDetailMapper.selectByApplyNo(applyPayInfoPO.getPayno());
        if (applyDetailList.isEmpty()) {
            throw new BusinessException("1000", "\u672a\u627e\u5230\u4ed8\u6b3e\u7533\u8bf7\u660e\u7ec6");
        }
        HashSet purchaseOrderCodes = new HashSet();
        for (ApplyDetail applyDetail : applyDetailList) {
            BusiTransferApplyPayItemVO itemVO = new BusiTransferApplyPayItemVO();
            if (!OrderSource.ELECTRIC_AREA.getCode().equals(source) && !OrderSource.COAL_AREA.getCode().equals(source) && !OrderSource.CONSULT_PRICE.getCode().equals(source) && OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
                SupplierInfo supplierInfo = this.supplierInfoMapper.selectByPrimaryKey(applyPayInfoPO.getSupplierId());
                if (null == supplierInfo) {
                    throw new BusinessException("1000", "t_supplier_info\u8868\u4e2d\u672a\u914d\u7f6e\u91c7\u8d2d\u5408\u540c");
                }
                itemVO.setCghtbh(supplierInfo.getEffectContactNo());
                supplierName = supplierInfo.getSupplierName();
                itemVO.setJsdw(applyPayInfoPO.getRecAcctName());
            }
            itemVO.setXshtbh("");
            itemVO.setXshtljskje(BigDecimal.ZERO);
            itemVO.setXshtljskbfb(BigDecimal.ZERO);
            itemVO.setCghtbhbh("");
            itemVO.setCghtbhje(BigDecimal.ZERO);
            itemVO.setCghtbhdqr("");
            itemVO.setCghtljfkje(BigDecimal.ZERO);
            itemVO.setCghtljfkbfb(BigDecimal.ZERO);
            itemVO.setCghtljbzjkkje(BigDecimal.ZERO);
            itemVO.setCghtye(BigDecimal.ZERO);
            itemVO.setKhh(applyPayInfoPO.getOpenBankName());
            itemVO.setYhzh(applyPayInfoPO.getReceiptAcctNo());
            itemVO.setFkxz(keyValue.get("\u4ed8\u6b3e\u6027\u8d28"));
            itemVO.setBcfkbfb(BigDecimal.ZERO);
            itemVO.setXj(BigDecimal.ZERO);
            itemVO.setYhck(BigDecimal.ZERO);
            itemVO.setPj(BigDecimal.ZERO);
            itemVO.setQthbzj(BigDecimal.ZERO);
            itemVO.setFkjebwb(applyDetail.getAmt());
            itemVO.setFkjermb(applyDetail.getAmt());
            itemVO.setHl(new BigDecimal(keyValue.get("\u6c47\u7387")));
            itemVO.setPjce(BigDecimal.ZERO);
            items.add(itemVO);
        }
        StringBuilder summary = new StringBuilder();
        if (OrderSource.ELECTRIC_AREA.getCode().equals(source) || OrderSource.COAL_AREA.getCode().equals(source) || OrderSource.CONSULT_PRICE.getCode().equals(source)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String purchaseOrderCode : purchaseOrderCodes) {
                stringBuilder.append(purchaseOrderCode).append(";");
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.deleteCharAt(stringBuilder.lastIndexOf(";"));
            }
            summary.append("\u4ed8").append(supplierName).append("\u6750\u6599\u6b3e(").append((CharSequence)stringBuilder).append(")");
        } else {
            summary.append("\u652f\u4ed8").append(supplierName).append("\u6750\u6599\u6b3e");
        }
        String summaryStr = summary.toString();
        summaryStr = FscStringUtils.cutStringByByte(summaryStr, "UTF-8", 200);
        reqBO.setSummary(summaryStr);
        LinkedList<BusiTransferApplyPayFileVO> attachItems = new LinkedList<BusiTransferApplyPayFileVO>();
        if ("1".equals(this.enumsService.querFileTransmitYuanGuangSwitch(source))) {
            double bytesTotalLen = 0.0;
            String subUrl = "/rest/download/busiExportApplyPayInfoController";
            HashMap<String, Object> urlParam = new HashMap<String, Object>();
            urlParam.put("id", billNo);
            urlParam.put("orgId", applyPayInfoPO.getCompanyId());
            urlParam.put("companyId", applyPayInfoPO.getCompanyId());
            Map<String, Object> fileInfoMap = FileUtils.getTransmitYuanGuangFileInfo(YuanGuangBillType.PAYMNET_APPROVAL_MATERIAL.getCode(), billNo, applyPayInfoPO.getCompanyId(), ".pdf", subUrl, urlParam, bytesTotalLen);
            if (((Boolean)fileInfoMap.get("transmit")).booleanValue()) {
                bytesTotalLen = (Double)fileInfoMap.get("bytesTotalLen");
                BusiTransferApplyPayFileVO fjxx = new BusiTransferApplyPayFileVO();
                fjxx.setName((String)fileInfoMap.get("name"));
                fjxx.setContent((String)fileInfoMap.get("content"));
                attachItems.add(fjxx);
            }
            logger.debug("\u4f20\u9001\u6587\u4ef6\u5b57\u8282\u957f\u5ea6:" + bytesTotalLen);
        }
        if (CollectionUtils.isEmpty(attachItems)) {
            BusiTransferApplyPayFileVO fjxx = new BusiTransferApplyPayFileVO();
            fjxx.setName("");
            fjxx.setContent("");
            attachItems.add(fjxx);
        }
        reqBO.setAttachItems(attachItems);
        BusiTransferApplyPayRspBO rspBO = this.busiTransferApplyPayService.transferApplyPay(reqBO);
        WFEventResult wfEventResult = new WFEventResult();
        if ("1".equals(rspBO.getResponeCode())) {
            wfEventResult.setSuccess(true);
        } else {
            wfEventResult.setSuccess(false);
        }
        wfEventResult.setRespCode(rspBO.getResponeCode());
        wfEventResult.setSsn(rspBO.getFinanceNo());
        wfEventResult.setRespDesc(rspBO.getRspMsg());
        return wfEventResult;
    }
}

