/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.FscWfStartAtomService;
import com.tydic.fsc.settle.atom.bo.FscWfStartAtomReqBO;
import com.tydic.fsc.settle.atom.bo.FscWfStartAtomRspBO;
import com.tydic.fsc.settle.constants.FscCommonConstants;
import com.tydic.fsc.settle.dao.WorkFlowDataMapper;
import com.tydic.fsc.settle.dao.WorkFlowParamMapper;
import com.tydic.fsc.settle.dao.po.WorkFlowDataInfo;
import com.tydic.fsc.settle.dao.po.WorkFlowParamInfo;
import com.tydic.fsc.settle.enums.WFStatus;
import com.tydic.fsc.settle.utils.FscCommonUtils;
import com.tydic.uac.ability.UacTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="fscWFStartAtomService")
public class FscWfStartAtomServiceImpl
implements FscWfStartAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscWfStartAtomServiceImpl.class);
    private UacTaskAuditCreateAbilityService uacTaskAuditCreateAbilityService;
    private WorkFlowParamMapper workFlowParamMapper;
    private WorkFlowDataMapper workFlowDataMapper;

    @Autowired
    private FscWfStartAtomServiceImpl(UacTaskAuditCreateAbilityService uacTaskAuditCreateAbilityService, WorkFlowParamMapper workFlowParamMapper, WorkFlowDataMapper workFlowDataMapper) {
        this.uacTaskAuditCreateAbilityService = uacTaskAuditCreateAbilityService;
        this.workFlowParamMapper = workFlowParamMapper;
        this.workFlowDataMapper = workFlowDataMapper;
    }

    @Override
    public FscWfStartAtomRspBO dealStartApproval(FscWfStartAtomReqBO reqBO) {
        FscWfStartAtomRspBO rspBO = new FscWfStartAtomRspBO();
        String validateArgStr = this.validateArg(reqBO);
        if (StringUtils.hasText((String)validateArgStr)) {
            rspBO.setRespCode("7777");
            rspBO.setRespDesc(validateArgStr);
            return rspBO;
        }
        WorkFlowParamInfo workFlowParamInfo = new WorkFlowParamInfo();
        workFlowParamInfo.setBillType(reqBO.getBillType().getCode());
        WorkFlowParamInfo paramInfo = this.workFlowParamMapper.getModelBy(workFlowParamInfo);
        if (null == paramInfo) {
            LOGGER.info("\u5de5\u4f5c\u6d41\u53c2\u6570\u8868\u65e0\u5355\u636e\u7c7b\u578b" + (Object)((Object)reqBO.getBillType()) + "\u76f8\u5e94\u7684\u6570\u636e\u8bb0\u5f55");
            throw new BusinessException("5001", "\u5de5\u4f5c\u6d41\u53c2\u6570\u8868\u672a\u914d\u7f6e\u6d41\u7a0b\u53c2\u6570");
        }
        UacTaskAuditCreateRspBO auditCreateRspBO = this.callAuditCreate(paramInfo, reqBO);
        if (!"0000".equals(auditCreateRspBO.getRespCode())) {
            LOGGER.error("\u542f\u52a8\u5ba1\u6279\u6d41\u7a0b\u5931\u8d25" + auditCreateRspBO.getRespDesc());
            throw new BusinessException("5001", "\u542f\u52a8\u5ba1\u6279\u6d41\u7a0b\u5931\u8d25" + auditCreateRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)auditCreateRspBO.getTaskList())) {
            LOGGER.error("\u542f\u52a8\u5ba1\u6279\u6d41\u7a0b\u5931\u8d25, \u9700\u8981\u5ba1\u6279\u7684\u6d41\u7a0b\u6ca1\u6709\u8fd4\u56de\u4efb\u52a1\u4fe1\u606f\u5217\u8868");
            throw new BusinessException("5001", "\u542f\u52a8\u5ba1\u6279\u6d41\u7a0b\u5931\u8d25");
        }
        this.insertWorkFlowData(reqBO, auditCreateRspBO.getOrderId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5ba1\u6279\u6d41\u7a0b\u542f\u52a8\u6210\u529f");
        return rspBO;
    }

    private UacTaskAuditCreateRspBO callAuditCreate(WorkFlowParamInfo paramInfo, FscWfStartAtomReqBO reqBO) {
        UacTaskAuditCreateReqBO auditCreateReqBO = new UacTaskAuditCreateReqBO();
        auditCreateReqBO.setObjType("09");
        auditCreateReqBO.setBusiCode(paramInfo.getBusinessType());
        ArrayList<ApprovalObjBO> approvalObjBOList = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(reqBO.getBillNo());
        approvalObjBOList.add(approvalObjBO);
        auditCreateReqBO.setApprovalObjInfo(approvalObjBOList);
        auditCreateReqBO.setObjNum(FscCommonUtils.integer2String((Integer)approvalObjBOList.size()));
        auditCreateReqBO.setCreateOperId(null == reqBO.getUserId() ? null : FscCommonUtils.long2String((Long)reqBO.getUserId()));
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("deptId", "dept_start");
        map.put("tacheCode", "tache_start");
        map.put("roleId", "station_start");
        auditCreateReqBO.setParamMap(map);
        return this.uacTaskAuditCreateAbilityService.auditOrderCreate(auditCreateReqBO);
    }

    private void insertWorkFlowData(FscWfStartAtomReqBO reqBO, Long orderId) {
        Date date = new Date();
        WorkFlowDataInfo workFlowDataInfo = new WorkFlowDataInfo();
        workFlowDataInfo.setProcInstId(FscCommonUtils.long2String((Long)orderId));
        workFlowDataInfo.setBillType(reqBO.getBillType().getCode());
        workFlowDataInfo.setBillNo(reqBO.getBillNo());
        workFlowDataInfo.setReceiveDate(date);
        workFlowDataInfo.setLastOperator(reqBO.getUserId());
        workFlowDataInfo.setStatus(WFStatus.IN_THE_AUDIT.getCode());
        workFlowDataInfo.setFinishEvtService(reqBO.getFinishEvtServiceId());
        workFlowDataInfo.setTryCount(FscCommonConstants.APPROVAL_TRY_COUNT);
        workFlowDataInfo.setApplyDate(date);
        this.workFlowDataMapper.insert(workFlowDataInfo);
    }

    private String validateArg(FscWfStartAtomReqBO reqBO) {
        if (null == reqBO) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBO.getBillNo())) {
            return "\u5355\u636e\u7f16\u53f7[billNo]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBO.getBillType()) {
            return "\u5355\u636e\u7c7b\u578b[billType]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

