/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.SequenceNoService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SequenceNoServiceImpl
implements SequenceNoService {
    private static final Log LOGGER = LogFactory.getLog(SequenceNoServiceImpl.class);
    @Autowired
    private DataSource dataSource;
    private String tableName = "ohaotian_order_sequence";
    private String fieldsName = "name,current_value,step";
    private String seqName;
    private String seqNameField = "name";
    private String seqField = "current_value";
    private Integer bufferSize = 1;
    private Integer incStep = 1;
    private Long startSeqNo = 1L;
    private Long maxSeqNo = -1L;
    private String resetType = "Y";
    private Long seqNo = 0L;
    private Long bufMaxSeqNo = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long generateSeqNo() {
        long result = -1L;
        String fail = "";
        SequenceNoServiceImpl sequenceNoServiceImpl = this;
        synchronized (sequenceNoServiceImpl) {
            if (this.seqNo > this.bufMaxSeqNo) {
                for (int i = 0; i < 3; ++i) {
                    Connection conn = this.getConn();
                    if (conn != null) {
                        try {
                            result = this.selectNewSeqNo(conn);
                            if (result == -1L) {
                                fail = ",\u65e0\u6cd5\u83b7\u53d6\u6709\u6548\u7684\u5e8f\u53f7";
                                LOGGER.warn((Object)("\u7b2c" + (i + 1) + "\u6b21\u5c1d\u8bd5\u4ea7\u751f\u5e8f\u5217\u53f7" + this.seqName + "\u5931\u8d25," + fail));
                                continue;
                            }
                            break;
                        }
                        finally {
                            this.closeConnection(conn);
                        }
                    }
                    fail = ",\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25";
                    LOGGER.warn((Object)("\u7b2c" + (i + 1) + "\u6b21\u5c1d\u8bd5\u4ea7\u751f\u5e8f\u5217\u53f7" + this.seqName + "\u5931\u8d25," + fail));
                }
            } else {
                result = this.seqNo;
            }
            this.seqNo = this.seqNo + (long)this.incStep.intValue();
        }
        if (result == -1L) {
            throw new BusinessException("1000", "\u4ea7\u751f\u5e8f\u5217\u53f7\u5931\u8d25" + fail);
        }
        return result;
    }

    @Override
    public String generateSeqNoFormated(int length, String prefix) {
        prefix = StringUtils.hasText((String)prefix) ? prefix : "";
        int lengthWithoutPrefix = length - prefix.length();
        String withoutPrefix = String.format("%0" + lengthWithoutPrefix + "d", this.generateSeqNo());
        return prefix + withoutPrefix;
    }

    @Override
    public long getCurrentSeqNo() {
        long sn = -1L;
        Connection conn = this.getConn();
        if (conn != null) {
            sn = this.getCurrentSeqNo(conn);
            this.closeConnection(conn);
        }
        return sn;
    }

    public void init() {
        LOGGER.info((Object)("-----[Sequence Service init process--[" + this.seqName + "]-----"));
        Connection conn = this.getConn();
        if (conn != null) {
            long nowSeqNo = this.getCurrentSeqNo(conn);
            if (nowSeqNo < 0L) {
                int cnt = this.doInsert(conn);
                LOGGER.info((Object)("-----[Sequence Service [" + this.seqName + "] init,not found [" + this.seqName + "]sequeue row,insert=" + cnt));
            } else {
                LOGGER.info((Object)("-----[Sequence Service [" + this.seqName + "] init,current seqNo=" + nowSeqNo));
            }
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getCurrentSeqNo(Connection conn) {
        String sql = "select " + this.fieldsName + " from " + this.tableName + " where NAME=?";
        long result = -1L;
        PreparedStatement pstm = this.getPreparedStatement(conn, sql);
        if (pstm == null) {
            return result;
        }
        ResultSet resultSet = null;
        try {
            pstm.setString(1, this.seqName);
            resultSet = pstm.executeQuery();
            if (resultSet.next()) {
                result = resultSet.getLong(2);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Sequence Service select [" + this.seqName + "] current seqNo failed," + e.getMessage()), (Throwable)e);
        }
        finally {
            if (pstm != null) {
                try {
                    pstm.close();
                }
                catch (SQLException e) {
                    LOGGER.error((Object)"\u5173\u95edPreparedStatement\u5f02\u5e38\uff0c", (Throwable)e);
                }
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    LOGGER.error((Object)"\u5173\u95edresultSet\u5f02\u5e38\uff0c", (Throwable)e);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long selectNewSeqNo(Connection conn) {
        long result = -1L;
        String sql = "select " + this.fieldsName + " from " + this.tableName + " where NAME=? for update";
        PreparedStatement pstm = this.getPreparedStatement(conn, sql);
        ResultSet resultSet = null;
        try {
            pstm.setString(1, this.seqName);
            resultSet = pstm.executeQuery();
            if (resultSet.next()) {
                result = resultSet.getLong(2);
                this.seqNo = result;
                this.bufMaxSeqNo = this.seqNo + (long)this.bufferSize.intValue() - 1L;
                int step = resultSet.getInt(3);
                long nextNo = this.bufMaxSeqNo + (long)step;
                if (this.maxSeqNo != -1L && nextNo > this.maxSeqNo) {
                    nextNo = 1L;
                }
                int updateCnt = this.doUpdate(conn, result, nextNo);
                LOGGER.info((Object)("-----[Sequence Service [" + this.seqName + "] generate number,currentNo=" + result + ",nextNo=" + nextNo + ",updateSuccess=" + updateCnt));
                if (updateCnt == 0) {
                    result = -1L;
                }
            } else {
                int cnt = this.doInsert(conn);
                LOGGER.info((Object)("-----[Sequence Service generate number,not found [" + this.seqName + "] seq,Insert=" + cnt));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Sequence Service select " + this.seqName + " seqno for update error," + e.getMessage()), (Throwable)e);
        }
        finally {
            if (pstm != null) {
                try {
                    pstm.close();
                }
                catch (SQLException e) {
                    LOGGER.error((Object)"\u5173\u95edPreparedStatement\u5f02\u5e38\uff0c", (Throwable)e);
                }
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    LOGGER.error((Object)"\u5173\u95edresultSet\u5f02\u5e38\uff0c", (Throwable)e);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doUpdate(Connection conn, long oldSeqNo, long newSeqNo) {
        int result = 0;
        String sql = "update " + this.tableName + " set " + this.seqField + "=? where " + this.seqNameField + "=? and " + this.seqField + "=?";
        PreparedStatement pstm = this.getPreparedStatement(conn, sql);
        try {
            pstm.setLong(1, newSeqNo);
            pstm.setString(2, this.seqName);
            pstm.setLong(3, oldSeqNo);
            result = pstm.executeUpdate();
            LOGGER.info((Object)"");
            if (result == 0) {
                // empty if block
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)("Sequence Service [" + this.seqName + "] Update sequence record failed:" + e.getMessage()), (Throwable)e);
        }
        finally {
            if (pstm != null) {
                try {
                    pstm.close();
                }
                catch (SQLException e) {
                    LOGGER.error((Object)("close PreparedStatement failed:" + e.getMessage()), (Throwable)e);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doInsert(Connection conn) {
        int result = 0;
        String sql = "insert into " + this.tableName + "(" + this.fieldsName + ") values (?,?,?) ";
        PreparedStatement pstm = this.getPreparedStatement(conn, sql);
        try {
            pstm.setString(1, this.seqName);
            pstm.setLong(2, this.startSeqNo);
            pstm.setInt(3, this.incStep);
            result = pstm.executeUpdate();
            LOGGER.info((Object)("-----[Sequence Service [" + this.seqName + "] ,create sequence row,seqName=" + this.seqName + ",success=" + result));
        }
        catch (SQLException e) {
            LOGGER.error((Object)("Sequence Service [" + this.seqName + "] Insert sequence record failed:" + e.getMessage()), (Throwable)e);
        }
        finally {
            if (pstm != null) {
                try {
                    pstm.close();
                }
                catch (SQLException e) {
                    LOGGER.error((Object)"\u5173\u95edPreparedStatement\u5f02\u5e38\uff0c", (Throwable)e);
                }
            }
        }
        return result;
    }

    protected Connection getConn() {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            LOGGER.error((Object)("Sequence Service [" + this.seqName + "] get connection failed:" + e.getMessage()), (Throwable)e);
        }
        return connection;
    }

    protected void closeConnection(Connection conn, boolean rollBack) {
        try {
            if (rollBack) {
                conn.rollback();
            } else {
                conn.commit();
            }
        }
        catch (SQLException e1) {
            LOGGER.error((Object)("Sequence Service [" + this.seqName + "] commit/rollback(" + rollBack + ") failed:" + e1.getMessage()), (Throwable)e1);
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            LOGGER.error((Object)"\u5173\u95edConnection\u5f02\u5e38\uff0c", (Throwable)e);
        }
    }

    protected void closeConnection(Connection conn) {
        this.closeConnection(conn, false);
    }

    protected Statement getStatement(Connection conn) {
        Statement statement = null;
        try {
            statement = conn.createStatement();
        }
        catch (SQLException e) {
            LOGGER.error((Object)("Sequence Service [" + this.seqName + "] get Statement failed:" + e.getMessage()), (Throwable)e);
        }
        return statement;
    }

    protected void closeStatement(Statement stm) {
        try {
            stm.close();
        }
        catch (SQLException e) {
            LOGGER.error((Object)"\u5173\u95edStatement\u5f02\u5e38\uff0c", (Throwable)e);
        }
    }

    protected PreparedStatement getPreparedStatement(Connection conn, String sql) {
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement(sql);
        }
        catch (SQLException e) {
            LOGGER.error((Object)("Sequence Service [" + this.seqName + "] get PreparedStatement failed:" + e.getMessage()), (Throwable)e);
        }
        return statement;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getFieldsName() {
        return this.fieldsName;
    }

    public void setFieldsName(String fieldsName) {
        this.fieldsName = fieldsName;
    }

    public String getSeqName() {
        return this.seqName;
    }

    public void setSeqName(String seqName) {
        this.seqName = seqName;
    }

    public Integer getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(Integer bufferSize) {
        if (bufferSize == null || bufferSize < 1) {
            bufferSize = 1;
        }
        this.bufferSize = bufferSize;
    }

    public String getResetType() {
        return this.resetType;
    }

    public void setResetType(String resetType) {
        this.resetType = resetType;
    }

    public String getSeqNameField() {
        return this.seqNameField;
    }

    public void setSeqNameField(String seqNameField) {
        this.seqNameField = seqNameField;
    }

    public String getSeqField() {
        return this.seqField;
    }

    public void setSeqField(String seqField) {
        this.seqField = seqField;
    }

    public Integer getIncStep() {
        return this.incStep;
    }

    public void setIncStep(Integer incStep) {
        if (incStep == null || incStep < 1) {
            incStep = 1;
        }
        this.incStep = incStep;
    }

    public Long getStartSeqNo() {
        return this.startSeqNo;
    }

    public void setStartSeqNo(Long startSeqNo) {
        if (startSeqNo == null || startSeqNo < 1L) {
            startSeqNo = 1L;
        }
        this.startSeqNo = startSeqNo;
    }

    public Long getMaxSeqNo() {
        return this.maxSeqNo;
    }

    public void setMaxSeqNo(Long maxSeqNo) {
        this.maxSeqNo = maxSeqNo;
    }
}

