/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.BusiAddBillPrechooseService;
import com.tydic.fsc.settle.busi.api.bo.BusiAddBillPrechooseReqBO;
import com.tydic.fsc.settle.dao.BillPrechooseMapper;
import com.tydic.fsc.settle.dao.InquiryPayOrderMapper;
import com.tydic.fsc.settle.dao.po.BillPrechoose;
import com.tydic.fsc.settle.dao.po.InquiryPayOrder;
import com.tydic.fsc.settle.dao.po.InquiryPayOrderExt;
import com.tydic.fsc.settle.enums.InquiryPaymentStatus;
import com.tydic.fsc.settle.enums.YesNo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiAddBillPrechooseServiceImpl
implements BusiAddBillPrechooseService {
    private static final Logger logger = LoggerFactory.getLogger(BusiAddBillPrechooseServiceImpl.class);
    @Autowired
    private BillPrechooseMapper billPrechooseMapper;
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;

    public FscBaseRspBo add(BusiAddBillPrechooseReqBO reqBO) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("\u65b0\u589e\u53d1\u7968\u9884\u9009\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getOrderId())) {
            throw new BusinessException("1001", "\u7f34\u8d39\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getBillId() == null || reqBO.getBillId() <= 0L) {
            throw new BusinessException("1001", "\u53d1\u7968\u62ac\u5934ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getAddrId() == null || reqBO.getAddrId() <= 0L) {
            throw new BusinessException("1001", "\u5730\u5740ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getInvoiceClasses())) {
            throw new BusinessException("1001", "\u53d1\u7968\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getInvoiceType())) {
            throw new BusinessException("1001", "\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillPrechoose checkBillPrechoose = this.billPrechooseMapper.selectByPrimaryKey(reqBO.getOrderId());
        InquiryPayOrder inquiryPayOrder = null;
        if (null != checkBillPrechoose) {
            InquiryPayOrderExt inquiryPayOrderExt = new InquiryPayOrderExt();
            inquiryPayOrderExt.setPayOrderNo(checkBillPrechoose.getOrderId());
            inquiryPayOrder = this.inquiryPayOrderMapper.selectByPrimaryKey(inquiryPayOrderExt);
        }
        if (null != checkBillPrechoose && null != inquiryPayOrder && InquiryPaymentStatus.NO_PAYMENT.getCode().equals(inquiryPayOrder.getPaymentStatus())) {
            this.billPrechooseMapper.deleteByPrimaryKey(reqBO.getOrderId());
        }
        BillPrechoose billPrechoose = new BillPrechoose();
        BeanUtils.copyProperties((Object)reqBO, (Object)billPrechoose);
        billPrechoose.setUseFlag(YesNo.NO.getCode());
        this.billPrechooseMapper.insert(billPrechoose);
        return new FscBaseRspBo();
    }
}

