/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.dao.SaleInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.SaleInvoiceMailInfoMapper;
import com.tydic.fsc.settle.dao.po.SaleInvoiceInfo;
import com.tydic.fsc.settle.dao.po.SaleInvoiceMailInfo;
import com.tydic.fsc.settle.dao.vo.SaleInvoiceInfoVO;
import com.tydic.fsc.settle.enums.InvoiceMailSentStatus;
import com.tydic.fsc.settle.utils.BeanFactory;
import com.tydic.fsc.supplier.BusiJdExpressService;
import com.tydic.fsc.supplier.bo.JdexpressTokenVO;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class BusiApplyMailForInvoiceRunnable
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(BusiApplyMailForInvoiceRunnable.class);
    private String mailTicketNo;
    private JdexpressTokenVO jdToken;
    private CountDownLatch latch;

    @Override
    public void run() {
        try {
            this.process();
        }
        catch (Exception e) {
            logger.error("\u90ae\u5bc4\u5931\u8d25\u3002\u5feb\u9012\u5355\u53f7\uff1a" + this.mailTicketNo, (Throwable)e);
            throw new BusinessException("1002", "\u90ae\u5bc4\u5931\u8d25\u3002\u5feb\u9012\u5355\u53f7\uff1a" + this.mailTicketNo);
        }
        finally {
            this.latch.countDown();
        }
    }

    private void process() {
        SaleInvoiceMailInfoMapper saleInvoiceMailInfoMapper = (SaleInvoiceMailInfoMapper)BeanFactory.getBean("saleInvoiceMailInfoMapper");
        SaleInvoiceInfoMapper saleInvoiceInfoMapper = (SaleInvoiceInfoMapper)BeanFactory.getBean("saleInvoiceInfoMapper");
        BusiJdExpressService busiJdExpressService = (BusiJdExpressService)BeanFactory.getBean("busiJdExpressService");
        SaleInvoiceMailInfo mailInfo = saleInvoiceMailInfoMapper.selectByPrimaryKey(this.mailTicketNo);
        SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
        saleInvoiceInfoVO.setMailTicketNo(this.mailTicketNo);
        List<SaleInvoiceInfo> invoices = saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
        String jdRangeCheckResult = busiJdExpressService.rangeCheck(this.mailTicketNo, mailInfo.getAddress(), this.jdToken);
        String resultCode = jdRangeCheckResult.split("-")[0];
        String resultMsg = jdRangeCheckResult.split("-")[1];
        SaleInvoiceMailInfo record = new SaleInvoiceMailInfo();
        record.setMailTicketNo(this.mailTicketNo);
        record.setJdAssignStatus(resultCode);
        record.setFailReason(resultMsg);
        saleInvoiceMailInfoMapper.updateByPrimaryKeySelective(record);
        int mailNum = invoices.size();
        BigDecimal totalAmt = BigDecimal.ZERO;
        for (SaleInvoiceInfo invoice : invoices) {
            totalAmt = totalAmt.add(invoice.getAmt());
        }
        String remark = "\u53d1\u7968" + mailNum + "\u5f20\uff0c\u5408\u8ba1\u91d1\u989d" + totalAmt + "\u5143";
        try {
            busiJdExpressService.sendBill(this.mailTicketNo, this.mailTicketNo, mailInfo.getSender(), mailInfo.getSenderAddress(), mailInfo.getSenderTel(), mailInfo.getReceiver(), mailInfo.getAddress(), mailInfo.getTel(), remark, this.jdToken);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u4eac\u4e1c\u90ae\u5bc4\u63a5\u53e3\u5931\u8d25\u3002\u5feb\u9012\u5355\u53f7\uff1a" + this.mailTicketNo, (Throwable)e);
            record = new SaleInvoiceMailInfo();
            record.setMailTicketNo(this.mailTicketNo);
            record.setMailStatus(InvoiceMailSentStatus.SENT_FAIL.getCode());
            String failReason = e.getMessage();
            if (StringUtils.hasText((String)failReason) && failReason.length() > 300) {
                failReason = failReason.substring(0, 300);
            }
            record.setFailReason(failReason);
            saleInvoiceMailInfoMapper.updateByMailTicketNo(record);
            return;
        }
        record = new SaleInvoiceMailInfo();
        record.setMailTicketNo(this.mailTicketNo);
        record.setMailStatus(InvoiceMailSentStatus.SENT_SUCCESS.getCode());
        record.setFailReason(null);
        saleInvoiceMailInfoMapper.updateByMailTicketNo(record);
    }

    public String getMailTicketNo() {
        return this.mailTicketNo;
    }

    public void setMailTicketNo(String mailTicketNo) {
        this.mailTicketNo = mailTicketNo;
    }

    public JdexpressTokenVO getJdToken() {
        return this.jdToken;
    }

    void setJdToken(JdexpressTokenVO jdToken) {
        this.jdToken = jdToken;
    }

    public CountDownLatch getLatch() {
        return this.latch;
    }

    void setLatch(CountDownLatch latch) {
        this.latch = latch;
    }
}

