/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.busi.api.BusiBillApplyCheckXbjService;
import com.tydic.fsc.settle.busi.api.bo.BusiBillApplyCheckXbjReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiBillApplyCheckXbjRspBO;
import com.tydic.fsc.settle.dao.InquiryPayOrderMapper;
import com.tydic.fsc.settle.dao.po.InquiryPayOrder;
import com.tydic.fsc.settle.enums.InquiryPaymentStatus;
import com.tydic.fsc.settle.enums.OrderStatus;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiBillApplyCheckXbjServiceImpl
implements BusiBillApplyCheckXbjService {
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;
    @Autowired
    private EnumsService enumsService;

    public BusiBillApplyCheckXbjRspBO billApplyCheck(BusiBillApplyCheckXbjReqBO reqBO) {
        List payOrderNos = reqBO.getPayOrderNos();
        if (payOrderNos == null || payOrderNos.isEmpty()) {
            throw new BusinessException("1001", "\u5165\u53c2\u7f34\u8d39\u8ba2\u5355\u53f7\u3010payOrderNos\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiBillApplyCheckXbjRspBO rspBO = new BusiBillApplyCheckXbjRspBO();
        List<InquiryPayOrder> list = this.inquiryPayOrderMapper.selectByPayOrderNos(payOrderNos);
        HashSet<Long> operUnitSet = new HashSet<Long>();
        Long supplierId = null;
        for (InquiryPayOrder inquiryPayOrder : list) {
            if (!OrderStatus.NO_APPLY.getCode().equals(inquiryPayOrder.getOrderStatus())) {
                throw new BusinessException("1002", "\u5f00\u7968\u72b6\u6001\u4e3a" + this.enumsService.getDescr(OrderStatus.NO_APPLY) + "\u7684\u8ba2\u5355\u624d\u80fd\u7533\u8bf7\u5f00\u7968");
            }
            if (!(InquiryPaymentStatus.OFFLINE_PAID.getCode().equals(inquiryPayOrder.getPaymentStatus()) || InquiryPaymentStatus.CHECK_SUCCEED.getCode().equals(inquiryPayOrder.getPaymentStatus()) || InquiryPaymentStatus.REC_CONFIRMED.getCode().equals(inquiryPayOrder.getPaymentStatus()))) {
                throw new BusinessException("1002", "\u6536\u6b3e\u72b6\u6001\u4e3a" + this.enumsService.getDescr(InquiryPaymentStatus.OFFLINE_PAID) + "\u3001" + this.enumsService.getDescr(InquiryPaymentStatus.CHECK_SUCCEED) + "\u3001" + this.enumsService.getDescr(InquiryPaymentStatus.REC_CONFIRMED) + "\u7684\u8ba2\u5355\u624d\u80fd\u7533\u8bf7\u5f00\u7968");
            }
            operUnitSet.add(inquiryPayOrder.getOperUnitNo());
            if (supplierId == null) {
                supplierId = inquiryPayOrder.getSupplierId();
            } else if (!supplierId.equals(inquiryPayOrder.getSupplierId())) {
                throw new BusinessException("1002", "\u4e0d\u540c\u4f9b\u5e94\u5546\u7684\u8ba2\u5355\u4e0d\u80fd\u5408\u5e76\u5f00\u7968");
            }
            rspBO.setOperUnitNo(inquiryPayOrder.getOperUnitNo());
        }
        if (1 != operUnitSet.size()) {
            throw new BusinessException("1002", "\u4e0d\u540c\u4e13\u4e1a\u516c\u53f8\u7684\u8ba2\u5355\u4e0d\u80fd\u5408\u5e76\u5f00\u7968");
        }
        return rspBO;
    }
}

