/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.AccountantEngineService;
import com.tydic.fsc.settle.atom.SubAccountService;
import com.tydic.fsc.settle.atom.bo.AccountantEngineReqBO;
import com.tydic.fsc.settle.base.PayBaseService;
import com.tydic.fsc.settle.bo.FscBaseReqBo;
import com.tydic.fsc.settle.busi.api.BusiOrderRefundService;
import com.tydic.fsc.settle.busi.api.bo.BusiOrderRefundReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiOrderRefundRspBO;
import com.tydic.fsc.settle.busi.api.bo.SubAcctInfoExt;
import com.tydic.fsc.settle.dao.TranDetailMapper;
import com.tydic.fsc.settle.dao.po.TranDetail;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiOrderRefundServiceImpl
extends PayBaseService<BusiOrderRefundRspBO>
implements BusiOrderRefundService {
    private static final Logger logger = LoggerFactory.getLogger(BusiOrderRefundServiceImpl.class);
    @Autowired
    private TranDetailMapper tranDetailMapper;
    @Autowired
    private AccountantEngineService accEngineService;
    @Autowired
    private SubAccountService subAccountService;

    public BusiOrderRefundRspBO makingOrderRefund(BusiOrderRefundReqBO reqBO) {
        BusiOrderRefundRspBO rspBO = (BusiOrderRefundRspBO)this.queryRspOrSaveLog((FscBaseReqBo)reqBO);
        if (rspBO != null) {
            return rspBO;
        }
        try {
            rspBO = this.process(reqBO);
        }
        catch (Exception e) {
            logger.error("\u5931\u8d25", (Throwable)e);
            this.updateLog((FscBaseReqBo)reqBO, e);
            throw new BusinessException("1002", e.getMessage());
        }
        this.updateLog((FscBaseReqBo)reqBO, rspBO);
        return rspBO;
    }

    public BusiOrderRefundRspBO process(BusiOrderRefundReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u8ba2\u5355\u9000\u6b3e\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (null == reqBO.getOrderNo()) {
            throw new BusinessException("1001", "\u8ba2\u5355\u9000\u6b3e\u670d\u52a1-\u9500\u552e\u8ba2\u5355ID[orderNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSaleOrderCode()) {
            throw new BusinessException("1001", "\u8ba2\u5355\u9000\u6b3e\u670d\u52a1-\u9500\u552e\u8ba2\u5355\u7f16\u53f7[saleOrderCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getBusinessType()) {
            throw new BusinessException("1001", "\u8ba2\u5355\u9000\u6b3e\u670d\u52a1\u7c7b\u578b[businessType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperatingUnitNo()) {
            throw new BusinessException("1001", "\u8ba2\u5355\u9000\u6b3e\u670d\u52a1-\u8fd0\u8425\u673a\u6784\u7f16\u53f7[operatingUnitNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSource()) {
            throw new BusinessException("1001", "\u8ba2\u5355\u9000\u6b3e\u670d\u52a1-\u6765\u6e90[source]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPurchaseUnitNo()) {
            throw new BusinessException("1001", "\u8ba2\u5355\u9000\u6b3e\u670d\u52a1-\u91c7\u8d2d\u5355\u4f4d\u7f16\u53f7[purchaseUnitNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPurchaseBookNo()) {
            throw new BusinessException("1001", "\u8ba2\u5355\u9000\u6b3e\u670d\u52a1-\u91c7\u8d2d\u5355\u4f4d\u5e10\u5957\u7f16\u53f7[purchaseBookNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getRefundAmt()) {
            throw new BusinessException("1001", "\u8ba2\u5355\u9000\u6b3e\u670d\u52a1-\u9000\u6b3e\u91d1\u989d[refundAmt]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getTxnNo()) {
            throw new BusinessException("1001", "\u8ba2\u5355\u9000\u6b3e\u670d\u52a1-\u539f\u4ea4\u6613\u6d41\u6c34\u53f7[txnNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String serviceNo = reqBO.getSaleOrderCode();
        SubAcctInfoExt subAcctInfo = this.subAccountService.getWithMainAccount(reqBO.getOperatingUnitNo(), reqBO.getSource(), reqBO.getPurchaseUnitNo(), reqBO.getPurchaseBookNo(), null);
        if (subAcctInfo == null) {
            logger.error("\u627e\u4e0d\u5230\u91c7\u8d2d\u5355\u4f4d\u8d26\u6237\u3002\u8ba2\u5355\u9000\u6b3e\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
            throw new BusinessException("1000", "\u627e\u4e0d\u5230\u91c7\u8d2d\u5355\u4f4d\u8d26\u6237");
        }
        BigDecimal totalPayAmt = BigDecimal.ZERO;
        BigDecimal totalRefundAmt = BigDecimal.ZERO;
        List<TranDetail> tranDetails = this.tranDetailMapper.selectByBusiTypeAndServiceNo(null, serviceNo);
        for (TranDetail tranDetail : tranDetails) {
            if (subAcctInfo.getSubAcctNo().equals(tranDetail.getPayAcctNo())) {
                totalPayAmt = totalPayAmt.add(tranDetail.getTranAmt());
                continue;
            }
            if (!subAcctInfo.getSubAcctNo().equals(tranDetail.getRecvAcctNo())) continue;
            totalRefundAmt = totalRefundAmt.add(tranDetail.getTranAmt());
        }
        if (totalPayAmt.subtract(totalRefundAmt).compareTo(reqBO.getRefundAmt()) < 0) {
            throw new BusinessException("1002", "\u53ef\u9000\u91d1\u989d\u4e0d\u8db3\uff1a\u672c\u6b21\u9000\u6b3e\u91d1\u989d" + reqBO.getRefundAmt() + "\u5927\u4e8e\u5269\u4f59\u53ef\u9000\u6b3e\u989d\u5ea6" + totalPayAmt.subtract(totalRefundAmt));
        }
        AccountantEngineReqBO accEngineReqBO = new AccountantEngineReqBO();
        accEngineReqBO.setBusinessType(String.valueOf(reqBO.getBusinessType()));
        accEngineReqBO.setClientAcctNo(subAcctInfo.getSubAcctNo());
        accEngineReqBO.setSource(reqBO.getSource());
        accEngineReqBO.setOperUnit(reqBO.getOperatingUnitNo());
        accEngineReqBO.setProjectId(reqBO.getProjectId());
        LinkedList<BigDecimal> amounts = new LinkedList<BigDecimal>();
        amounts.add(reqBO.getRefundAmt());
        accEngineReqBO.setAmounts(amounts);
        accEngineReqBO.setServiceNo(serviceNo);
        accEngineReqBO.setOrgId(reqBO.getPurchaseUnitNo());
        List<Long> txnNo = null;
        try {
            txnNo = this.accEngineService.executeAccountantEngine(accEngineReqBO);
        }
        catch (Exception e) {
            logger.error("\u8ba2\u5355\u9000\u6b3e\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u8ba2\u5355\u9000\u6b3e\u670d\u52a1\u5f02\u5e38\u3002" + e.getMessage());
        }
        BusiOrderRefundRspBO bo = new BusiOrderRefundRspBO();
        bo.setTxnNo(String.valueOf(txnNo.get(0)));
        bo.setIsSuccess(Boolean.valueOf(true));
        return bo;
    }

    @Override
    protected BusiOrderRefundRspBO fillRspBO(String respPackage) {
        BusiOrderRefundRspBO rspBO = new BusiOrderRefundRspBO();
        JSONObject jsonObject = JSONObject.fromObject((Object)respPackage);
        rspBO.setRespCode(jsonObject.containsKey((Object)"respCode") ? jsonObject.getString("respCode") : null);
        rspBO.setRespDesc(jsonObject.containsKey((Object)"respDesc") ? jsonObject.getString("respDesc") : null);
        rspBO.setTxnNo(jsonObject.containsKey((Object)"txnNo") ? jsonObject.getString("txnNo") : null);
        rspBO.setIsSuccess(jsonObject.containsKey((Object)"isSuccess") ? Boolean.valueOf(jsonObject.getString("isSuccess")) : null);
        return rspBO;
    }
}

