/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.UserInfoService;
import com.tydic.fsc.settle.busi.api.BusiQueryBillApplyInfoService;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryBillApplyInfoDetailRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryBillApplyInfoReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryBillApplyInfoRspBO;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.SaleInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.po.SaleInvoiceInfo;
import com.tydic.fsc.settle.dao.vo.BillApplyInfoVO;
import com.tydic.fsc.settle.dao.vo.SaleInvoiceInfoVO;
import com.tydic.fsc.settle.enums.BaseEnums;
import com.tydic.fsc.settle.enums.BillStatus;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.SaleInvoiceInfoInvoiceStatus;
import com.tydic.fsc.supplier.bo.ProjectInfoBO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiQueryBillApplyInfoServiceImpl
implements BusiQueryBillApplyInfoService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQueryBillApplyInfoServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private UserInfoService userInfoService;

    public BusiQueryBillApplyInfoRspBO query(BusiQueryBillApplyInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u670d\u52a1(\u7535\u5b50\u8d85\u5e02)(\u4e13\u4e1a\u516c\u53f8\u548c\u91c7\u8d2d\u5355\u4f4d\u5171\u7528)\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getIsOperUnit())) {
            throw new BusinessException("8888", "\u662f\u5426\u4e13\u4e1a\u516c\u53f8\u7528\u6237\u3010isOperUnit\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("0".equals(reqBO.getIsOperUnit()) && reqBO.getPurchaseProjectId() == null) {
            throw new BusinessException("8888", "\u91c7\u8d2d\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)billApplyInfoVO);
        billApplyInfoVO.setReturnBillNoIsNull("1");
        billApplyInfoVO.setSource(OrderSource.ELECTRIC_MARKET.getCode());
        try {
            if (null != reqBO.getUserNameLike() && StringUtils.hasText((String)reqBO.getUserNameLike())) {
                List<Long> userIdList = this.userInfoService.queryUserIdListByUserNameLike(reqBO.getUserNameLike());
                if (userIdList.isEmpty()) {
                    userIdList.add(-1L);
                }
                billApplyInfoVO.setUserIdList(userIdList);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new BusinessException("8888", "\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u3010UmcQryMemByManagementAbilityService\u3011\u63a5\u53e3\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        if ("1".equals(reqBO.getIsOperUnit())) {
            billApplyInfoVO.setOperUnitNo(reqBO.getCompanyId());
        }
        if (billApplyInfoVO.getApplyDateEnd() != null) {
            try {
                String applyDateEndString = new SimpleDateFormat("yyyy-MM-dd").format(billApplyInfoVO.getApplyDateEnd()) + " 23:59:59";
                billApplyInfoVO.setApplyDateEnd(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(applyDateEndString));
            }
            catch (ParseException e) {
                throw new BusinessException("8888", "\u683c\u5f0f\u5316\u65e5\u671f\u51fa\u9519");
            }
        }
        billApplyInfoVO.setOrderBy("t.APPLY_NO DESC");
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<BillApplyInfo> billApplyInfoList = null;
        billApplyInfoList = StringUtils.isEmpty((Object)reqBO.getInvoiceNoStart()) && StringUtils.isEmpty((Object)reqBO.getInvoiceNoEnd()) && reqBO.getInvoiceDateStart() == null && reqBO.getInvoiceDateEnd() == null ? this.billApplyInfoMapper.getListPage(billApplyInfoVO, (Page<Map<String, Object>>)page) : this.billApplyInfoMapper.getListPageForQryBillApply(billApplyInfoVO, (Page<Map<String, Object>>)page);
        ArrayList<BusiQueryBillApplyInfoDetailRspBO> rows = new ArrayList<BusiQueryBillApplyInfoDetailRspBO>();
        for (BillApplyInfo billApplyInfo : billApplyInfoList) {
            BusiQueryBillApplyInfoDetailRspBO row = new BusiQueryBillApplyInfoDetailRspBO();
            BeanUtils.copyProperties((Object)billApplyInfo, (Object)row);
            try {
                ProjectInfoBO projectInfoBO = this.organizationInfoService.queryProjectName(billApplyInfo.getPurchaseProjectId());
                if (projectInfoBO != null) {
                    row.setPurchaseProjectName(projectInfoBO.getAccountName());
                }
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u63a5\u53e3\u5f02\u5e38");
            }
            SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
            saleInvoiceInfoVO.setApplyNo(billApplyInfo.getApplyNo());
            List<SaleInvoiceInfo> saleInvoiceInfoList = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
            StringBuilder invoiceNos = new StringBuilder();
            StringBuilder invoiceDates = new StringBuilder();
            if (saleInvoiceInfoList != null && !saleInvoiceInfoList.isEmpty()) {
                for (SaleInvoiceInfo saleInvoiceInfo : saleInvoiceInfoList) {
                    if (SaleInvoiceInfoInvoiceStatus.CANCEL.getCode().equals(saleInvoiceInfo.getInvoiceStatus())) {
                        invoiceNos.append("(").append(saleInvoiceInfo.getInvoiceNo()).append("\u4f5c\u5e9f),");
                    } else {
                        invoiceNos.append(saleInvoiceInfo.getInvoiceNo()).append(",");
                    }
                    invoiceDates.append(new SimpleDateFormat("yyyy-MM-dd").format(saleInvoiceInfo.getInvoiceDate())).append(",");
                }
                invoiceNos = new StringBuilder(invoiceNos.substring(0, invoiceNos.length() - 1));
                invoiceDates = new StringBuilder(invoiceDates.substring(0, invoiceDates.length() - 1));
            }
            row.setInvoiceNos(invoiceNos.toString());
            row.setInvoiceDates(invoiceDates.toString());
            row.setBillStatusDescr(this.enumsService.getDescr(BillStatus.getInstance(billApplyInfo.getBillStatus())));
            row.setSourceDescr(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)billApplyInfo.getSource())));
            row.setSubUserName(this.userInfoService.queryUserNameByUserId(billApplyInfo.getUserId()));
            rows.add(row);
        }
        BusiQueryBillApplyInfoRspBO rspBO = new BusiQueryBillApplyInfoRspBO();
        rspBO.setRows(rows);
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }
}

