/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.busi.api.BusiQueryDetailSupplierPayRecAmtConfirmService;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryDetailHeadSupplierPayRecAmtConfirmRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryDetailListSupplierPayRecAmtConfirmRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryDetailSupplierPayRecAmtConfirmReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryDetailSupplierPayRecAmtConfirmRspBO;
import com.tydic.fsc.settle.dao.AdvanceReceiveMapper;
import com.tydic.fsc.settle.dao.InquiryPayOrderMapper;
import com.tydic.fsc.settle.dao.RecAmtConfirmMapper;
import com.tydic.fsc.settle.dao.RecvAmtDetailMapper;
import com.tydic.fsc.settle.dao.po.AdvanceReceive;
import com.tydic.fsc.settle.dao.po.InquiryPayOrder;
import com.tydic.fsc.settle.dao.po.RecAmtConfirm;
import com.tydic.fsc.settle.dao.po.RecvAmtDetail;
import com.tydic.fsc.settle.dao.vo.AdvanceReceiveVO;
import com.tydic.fsc.settle.dao.vo.RecvAmtDetailVO;
import com.tydic.fsc.settle.enums.AdvanceReceiveStatus;
import com.tydic.fsc.settle.enums.BaseEnums;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.ReceiveType;
import com.tydic.fsc.settle.utils.FileUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiQueryDetailSupplierPayRecAmtConfirmServiceImpl
implements BusiQueryDetailSupplierPayRecAmtConfirmService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQueryDetailSupplierPayRecAmtConfirmServiceImpl.class);
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private RecAmtConfirmMapper recAmtConfirmMapper;
    @Autowired
    private AdvanceReceiveMapper advanceReceiveMapper;
    @Autowired
    private RecvAmtDetailMapper recvAmtDetailMapper;
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;

    public BusiQueryDetailSupplierPayRecAmtConfirmRspBO queryDetailSupplierPayRecAmtConfirm(BusiQueryDetailSupplierPayRecAmtConfirmReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u4f9b\u5e94\u5546\u7f34\u8d39\u6536\u6b3e\u786e\u8ba4\u5355\u8be6\u60c5\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getDocNum() == null) {
            throw new BusinessException("1001", "\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RecAmtConfirm recAmtConfirm = this.recAmtConfirmMapper.selectByPrimaryKey(reqBO.getDocNum());
        AdvanceReceiveVO advanceReceiveVO = new AdvanceReceiveVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)advanceReceiveVO);
        advanceReceiveVO.setOrderBy("tt.SEQ desc");
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<AdvanceReceive> rows = this.advanceReceiveMapper.selectListPageDlzq(advanceReceiveVO, (Page<Map<String, Object>>)page);
        BusiQueryDetailSupplierPayRecAmtConfirmRspBO rspBO = new BusiQueryDetailSupplierPayRecAmtConfirmRspBO();
        BusiQueryDetailHeadSupplierPayRecAmtConfirmRspBO head = new BusiQueryDetailHeadSupplierPayRecAmtConfirmRspBO();
        rspBO.setHead(head);
        ArrayList<BusiQueryDetailListSupplierPayRecAmtConfirmRspBO> detailRows = new ArrayList<BusiQueryDetailListSupplierPayRecAmtConfirmRspBO>();
        rspBO.setRows(detailRows);
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(page.getPageNo());
        BeanUtils.copyProperties((Object)recAmtConfirm, (Object)head);
        head.setDocNum(String.valueOf(recAmtConfirm.getDocNum()));
        String orgName = this.organizationInfoService.queryOrgName(recAmtConfirm.getOrgId());
        head.setOrgName(orgName);
        for (AdvanceReceive row : rows) {
            BusiQueryDetailListSupplierPayRecAmtConfirmRspBO detail = new BusiQueryDetailListSupplierPayRecAmtConfirmRspBO();
            BeanUtils.copyProperties((Object)row, (Object)detail);
            detail.setPayOrgName(this.organizationInfoService.obtainOrgNameByAdvanceReceive(row));
            orgName = this.organizationInfoService.queryOrgName(row.getRecOrgId());
            detail.setRecOrgName(orgName);
            detail.setRecTypeDescr(this.enumsService.getDescr(ReceiveType.getInstance(row.getRecType())));
            detail.setStatusDescr(this.enumsService.getDescr(AdvanceReceiveStatus.getInstance(row.getStatus())));
            detail.setSourceName(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)row.getSource())));
            detail.setToReceiveAmt(detail.getTranAmt().subtract(detail.getWriteoffAmt()));
            RecvAmtDetailVO recvAmtDetailVO = new RecvAmtDetailVO();
            recvAmtDetailVO.setDocNum(recAmtConfirm.getDocNum());
            recvAmtDetailVO.setAdvRecvSeq(row.getSeq());
            RecvAmtDetailVO queryAmtDetailVO = this.recvAmtDetailMapper.selectSum2(recvAmtDetailVO);
            detail.setWriteoffAmtThisTime(queryAmtDetailVO.getAmount());
            List<RecvAmtDetail> recvAmtDetailList = this.recvAmtDetailMapper.getList(recvAmtDetailVO);
            ArrayList<String> payOrderNos = new ArrayList<String>();
            for (RecvAmtDetail recvdetail : recvAmtDetailList) {
                payOrderNos.add(recvdetail.getPayOrderNo());
            }
            List<InquiryPayOrder> inquiryPayOrderList = this.inquiryPayOrderMapper.selectByPayOrderNos(payOrderNos);
            StringBuffer allInquiryNo = new StringBuffer();
            StringBuffer allSupplierName = new StringBuffer();
            StringBuffer allMaterialsClass = new StringBuffer();
            for (InquiryPayOrder inquiryOrder : inquiryPayOrderList) {
                String supplierName;
                if (StringUtils.hasText((String)inquiryOrder.getInquiryNo())) {
                    allInquiryNo.append(inquiryOrder.getInquiryNo()).append(",");
                }
                if (StringUtils.hasText((String)(supplierName = this.organizationInfoService.querySupplierName(inquiryOrder.getSupplierId())))) {
                    allSupplierName.append(supplierName).append(",");
                }
                if (!StringUtils.hasText((String)inquiryOrder.getMaterialsClass())) continue;
                allMaterialsClass.append(inquiryOrder.getMaterialsClass()).append(",");
            }
            detail.setAllInquiryNo(this.getProcessVal(allInquiryNo));
            detail.setAllSupplierName(this.getProcessVal(allSupplierName));
            detail.setAllMaterialsClass(this.getProcessVal(allMaterialsClass));
            detail.setReceiptUrl(FileUtils.obtainOSSUrl(detail.getReceipt()));
            detailRows.add(detail);
        }
        return rspBO;
    }

    private String getProcessVal(StringBuffer sb) {
        String val = "";
        if (null != sb) {
            val = sb.length() >= 1 ? sb.toString().substring(0, sb.length() - 1) : "";
        }
        return val;
    }
}

