/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.UserInfoService;
import com.tydic.fsc.settle.bo.FscPageReqBo;
import com.tydic.fsc.settle.busi.api.BusiQuerySaleOrderInfoDlzqService;
import com.tydic.fsc.settle.busi.api.bo.BusiQuerySaleOrderInfoDlzqReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQuerySaleOrderInfoDlzqRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQuerySaleOrderInfoItemDlzqRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQuerySaleOrderInfoOrderDlzqRspBO;
import com.tydic.fsc.settle.dao.SaleItemInfoMapper;
import com.tydic.fsc.settle.dao.SaleOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.SaleItemInfo;
import com.tydic.fsc.settle.dao.po.SaleOrderInfo;
import com.tydic.fsc.settle.dao.vo.SaleItemInfoVO;
import com.tydic.fsc.settle.dao.vo.SaleOrderInfoVO;
import com.tydic.fsc.settle.enums.BaseEnums;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.OrderStatus;
import com.tydic.fsc.settle.utils.BusinessUtils;
import com.tydic.fsc.settle.utils.FscStringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiQuerySaleOrderInfoDlzqServiceImpl
implements BusiQuerySaleOrderInfoDlzqService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQuerySaleOrderInfoDlzqServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private UserInfoService userInfoService;
    private static final String OPER_UNIT_YES = "1";

    public BusiQuerySaleOrderInfoDlzqRspBO query(BusiQuerySaleOrderInfoDlzqReqBO reqBO) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u670d\u52a1(\u7535\u529b\u4e13\u533a\u3001\u8be2\u6bd4\u4ef7\u3001\u7164\u70ad\u4e13\u533a)(\u4e13\u4e1a\u516c\u53f8\u548c\u91c7\u8d2d\u5355\u4f4d\u5171\u7528)\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSource())) {
            throw new BusinessException("1001", "\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getIsOperUnit())) {
            throw new BusinessException("1001", "\u662f\u5426\u4e13\u4e1a\u516c\u53f8\u7528\u6237\u3010isOperUnit\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)saleOrderInfoVO);
        if (StringUtils.hasText((String)reqBO.getPlanUserName())) {
            List<Long> planUserIds = this.userInfoService.queryUserIdListByUserNameLike(reqBO.getPlanUserName());
            if (planUserIds == null) {
                planUserIds = new ArrayList<Long>();
            }
            if (planUserIds.isEmpty()) {
                planUserIds.add(-1L);
            }
            saleOrderInfoVO.setPlanUserIds(planUserIds);
        }
        Long operUnitNo = null;
        operUnitNo = OPER_UNIT_YES.equals(reqBO.getIsOperUnit()) ? BusinessUtils.judgeOperUnitNo(reqBO.getOperUnitNo(), reqBO.getCompanyId(), false) : BusinessUtils.judgeOperUnitNo(reqBO.getOperUnitNo(), reqBO.getCompanyId(), true);
        saleOrderInfoVO.setOperUnitNo(operUnitNo);
        ArrayList<String> sourceList = new ArrayList<String>();
        if (OrderSource.CONSULT_PRICE.getCode().equals(reqBO.getSource())) {
            sourceList.add(OrderSource.CONSULT_PRICE.getCode());
            sourceList.add(OrderSource.CONSULT_PRICE_FRAME.getCode());
        } else {
            sourceList.add(reqBO.getSource());
        }
        saleOrderInfoVO.setSource(null);
        saleOrderInfoVO.setSourceList(sourceList);
        saleOrderInfoVO.setOrderStatus(OrderStatus.NO_APPLY.getCode());
        saleOrderInfoVO.setBeginRecvDate(reqBO.getBeginRecvDate());
        saleOrderInfoVO.setEndRecvDate(reqBO.getEndRecvDate());
        saleOrderInfoVO.setSaleOrderNameLike(reqBO.getSaleOrderNameLike());
        if (saleOrderInfoVO.getOrderDateEnd() != null) {
            try {
                String orderDateEndString = new SimpleDateFormat("yyyy-MM-dd").format(saleOrderInfoVO.getOrderDateEnd()) + " 23:59:59";
                saleOrderInfoVO.setOrderDateEnd(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(orderDateEndString));
            }
            catch (ParseException e) {
                throw new BusinessException("1002", "\u683c\u5f0f\u5316\u65e5\u671f\u51fa\u9519");
            }
        }
        String orderBy = FscStringUtils.obtainOrderBy((FscPageReqBo)reqBO, "d_sale_order_info", "t.ORDER_ID DESC,t.INSPECTION_ID DESC");
        saleOrderInfoVO.setOrderBy(orderBy);
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getListPageJoinDlzq(saleOrderInfoVO, (Page<Map<String, Object>>)page);
        ArrayList<BusiQuerySaleOrderInfoOrderDlzqRspBO> orderList = new ArrayList<BusiQuerySaleOrderInfoOrderDlzqRspBO>();
        for (SaleOrderInfo saleOrderInfo : saleOrderInfoList) {
            SaleItemInfoVO vo = new SaleItemInfoVO();
            vo.setInspectionId(saleOrderInfo.getInspectionId());
            vo.setItemStatus(OrderStatus.NO_APPLY.getCode());
            List<SaleItemInfo> saleItemInfoList = this.saleItemInfoMapper.getListJoin(vo);
            ArrayList<BusiQuerySaleOrderInfoItemDlzqRspBO> itemList = new ArrayList<BusiQuerySaleOrderInfoItemDlzqRspBO>();
            for (SaleItemInfo saleItemInfo : saleItemInfoList) {
                BusiQuerySaleOrderInfoItemDlzqRspBO item = new BusiQuerySaleOrderInfoItemDlzqRspBO();
                BeanUtils.copyProperties((Object)saleItemInfo, (Object)item);
                item.setSeq(String.valueOf(saleItemInfo.getSeq()));
                item.setOrderId(String.valueOf(saleItemInfo.getOrderId()));
                item.setInspectionId(String.valueOf(saleItemInfo.getInspectionId()));
                item.setItemNo(String.valueOf(saleItemInfo.getItemNo()));
                StringBuilder specModelFigureNo = new StringBuilder();
                if (StringUtils.hasText((String)item.getSpec())) {
                    specModelFigureNo.append(item.getSpec()).append("\\");
                }
                if (StringUtils.hasText((String)item.getModel())) {
                    specModelFigureNo.append(item.getModel()).append("\\");
                }
                if (StringUtils.hasText((String)item.getFigureNo())) {
                    specModelFigureNo.append(item.getFigureNo()).append("\\");
                }
                if (specModelFigureNo.length() >= 1) {
                    item.setSpecModelFigureNo(specModelFigureNo.toString().substring(0, specModelFigureNo.length() - 1));
                }
                itemList.add(item);
            }
            BusiQuerySaleOrderInfoOrderDlzqRspBO order = new BusiQuerySaleOrderInfoOrderDlzqRspBO();
            BeanUtils.copyProperties((Object)saleOrderInfo, (Object)order);
            order.setOrderId(String.valueOf(saleOrderInfo.getOrderId()));
            order.setInspectionId(String.valueOf(saleOrderInfo.getInspectionId()));
            order.setOrderStatusDescr(this.enumsService.getDescr(OrderStatus.getInstance(saleOrderInfo.getOrderStatus())));
            order.setSourceDescr(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)saleOrderInfo.getSource())));
            order.setItemInfos(itemList);
            order.setPurchaserName(this.userInfoService.queryUserNameByUserId(order.getPurchaserId()));
            order.setPlanUserName(this.userInfoService.queryUserNameByUserId(saleOrderInfo.getPlanUserId()));
            order.setProfessionalDepartDescr(this.organizationInfoService.queryOrgName(order.getProfessionalDepartId()));
            order.setServiceDepartDescr(this.organizationInfoService.queryServiceDepartName(order.getServiceDepartId()));
            order.setBranchCompanyName(this.organizationInfoService.queryOrgName(saleOrderInfo.getBranchCompany()));
            order.setPurchaseProjectName(this.organizationInfoService.queryProjectName(saleOrderInfo.getPurchaseProjectId()).getAccountName());
            orderList.add(order);
        }
        BusiQuerySaleOrderInfoDlzqRspBO rspBO = new BusiQuerySaleOrderInfoDlzqRspBO();
        rspBO.setRows(orderList);
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(page.getPageNo());
        return rspBO;
    }
}

